/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

//TQt includes
#include <tqlayout.h>
#include <tqvgroupbox.h>
#include <tqbuttongroup.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqvbox.h>
#include <tqhbox.h>

//KDE includes
#include <tdelocale.h>
#include <tdeactioncollection.h>
#include <kbuttonbox.h>
#include <tdelistbox.h>
#include <tdefiledialog.h>
#include <kurl.h>
#include <tdemessagebox.h>
#include <kiconloader.h>
#include <kdebug.h>

//Project includes
#include "apacheOptions.h"
#include "ksystemlogConfig.h"

ApacheOptions::ApacheOptions(TQWidget *parent) :
	TQWidget(parent),
	tabs(this, "tabs"),
	apacheFileList(this, i18n("<qt><p>These files will be analyzed to display <b>Apache log</b>. This list also determines the order in which the files are read.</p></qt>")),
	apacheAccessFileList(this, i18n("<qt><p>These files will be analyzed to display <b>Apache Access log</b>. This list also determines the order in which the files are read.</p></qt>"))
	{
	
	TQHBoxLayout *layout = new TQHBoxLayout(this);
	layout->setAutoAdd(true);

	tabs.addTab(&apacheFileList, Globals::apacheMode->pixmap, Globals::apacheMode->name);
	tabs.addTab(&apacheAccessFileList, Globals::apacheAccessMode->pixmap, Globals::apacheAccessMode->name);
	
	connect(&apacheFileList, TQT_SIGNAL(fileListChanged(int)), this, TQT_SLOT(slotFileListChanged(int)));
	connect(&apacheAccessFileList, TQT_SIGNAL(fileListChanged(int)), this, TQT_SLOT(slotFileListChanged(int)));
	
	readConfig();
	

}

ApacheOptions::~ApacheOptions() {

}

bool ApacheOptions::isValid() {
	if (apacheFileList.count()>0 && apacheAccessFileList.count()>0)
		return(true);
	else
		return(false);
}

void ApacheOptions::slotFileListChanged(int itemLeft) {
	if (itemLeft==0)
		emit optionsChanged(false);
	else
		emit optionsChanged(true);
}

void ApacheOptions::saveConfig() {
	kdDebug() << "Save config from ApacheOptions" << endl;
	
	TQStringList list;
	
	int count=apacheFileList.count();
	
	for (int i=0; i<count; i++) {
		list.push_back(apacheFileList.getText(i));
	}
	
	KSystemLogConfig::setApachePaths(list);

	list.clear();
	
	count=apacheAccessFileList.count();
	
	for (int i=0; i<count; i++) {
		list.push_back(apacheAccessFileList.getText(i));
	}
	
	KSystemLogConfig::setApacheAccessPaths(list);

}

void ApacheOptions::readConfig() {
	TQStringList apacheFiles(KSystemLogConfig::apachePaths());
		
	TQStringList::iterator it;
	for(it=apacheFiles.begin(); it!=apacheFiles.end(); ++it) {
		apacheFileList.insertItem(*it);
	}

	TQStringList apacheAccessFiles(KSystemLogConfig::apacheAccessPaths());
		
	for(it=apacheAccessFiles.begin(); it!=apacheAccessFiles.end(); ++it) {
		apacheAccessFileList.insertItem(*it);
	}
}

#include "apacheOptions.moc"
