/*
** Copyright (C) 1999,2000 Toivo Pedaste <toivo@ucs.uwa.edu.au>
**
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/

#ifndef DEBAPT_IFACE_H
#define DEBAPT_IFACE_H

#include "../config.h"

#include <tdeaction.h>

#include "debInterface.h"

#define APT_SOURCE "/etc/apt/sources.list"

class DEBAPT: public DEB
{
  Q_OBJECT
  

public:
  DEBAPT();
  ~DEBAPT();

  virtual bool isType(char *buf, const TQString &fname);

  void listPackages(TQPtrList<packageInfo> *pki);
  TQStringList listInstalls(const TQStringList &packs, bool install, bool &cancel);

  TQString doUninstall(int uninstallFlags, const TQString &packs, bool &test);
  TQString doInstall(int installFlags, const TQString &packs, bool &test);
  TQString install(int installFlags, TQPtrList<packageInfo> *p,
		  bool &test);

  virtual TQStringList FindFile(const TQString &name, bool seachAll=false);

  void listRemotePackages(TQPtrList<packageInfo> *pki);
  TQStringList getFileList(packageInfo *p);

  TDEAction *updateM, *upgradeM, *fixupM, *fileM;

  void makeMenu(TDEActionCollection* act);
  void setMenu(TDEActionCollection* act, bool enable);

  TQStringList readApt();
  TQStringList readAptS();
  TQStringList readAptF();
  void writeApt(const TQStringList &list);

private slots:
  void updateS();	
  void upgradeS();
  void fixupS();
  void fileS();

private:
  void listAvail(TQPtrList<packageInfo> *pki);
  void listRPack(TQPtrList<packageInfo> *pki);
  TQStringList getRFileList(packageInfo *p);

  TQString env;
};
#endif
