/***************************************************************************
                          plugin.h  -  description
                             -------------------
    begin                : Sun Dec 30 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PLUGIN_H
#define PLUGIN_H

#include "batchrenamer.h"

#include <tqobject.h>

class HelpDialogData;

class TQString;
class TQStringList;
class TQWidget;
class TQVBoxLayout;
class Plugin : public TQObject {
    Q_OBJECT
  
    public:
        Plugin();
        virtual ~Plugin();

        virtual const TQString getName() const = 0;
        virtual const TQString getAccelName() const = 0;
        virtual const TQString getPattern() const;
        virtual const int type() const = 0;
        virtual bool alwaysUsed() const;

        virtual bool checkError() = 0;
        virtual void drawInterface( TQWidget* w, TQVBoxLayout* l ) = 0;
        virtual void fillStructure() { }
        virtual TQString processFile( BatchRenamer* b, int i, TQString token, int mode ) = 0;
        virtual void finished() { }
        
        virtual void addHelp( HelpDialogData* data );
        virtual void removeHelp(  HelpDialogData* data );

        virtual void clearCache();
        
        virtual const TQPixmap getIcon() const;
        virtual const TQStringList getKeys() const;
        
     signals:
        void previewChanged( Plugin* plugin );
        
     protected slots:
        // call this method when your plugin settings changed 
        // in a way, that KRename should update its preview
        void updatePreview()
        {
            emit previewChanged( this );
        }

     protected:
        TQWidget* m_widget;
};

#endif
