/***************************************************************************
                          fileplugin.h  -  description
                             -------------------
    begin                : Mon Jul 1 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILEPLUGIN_H
#define FILEPLUGIN_H

#include "batchrenamer.h"
#include "pluginloader.h"
#include "plugin.h"
#include "helpdialog.h"
#include <kmimetype.h>

/*
 * number of items we shall cache from file plugins
 */
#define CACHE_MAX 2000

class KFileMetaInfoProvider;
class KFileMimeTypeInfo;
class KPushButton;
class KService;
class TQLabel;
class TQWidget;
class TQVBoxLayout;
class KFilePlugin;
class FilePlugin : public Plugin  {
    Q_OBJECT
  
    public:
        FilePlugin( KService* service );
        ~FilePlugin();

        inline bool isValid() const;

        virtual const TQString getName() const;
        virtual const TQString getAccelName() const;
        virtual const TQString getPattern() const;
        virtual const int type() const;

        virtual bool checkError();
        virtual void drawInterface( TQWidget* w, TQVBoxLayout* l );
        virtual TQString processFile( BatchRenamer* b, int i, TQString token, int mode );

        virtual void addHelp( HelpDialogData* data );
        virtual const TQPixmap getIcon() const;
        
        virtual bool alwaysUsed() const { return true; }
        
        virtual const TQStringList getKeys() const { return keys; }

        virtual void clearCache();
        
    private:
        void setPattern( KMimeType::Ptr mime );
        
    protected:
        bool supports( const TQString & token );
        void setupKeys();
        
        TQMap<TQString,TQString> cache;
        KFilePlugin* fileplugin;

        TQString m_name, m_comment, m_icon, m_mimetype, m_pattern;

        TQStringList keys;
};

bool FilePlugin::isValid() const
{
    return keys.count() > 0 && fileplugin ? true : false;
}

#endif
