/***************************************************************************
                         encodingplugin.h  -  description
                             -------------------
    begin                : Tue Jul 06 2004
    copyright            : (C) 2004 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _ENCODINGPLUGIN_H_
#define _ENCODINGPLUGIN_H_

#include "batchrenamer.h"
#include "pluginloader.h"
#include "plugin.h"
#include "helpdialog.h"
#include "fileoperation.h"

class KComboBox;
class TQCheckBox;

class EncodingPlugin : public Plugin  {
    Q_OBJECT
  
    public:
        const TQString getName() const;
        const TQString getAccelName() const;
        const int type() const;

        bool checkError();
        void drawInterface( TQWidget* w, TQVBoxLayout* l );
        void fillStructure();
        TQString processFile( BatchRenamer*, int, TQString token, int );
        void finished();

        const TQPixmap getIcon() const;

     private slots:
	 void enableControls();

     private:
	void setLocale( KComboBox* combo );

	FileOperation fop;

	TQString m_input_codec;
	TQString m_output_codec;
	TQString m_locale_codec;

	int mib_input;
	int mib_output;
 
	TQCheckBox* checkInput;
	TQCheckBox* checkOutput;

	KComboBox* comboInput;
	KComboBox* comboOutput;
};


#endif //  _ENCODINGPLUGIN_H_
