/***************************************************************************
    Copyright (C) 2004 Christian Hubinger
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//
// C++ Implementation: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfruleoptioneditlimit.h"


// QT includes
#include <tqstring.h>

// KDE includes
#include <kdebug.h>
#include <tdelocale.h>

// Project includes
#include "../../core/iptrule.h"
#include "../../core/kmfruleeditinterface.h"
#include "kmfruleeditorlimit.h"

namespace KMF {
KMFRuleOptionEditLimit::KMFRuleOptionEditLimit(TQObject *parent, const char *name)
		: KMFRuleOptionEditInterface(parent, name) {
	kdDebug() <<"KMFRuleOptionEditLimit::KMFRuleOptionEditLimit(TQObject *parent, const char *name)" << endl;
	kdDebug() << "Parent has Type: " << parent->className()  << endl;
	
	m_edit = new KMFRuleEditorLimit( 0 , "Edit", 0 );
	m_edit->hide();

	connect( m_edit,TQT_SIGNAL(sigHideMe() ), 
		this,TQT_SLOT( slotShowOverview() ) );
}
KMFRuleOptionEditLimit::~KMFRuleOptionEditLimit() {}


void KMFRuleOptionEditLimit::slotShowOverview() {
	if ( KMFRuleEditInterface* ruleedit = dynamic_cast<KMFRuleEditInterface*> ( parent() ) ) {
		ruleedit->showOverview();
	} else {
		kdDebug() << "KMFRuleOptionEditCustom::slotShowOverview(): parent() not of type KMFRuleEditInterface" << endl;
	}
}

const TQString& KMFRuleOptionEditLimit::optionEditName() const {
	return *( new TQString( i18n("Limit Option") ) );
}

const TQString& KMFRuleOptionEditLimit::description() const {
	return *( new TQString( i18n("This plugin manages the Limit options of iptables.") ) );
}

void KMFRuleOptionEditLimit::loadRule( IPTRule* rule ) {
	if ( !rule ) {
		kdDebug() << "KMFRuleOptionEditLimit::loadRule( IPTRule* rule ) - rule == 0" << endl;
		return;
	}
	
	m_edit->loadRule( rule );
	m_rule = rule;

}

TQWidget* KMFRuleOptionEditLimit::editWidget() {
	if ( ! m_edit ) {
		kdDebug() << "KMFRuleOptionEditLimit::editWidget() - m_edit == 0" << endl;
		return 0;
	}
	return m_edit;
}





// It's usually safe to leave the factory code alone.. with the
// notable exception of the TDEAboutData data
#include <tdeaboutdata.h>
#include <tdelocale.h>

// TDEInstance* KMFRuleOptionEditLimitFactory::s_instance = 0L;
// TDEAboutData* KMFRuleOptionEditLimitFactory::s_about = 0L;

KMFRuleOptionEditLimitFactory::KMFRuleOptionEditLimitFactory( TQObject* parent, const char* name )
		: KLibFactory( parent, name ) {
// 	s_instance = new TDEInstance( "KMFRuleOptionEditLimitFactory" );
}

TQObject* KMFRuleOptionEditLimitFactory::createObject( TQObject* parent, const char* name,
        const char*, const TQStringList & ) {
	TQObject * obj = new KMFRuleOptionEditLimit( parent, name );
	emit objectCreated( obj );
	return obj;
}


// TDEInstance* KMFRuleOptionEditLimitFactory::instance() {
// 	if ( !s_instance ) {
// 		s_instance = new TDEInstance( "KMFRuleOptionEditLimitFactory" );
// 	}
// 	return s_instance;
// }

extern "C" {
	void* init_libkmfruleoptionedit_limit() {
		return new KMFRuleOptionEditLimitFactory;
	}
}


}

#include "kmfruleoptioneditlimit.moc"
