//
// C++ Implementation:
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include "kmfprotocolpropertieswidget.h"

// QT includes
#include <tqlistview.h>
#include <tqcheckbox.h>
#include <tqspinbox.h>
#include <tqcombobox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqgroupbox.h>
#include <tqwidgetstack.h>
#include <tqtextedit.h>
#include <tqframe.h>

// KDE includes
#include <kdebug.h>
#include <tdelocale.h>
#include <tdelistview.h>
#include <kcombobox.h>
#include <tdepopupmenu.h>
#include <kiconloader.h>
#include <kinputdialog.h>
#include <knuminput.h>

// Project Includes
#include "../core/kmfnethost.h"
#include "../core/kmfnetzone.h"
#include "../core/kmfundoengine.h"
#include "../core/kmfprotocol.h"
#include "../core/kmfprotocolusage.h"
#include "../core/kmfprotocolcategory.h"
namespace KMF {
KMFProtocolPropertiesWidget::KMFProtocolPropertiesWidget ( TQWidget* parent, const char* name, WFlags fl )
		: KMyFirewallProtocolPropertiesWidget ( parent,name,fl ) {
		
	connect( m_cb_limit, TQT_SIGNAL( toggled( bool ) ),
		this, TQT_SLOT( slotEnableProtocolLimit( bool ) ) );
				
	connect( m_sb_limit_rate, TQT_SIGNAL( valueChanged( int ) ),
		this, TQT_SLOT( slotSetProtocolLimitRate( int ) ) );
	
	connect( m_cb_limit_interval, TQT_SIGNAL( highlighted( const TQString& ) ), 	this, TQT_SLOT( slotSetProtocolLimitInterval( const TQString& ) ) );

	connect( m_cb_log, TQT_SIGNAL( toggled( bool ) ),
		this, TQT_SLOT( slotEnableProtocolLogging( bool ) ) );
	
}

KMFProtocolPropertiesWidget::~KMFProtocolPropertiesWidget() {}

/*$SPECIALIZATION$*/

void KMFProtocolPropertiesWidget::slotProtocolDeleted() {
	m_gb_protocol_option->setEnabled( false );
	m_gb_protocol_description->setEnabled( true );
	m_protocolUsage = 0;
}	

void KMFProtocolPropertiesWidget::blockAllSignals( bool onoff ) {
	m_cb_limit->blockSignals( onoff );
	m_sb_limit_rate->blockSignals( onoff );
	m_cb_limit_interval->blockSignals( onoff );
	m_cb_log->blockSignals( onoff );
}

void KMFProtocolPropertiesWidget::loadProtocolCategory( KMFProtocolCategory* protCat ) {
	blockAllSignals( true );
	m_gb_protocol_option->setEnabled( false );
	m_gb_protocol_description->setEnabled( true );
	m_l_protocol_desc->setEnabled( true );
	TQString text = i18n( "<qt><b>Description: </b>%1<br>" ).arg( protCat ->description() );
	text += "</qt>";
	
	m_l_protocol_desc->setText( text );
	blockAllSignals( false );
}

void KMFProtocolPropertiesWidget::loadProtocol( KMFProtocol* prot ) {
	blockAllSignals( true );
	m_gb_protocol_option->setEnabled( false );
	m_gb_protocol_description->setEnabled( true );
	m_l_protocol_desc->setEnabled( true );
	TQString text = i18n( "<qt><b>Description: </b>%1<br>" ).arg( prot ->description() );
	const TQString& tcpports = prot->tcpPortsList();
	
	if ( ! tcpports.isEmpty() ) {
		text += i18n( "<b>Affected TCP ports: </b>" );
		text += tcpports;
		text +="<br>";
	}
	const TQString& udpports = prot->udpPortsList();
	if ( ! udpports.isEmpty() ) {
		text += i18n( "<b>Affected UDP ports: </b>" );
		text += udpports;
	}
	text += "</qt>";
	
	m_l_protocol_desc->setText( text );
	blockAllSignals( false );
}

void KMFProtocolPropertiesWidget::loadProtocolUsage( KMFProtocolUsage* prot ) {

	kdDebug() << "KMFNetHostPropertiesWidget::loadTarget( KMFNetHost* host " << endl;
	if ( ! prot ) {
		return;
	}
	
	if ( m_protocolUsage ) {
		disconnect( m_protocolUsage, TQT_SIGNAL( destroyed() ),
			this,TQT_SLOT( slotProtocolDeleted() ) );
	}
	
	m_protocolUsage = prot;
	connect( m_protocolUsage, TQT_SIGNAL( destroyed() ),
			this,TQT_SLOT( slotProtocolDeleted() ) );
	setEnabled( true );
	
	blockAllSignals( true );
	loadProtocol( m_protocolUsage->protocol() );
	
	m_gb_protocol_option->setEnabled( true );
	m_gb_protocol_description->setEnabled( true );
	m_cb_log->setChecked( m_protocolUsage->logging() );
	if ( m_protocolUsage ->limit() > 0 ) {
		m_cb_limit->setChecked( true );
		m_sb_limit_rate->setValue( m_protocolUsage ->limit() );
		if ( m_protocolUsage ->limitInterval() == "second" )
			m_cb_limit_interval->setCurrentItem( 0 );
		if ( m_protocolUsage ->limitInterval() == "minute" )
			m_cb_limit_interval->setCurrentItem( 1 );
		if ( m_protocolUsage ->limitInterval() == "hour" )
			m_cb_limit_interval->setCurrentItem( 2 );
	} else {
		m_cb_limit->setChecked( false );
	}
	
	blockAllSignals( false );
}

void KMFProtocolPropertiesWidget::slotEnableProtocolLimit( bool onoff ) {
	kdDebug() << "void KMFProtocolPropertiesWidget::slotEnableProtocolLimit( bool )" << endl;
	if ( ! m_protocolUsage ) {
		kdDebug() << "WARNING: No Current Protocol activated" << endl;
		return;
	}
	if ( onoff ) {
		KMFUndoEngine::instance()->startTransaction(
			m_protocolUsage,
			i18n("Enable package limit for protocol %1.").arg( m_protocolUsage->name() )
		);
		m_protocolUsage->setLimit( m_sb_limit_rate->value() );
		m_protocolUsage->setLimitInterval( m_cb_limit_interval->currentText() );
		KMFUndoEngine::instance()->endTransaction();
	} else {
		KMFUndoEngine::instance()->startTransaction(
			m_protocolUsage,
			i18n("Sisable package limit for protocol %1.").arg( m_protocolUsage->name() )
		);
		m_protocolUsage->setLimit( -1 );
		KMFUndoEngine::instance()->endTransaction();
	}
}
void KMFProtocolPropertiesWidget::slotSetProtocolLimitRate( int rate ){
	kdDebug() << "void KMFProtocolPropertiesWidget::slotSetProtocolLimitRate( int )" << endl;
	if ( ! m_protocolUsage ) {
		kdDebug() << "WARNING: No Current Protocol activated" << endl;
		return;
	}
	
	
	KMFUndoEngine::instance()->startTransaction(
		m_protocolUsage,
		i18n("Set package limit for protocol %1 to %2/%3.").arg( m_protocolUsage->name() ).arg( rate ).arg( m_protocolUsage->limitInterval() )
	);
	m_protocolUsage->setLimit( rate );
	KMFUndoEngine::instance()->endTransaction();
}

void KMFProtocolPropertiesWidget::slotSetProtocolLimitInterval( const TQString& interval ){
	kdDebug() << "void KMFProtocolPropertiesWidget::slotSetProtocolLimitInterval( const TQString& )" << endl;
	if ( ! m_protocolUsage ) {
		kdDebug() << "WARNING: No Current Protocol activated" << endl;
		return;
	}
	if ( interval.isEmpty() ) {
		return;
	}
	
	KMFUndoEngine::instance()->startTransaction(
		m_protocolUsage,
		i18n("Set package limit for protocol %1 to %2/%3.").arg( m_protocolUsage->name() ).arg( m_protocolUsage->limit() ).arg( interval )
	);
	m_protocolUsage->setLimitInterval( interval );
	KMFUndoEngine::instance()->endTransaction();
}

void KMFProtocolPropertiesWidget::slotEnableProtocolLogging( bool onoff ){
	kdDebug() << "void KMFGenericInterfaceProtocol::slotEnableProtocolLogging( bool )" << endl;
	if ( ! m_protocolUsage ) {
		kdDebug() << "WARNING: No Current Protocol activated" << endl;
		return;
	}
	
	KMFUndoEngine::instance()->startTransaction(
		m_protocolUsage,
		i18n( "%1 logging of dropped packets for protocol %2." ).arg( onoff ? i18n( "Enable" ) : i18n( "Disable" ) ).arg( m_protocolUsage->name() )
	);
	
	m_protocolUsage->setLogging( onoff );
	KMFUndoEngine::instance()->endTransaction();
}

}

#include "kmfprotocolpropertieswidget.moc"

