/***************************************************************************
begin                : Tue Aug 20 2002
copyright            : (C) 2002 by Christian Hubinger
email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IPTABLE_H
#define IPTABLE_H

/**Class that represents the properties of a "table" in the iptables
 
  *@author Christian Hubinger
  */

#include "netfilterobject.h"

// qt includes
#include <tqptrlist.h>
#include <tquuid.h>
// project includes
#include "iptchain.h"
// qt classes
class TQString;
namespace KMF {
// project classes
class KMFError;
class KMFIPTDoc;


class KDE_EXPORT IPTable : public NetfilterObject {
public:
	/** initialise a IPTable with the given name */
	IPTable( KMFIPTDoc*, const char* name, const TQString& tableName );
	~IPTable();

	virtual int type();
	virtual void clear();
	
	/** Set the used flag */
	void setUsed( bool used ) {
		m_used = used;
	};

	/** Simply deletes all chains */
	void reset();

	/** Return the IPTChain with the name provided */
	IPTChain* chainForName( const TQString& );
	
	/** Return the IPTChain for the given ID */
	IPTChain* chainForUuid( const TQUuid& );

	/**  Add a new IPTChain object to this table with the given prperties */
	IPTChain* addChain( const TQString& chain_name,
	                    const TQString& chain_target,
	                    bool builtin,
	                    KMFError* );

	/** Remove the given IPTChain */
	KMFError* delChain( IPTChain *chain );


	/** Move rule to target_chain */
	KMFError* moveRuleToChain( IPTRule* rule, IPTChain *target_chain );

	/** Copy rule to target_chain */
	KMFError* copyRuleToChain( IPTRule* rule, IPTChain *target_chain );

	/** Return a pointer to KMFIPTDoc object to which this
		table belongs */
	KMFIPTDoc* kmfDoc() const {
		return kmfdoc;
	};


	/** Returns true if it used by the current configuration */
	bool used() const {
		return m_used;
	};

	/** Returns the list with the iptchains in this table */
	TQPtrList<IPTChain>& chains() const;

	/** Return a TQDomDocument representation of this Table */
	virtual const TQDomDocument& getDOMTree();
	
	/** Load the Table from the TQDomDocument */
	virtual void loadXML( const TQDomDocument&, TQStringList& errors );
	
	/** Load Table From DomNode */
	virtual void loadXML( TQDomNode, TQStringList& errors );
	
	/** Stup the built-in chains */
	void settupDefaultChains();

private:
	/** the list holding the chains in this table */
	private: TQPtrList<IPTChain> m_chains;

	/** used by the current configuration */
	private: bool m_used;


	private: KMFError* m_err;
	private: KMFIPTDoc* kmfdoc;
};
}
#endif


