// (c) 2000 Peter Putzer

#ifndef PROPERTIES_H
#define PROPERTIES_H

#include <kpropertiesdialog.h>

class TQHBox;
class TQVBox;
class TQTextView;
class TQSpinBox;

class KLineEdit;

class KSVData;

class KSVServicePropertiesDialog : public KPropertiesDialog
{
  Q_OBJECT
  

public:
  KSVServicePropertiesDialog (KSVData& data, TQWidget* parent);
  virtual ~KSVServicePropertiesDialog ();

signals:
  void startService (const TQString&);
  void stopService (const TQString&);
  void restartService (const TQString&);
  void editService (const TQString&);

private slots:
  void doEdit ();
  void doStart ();
  void doStop ();
  void doRestart ();

private:
  KSVData& mData;
};


class KSVEntryPropertiesDialog : public KPropertiesDialog
{
  Q_OBJECT
  

public:
  KSVEntryPropertiesDialog (KSVData& data, TQWidget* parent);
  virtual ~KSVEntryPropertiesDialog ();

signals:
  void startService (const TQString&);
  void stopService (const TQString&);
  void restartService (const TQString&);
  void editService (const TQString&);

private slots:
  void doEdit ();
  void doStart ();
  void doStop ();
  void doRestart ();

private:
  KSVData& mData;
};

class KSVEntryPage : public KPropsDlgPlugin
{
  Q_OBJECT
  

public:
  KSVEntryPage (KSVData& data, KPropertiesDialog* props);
  virtual ~KSVEntryPage ();

  virtual void applyChanges ();

  inline int pageIndex () const { return mIndex; }

private slots:
  void emitChanged ();

private:
  KSVData& mData;
  TQFrame* mPage;
  int mIndex;

  KLineEdit* mServiceEdit;
  KLineEdit* mLabelEdit;
  TQSpinBox* mNumberEdit;
};

class KSVServicesPage : public KPropsDlgPlugin
{
  Q_OBJECT
  

public:
  KSVServicesPage (KSVData& data, KPropertiesDialog* props);
  virtual ~KSVServicesPage ();

  virtual void applyChanges ();

  inline int pageIndex () const { return mIndex; }

private:
  KSVData& mData;
  TQVBox* mPage;
  TQTextView* mDesc;
  int mIndex;
};

#endif // PROPERTIES_H
