/***************************************************************************
                          kxechardatadialog.cpp  -  description
                          ---------------------
    begin                : Don Apr 25 2002
    copyright            : (C) 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxechardatadialog.h"

#include <tqlabel.h>
#include <tqcombobox.h>
#include <tqpushbutton.h>
#include <tqtextedit.h>

#include <kdebug.h>
#include <tdelocale.h>

KXECharDataDialog::KXECharDataDialog( TQWidget * pParent, const char * pszName, bool fModal, WFlags fl )
	: KXECharDataDialogBase( pParent, pszName, fModal, fl )
{
	connect( m_pEditData, SIGNAL(textChanged()), this, SLOT(slotDataChanged()) );
}

void KXECharDataDialog::clearDialog()
{
	m_pEditData->clear();
}

int KXECharDataDialog::exec( bool bEditExisting )
{
  if(bEditExisting)
    {
      m_pComboInsert->hide();
      m_pComboInsert->setDisabled(true);
      m_pLblInsert->hide();
      m_pLblInsert->setDisabled(true);

//      m_pComboType->setDisabled(true);

      m_pEditData->setText( m_strContents );
//      m_pComboType->setCurrentItem(m_eCharDataKind);
    }
  else
  {
//    m_pComboType->setEnabled(true);
    clearDialog();
  }

	int iReturn = exec();
	if ( iReturn == Accepted )
	{
    m_strContents = m_pEditData->text();
    m_bAtTop = ( m_pComboInsert->currentItem() == 0 );
//    m_eCharDataKind = (CharDataKind) m_pComboType->currentItem();
	}

	return iReturn;
}

int KXECharDataDialog::exec()
{
	if ( m_pEditData->text().isEmpty() )
		m_pBtnOK->setEnabled(false);
	else
		m_pBtnOK->setEnabled(true);
		
	m_pEditData->setFocus();
	m_pBtnOK->setDefault(true);

	return KXECharDataDialogBase::exec();
}

void KXECharDataDialog::slotDataChanged()
{
	TQString strMessage = checkContents(m_pEditData->text());

  m_pTextLabelMessage->setText(strMessage);

	if ( m_pEditData->text().isEmpty()  || (strMessage.length() > 0))
		m_pBtnOK->setEnabled(false);
	else
		m_pBtnOK->setEnabled(true);
}

// Check, if XML chardata contents is OK
TQString KXECharDataDialog::checkContents(const TQString strData)
{
  if(strData.length() == 0)
    return  "";

  // Forbidden characters
  /*TQString strForbiddenChars("<>");
  for(unsigned int i = 0; i < strForbiddenChars.length(); i++)
  {
    TQChar ch = strForbiddenChars[i];

    if(strData.find(ch) >= 0)
      return i18n("Contents cannot contain character: %1 !").arg(ch);
  }
	
	L.V. Removed this check, bacause TQDomCharacterData.setData() escapec special
	charactesr and data() unescapes it back to original string
	
	*/

  return "";
}

#include "kxechardatadialog.moc"
