/**************************************************************************
                          kgpgview.h  -  description
                             -------------------
    begin                : Tue Jul  2 12:31:38 GMT 2002
    copyright          : (C) 2002 by Jean-Baptiste Mardelle
    email                : bj@altern.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KGPGVIEW_H
#define KGPGVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ktextedit.h>
#include <kurl.h>

class TQDragEnterEvent;

//class KgpgDoc;

/** The KgpgView class provides the view widget for the KgpgApp instance.
 * The View instance inherits TQWidget as a base class and represents the view object of a KTMainWindow. As KgpgView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the KgpgApp class to manipulate and display
 * the document structure provided by the KgpgDoc class.
 *
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */

class MyEditor : public KTextEdit
{
        TQ_OBJECT
  

public:
        MyEditor( TQWidget *parent = 0, const char *name = 0);
private:
        TQString message,messages,tempFile;
public slots:
        void slotDecodeFile(TQString);
        void slotDroppedFile(KURL url);
        void slotProcessResult(TQStringList iKeys);
	bool slotCheckContent(TQString fileToCheck, bool checkForPgpMessage=true);

protected:
        void contentsDragEnterEvent( TQDragEnterEvent *e );
        void contentsDropEvent( TQDropEvent *e );
	
private slots:
	void editorUpdateDecryptedtxt(TQString newtxt);
	void editorFailedDecryptedtxt(TQString newtxt);

signals:
	void refreshImported(TQStringList);
};


class KgpgView : public TQWidget
{
        TQ_OBJECT
  
        friend class MyEditor;
public:
        /** Constructor for the main view */
        KgpgView(TQWidget *parent = 0, const char *name=0);
        /** Destructor for the main view */
        ~KgpgView();

        /** returns a pointer to the document connected to the view instance. Mind that this method requires a KgpgApp instance as a parent
         * widget to get to the window document pointer by calling the KgpgApp::getDocument() method.
         *
         * @see KgpgApp#getDocument
         */
        //  KgpgDoc *getDocument() const;

        //        TQTextEdit  *editor;

        MyEditor *editor;
        KURL fselected;
	bool windowAutoClose;

        /** contains the implementation for printing functionality */
        //    void print(TQPrinter *pPrinter);

        TQPushButton *bouton1,*bouton2,*bouton0;
private:
        TQString messages;

public slots:
        void slotdecode();
	void clearSign();

private slots:
	void slotVerifyResult(TQString mssge,TQString log);
	void slotSignResult(TQString signResult);
	void slotAskForImport(TQString ID);
        void popuppublic();
        void modified();
        void encodetxt(TQStringList selec,TQStringList encryptOptions,bool, bool symmetric);
        void updatetxt(TQString);
	void updateDecryptedtxt(TQString newtxt);
	void failedDecryptedtxt(TQString newtxt);
	bool checkForUtf8(TQString text);
	
signals:
	void resetEncoding(bool);
	void verifyFinished();
	void verifyDetach();
};

#endif // KGPGVIEW_H

