/* ============================================================
 * File  : gallerylist.cpp
 * Author: Colin Guthrie <kde@colin.guthr.ie>
 * Date  : 2006-09-04
 * Copyright 2006 by Colin Guthrie <kde@colin.guthr.ie>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// Include files for TQt

#include <tqlistview.h>
#include <tqpushbutton.h>
#include <tqtimer.h>
#include <tqpixmap.h>
#include <tqcursor.h>
#include <tqlineedit.h>
#include <tqprogressdialog.h>
#include <tqspinbox.h>
#include <tqcheckbox.h>
#include <tqlayout.h>

// Include files for KDE

#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdeapplication.h>
#include <kiconloader.h>

// Local includes.

#include "galleries.h"
#include "gallerylist.h"
#include "galleryconfig.h"

namespace KIPIGalleryExportPlugin
{

GalleryList::GalleryList(TQWidget *pParent, Galleries* pGalleries, bool blnShowOpen)
    : KDialogBase(pParent, 0, true, i18n("Remote Galleries"),
                  Ok|Close|User1|User2|User3,
                  Close, false),
      mpGalleries(pGalleries),
      mpCurrentGallery(0)
{
  if (!blnShowOpen)
    showButtonOK(false);

  setButtonGuiItem(User3, KStdGuiItem::add());
  setButtonGuiItem(User2, KStdGuiItem::configure());
  setButtonGuiItem(User1, KStdGuiItem::remove());
  setButtonGuiItem(Close, KStdGuiItem::close());
  setButtonGuiItem(Ok,    KStdGuiItem::open());

  enableButton(Ok,    false);
  enableButton(User1, false);
  enableButton(User2, false);

  TQFrame *page = new TQFrame(this);
  TQHBoxLayout *tll = new TQHBoxLayout(page);
  page->setMinimumSize(400, 200);
  setMainWidget(page);

  TQHBoxLayout *hb = new TQHBoxLayout();
  hb->setSpacing(KDialog::spacingHint());
  tll->addItem(hb);

  TQLabel *label = new TQLabel(page);
  hb->addWidget(label);
  label->setPixmap(UserIcon("gallery"));
  label->setFrameStyle (TQFrame::Panel | TQFrame::Sunken);
  label->setAlignment(TQt::AlignTop);
  TQVBoxLayout *vb = new TQVBoxLayout();
  vb->setSpacing (KDialog::spacingHint());
  tll->addItem(vb);

  mpGalleryList = mpGalleries->asTQListView(page);
  vb->addWidget(mpGalleryList);
  connect(mpGalleryList, TQ_SIGNAL(selectionChanged()), this, TQ_SLOT(selectionChanged()));
  connect(mpGalleryList, TQ_SIGNAL(doubleClicked(TQListViewItem*, const TQPoint&, int)),
          this, TQ_SLOT(doubleClicked(TQListViewItem*, const TQPoint&, int)));
}

GalleryList::~GalleryList()
{

}

Gallery* GalleryList::GetGallery()
{
  return mpCurrentGallery;
}

void GalleryList::selectionChanged()
{
  TQListViewItem* p_lvi = mpGalleryList->selectedItem();
  bool bln_selected = (p_lvi ? true : false);
  enableButton(User1, bln_selected);
  enableButton(User2, bln_selected);
  enableButton(Ok,    bln_selected);

  if (bln_selected)
  {
    GalleryTQListViewItem* p_glvi = dynamic_cast<GalleryTQListViewItem*>(p_lvi);
    mpCurrentGallery = p_glvi->GetGallery();
  }
  else
  {
    mpCurrentGallery = 0;
  }
}

void GalleryList::doubleClicked(TQListViewItem* pCurrent, const TQPoint&, int)
{
  if (!pCurrent)
    return;

  if (actionButton(Ok)->isVisible())
  {
    accept();
  }
  else
  {
    slotUser2();
  }
}

//==================   Add   =====
void GalleryList::slotUser3(void)
{
  Gallery* p_gallery = new Gallery();
  GalleryEdit dlg(this, p_gallery, i18n("New Remote Gallery"));
  if (TQDialog::Accepted == dlg.exec())
  {
    mpGalleries->Add(p_gallery);
    mpGalleries->Save();
    p_gallery->asTQListViewItem(mpGalleryList);
  }
  else
  {
    delete p_gallery;
  }
}


//==================   Edit  ======
void GalleryList::slotUser2(void)
{
  TQListViewItem* p_lvi = mpGalleryList->selectedItem();
  if (!p_lvi)
  {
    KMessageBox::error(tdeApp->activeWindow(), i18n("No gallery selected!"));
  }
  else
  {
    GalleryTQListViewItem* p_glvi = dynamic_cast<GalleryTQListViewItem*>(p_lvi);
    GalleryEdit dlg(this, p_glvi->GetGallery(), i18n("Edit Remote Gallery"));
    if (TQDialog::Accepted == dlg.exec())
    {
      p_glvi->Refresh();
      mpGalleries->Save();
    }
  }
}


//==================  Remove ======
void GalleryList::slotUser1(void)
{
  TQListViewItem* p_lvi = mpGalleryList->selectedItem();
  if (!p_lvi)
  {
    KMessageBox::error(tdeApp->activeWindow(), i18n("No gallery selected!"));
  }
  else
  {
    if (KMessageBox::Yes == 
          KMessageBox::warningYesNo(tdeApp->activeWindow(),
            i18n("Are you sure you want to remove this gallery? "
                 "All synchronisaton settings will be lost. "
                 "You cannot undo this action."), 
            i18n("Remove Remote Gallery"), 
            KStdGuiItem::yes(), KStdGuiItem::no(),
            TQString(), KMessageBox::Dangerous))
    {
      GalleryTQListViewItem* p_glvi = dynamic_cast<GalleryTQListViewItem*>(p_lvi);
      Gallery* p_gallery = p_glvi->GetGallery();
      delete p_glvi;
      mpGalleries->Remove(p_gallery);
      mpGalleries->Save();
    }
  }
}

}

#include "gallerylist.moc"

