/***************************************************************************
 *
 * tdenetman-vpnservice.h - A NetworkManager frontend for TDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>
 *         Helmut Schaa <hschaa@suse.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef TDENETWORKMANAGER_VPN_SERVICE_H
#define TDENETWORKMANAGER_VPN_SERVICE_H

#include <tqobject.h>
#include <tqguardedptr.h>

#include "tdenetman.h"
#include "tdenetman-vpnplugin.h"

class TDENetworkManager;
class VPNService;
class TDEConfigGroup;

class VPNService : public TQObject
{
	TQ_OBJECT
  

	public:
	  VPNService(const TQString& serviceName, const TQString& service, TQObject* parent, const char* name = 0);
	  ~VPNService();

	  TQString getDisplayName() const;
	  TQString getName() const;
	  TQString getService() const;
	  VPNPlugin* getVPNPlugin();
	  TQString getIcon();

	private:
	  TQString _name;
	  TQString _service;
	  TQGuardedPtr<VPNPlugin> _vpnPlugin;
};

#endif /* TDENETWORKMANAGER_VPN_SERVICE_H */
