/*
    tdeabcexport.h - Export Contacts to Address Book Wizard for Kopete

    Copyright (c) 2005 by Will Stephenson        <will@stevello.free-online.co.uk>

    Kopete    (c) 2002-2005 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef TDEABCEXPORTWIZARD_H
#define TDEABCEXPORTWIZARD_H

#include "tdeabcexport_base.h"

namespace TDEABC {
	class AddressBook;
	class Addressee;
}

namespace Kopete {
	class MetaContact;
}

namespace KRES {
	class Resource;
}

class KabcExportWizard : public KabcExportWizard_Base
{
TQ_OBJECT
  
	public:
		KabcExportWizard( TQWidget *parent = 0, const char *name = 0 );
		~KabcExportWizard();
	public slots:
		void accept();
	protected slots:
		void slotDeselectAll();
		void slotSelectAll();
		void slotResourceSelectionChanged( TQListBoxItem * lbi );
	protected:
		void exportDetails( Kopete::MetaContact * mc, TDEABC::Addressee & addr );
	private:
		TDEABC::AddressBook* m_addressBook;
		TQMap<int, TDEABC::Resource*> m_resourceMap;
		TQMap<int, Kopete::MetaContact*> m_contactMap;
};

#endif
