/*
 This file is part of tdeio_obex.

 Copyright (c) 2003 Mathias Froehlich <Mathias.Froehlich@web.de>

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 Boston, MA 02110-1301, USA.
 */

#ifndef TDEIO_OBEX_H
#define TDEIO_OBEX_H

#include <tdeio/global.h>
#include <tdeio/job.h>
#include <tdeio/slavebase.h>

#include <tqdbusobjectpath.h>

#include <interfaces/client1Proxy.h>
#include <interfaces/session1Proxy.h>
#include <interfaces/propertiesProxy.h>
#include <obexobjectmanagerImpl.h>

#include "obex.h"

class ObexProtocol: public TQObject, public TDEIO::SlaveBase {

    TQ_OBJECT

public:
    ObexProtocol(const TQCString &protcol, const TQCString &pool_socket,
            const TQCString &app_socket);
    virtual ~ObexProtocol();
//    virtual void openConnection();
    virtual void closeConnection();
    virtual void stat(const KURL& url);
    virtual void listDir(const KURL& url);
    virtual void get(const KURL& url);
    virtual void copy(const KURL &src, const KURL &dest, int permissions,
            bool overwrite);
    virtual void put(const KURL& url, int permissions, bool overwrite,
            bool resume);
    virtual void del(const KURL &url, bool isfile);
    //  virtual void chmod(const KURL& url, int permissions);
//    virtual void rename(const KURL& src, const KURL& dest, bool overwrite);
    virtual void mkdir(const KURL&url, int permissions);

private:
    // Private variables
    /** True if ioslave is connected to server. */
    bool mConnected;

    /** Host we are connected to. */
    TQString mHost;

    /**
	 The protocol to be used.
     */
    TQString mProtocol;

    /**
	 Pointer to the obex obejct.
     */
    Obex *obex;

    /**
	 Pointer to the obex client class.
     */
    org::bluez::obex::Client1Proxy* mClient;

    /**
	 Pointer to the obex session class.
     */
    org::bluez::obex::Session1Proxy* mSession;
    org::freedesktop::DBus::PropertiesProxy* mSessionProperties;
    org::bluez::obex::FileTransfer1Proxy* mFileTransfer;
    TQT_DBusObjectPath mSessionPath;
    TQString mAddress;

    /**
	 Pointer to the obex agent manager class.
     */
    TDEObex::ObexObjectManagerImpl* mManager;

    /** Channel we are connected to. */
    int mChannel;

    struct Status {
        int code;
        TDEIO::filesize_t size;
        TQString text;
    };

private:
    // private methods

    /**
	 Helper functions.
     */
    bool connectObex();
    void closeObex();
    bool changeWorkingDirectory(const TQString& to);

private slots:
    void slotPropertiesChanged(const TQString& interface,
            const TQMap<TQString, TQT_DBusVariant>& changed_properties,
            const TQStringList& invalidated_properties);

signals:
    void sessionSourceChanged(TQT_DBusObjectPath &path,bool ok);
    void sessionDestinationChanged(TQT_DBusObjectPath &path, TQString value);
    void sessionChannelChanged(TQT_DBusObjectPath &path, TQ_UINT8 value);
    void sessionTargetChanged(TQT_DBusObjectPath &path, TQString value);
    void sessionRootChanged(TQT_DBusObjectPath &path, TQString value);

    void transferSizeChanged(TQT_DBusObjectPath &path, TQ_UINT64 value);
    void transferStatusChanged(TQT_DBusObjectPath &path, TQString value);
    void transferTransferredChanged(TQT_DBusObjectPath &path, TQ_UINT64 value);
    void transferTimeChanged(TQT_DBusObjectPath &path, TQ_UINT64 value);
    void transferFilenameChanged(TQT_DBusObjectPath &path, TQString value);
};

#endif
