/*****************************************************
 * FSView, a simple TreeMap application
 *
 * (C) 2002, Josef Weidendorfer
 */

#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <tdelocale.h>
#include <tdeglobal.h>
#include <tdeconfig.h>

#include "fsview.h"


static TDECmdLineOptions options[] =
{
  { "+[folder]", I18N_NOOP("View filesystem starting from this folder"), 0 },
  TDECmdLineLastOption // End of options.
};

int main(int argc, char* argv[])
{
  // KDE compliant startup
  TDEAboutData aboutData("fsview", I18N_NOOP("FSView"), "0.1",
                       I18N_NOOP("Filesystem Viewer"),
                       TDEAboutData::License_GPL,
                       I18N_NOOP("(c) 2002, Josef Weidendorfer"));
  TDECmdLineArgs::init(argc, argv, &aboutData);
  TDECmdLineArgs::addCmdLineOptions(options);
  TDEApplication a;

  TDEConfigGroup gconfig(TDEGlobal::config(), TQCString("General"));
  TQString path = gconfig.readPathEntry("Path", ".");

  TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();
  if (args->count()>0) path = args->arg(0);

  // TreeMap Widget as toplevel window
  FSView w(new Inode());

  TQObject::connect(&w,TQ_SIGNAL(clicked(TreeMapItem*)),
                   &w,TQ_SLOT(selected(TreeMapItem*)));
  TQObject::connect(&w,TQ_SIGNAL(returnPressed(TreeMapItem*)),
                   &w,TQ_SLOT(selected(TreeMapItem*)));
  TQObject::connect(&w,
                   TQ_SIGNAL(contextMenuRequested(TreeMapItem*,const TQPoint&)),
                   &w,TQ_SLOT(contextMenu(TreeMapItem*, const TQPoint&)));

  w.setPath(path);
  w.show();

  a.connect( &a, TQ_SIGNAL( lastWindowClosed() ), &w, TQ_SLOT( quit() ) );
  return a.exec();
}
