/* This file is part of the KDE project
   Copyright (C) 2005 Jaroslaw Staniek <js@iidea.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "kexicustompropertyfactory_p.h"

#include <tqlineedit.h>
#include <kdebug.h>
#include <koproperty/property.h>
#include <kexiutils/identifier.h>

using namespace KoProperty;

KexiImagePropertyEdit::KexiImagePropertyEdit(
	Property *property, TQWidget *parent, const char *name)
 : PixmapEdit(property, parent, name)
 , m_id(0)
{
}

KexiImagePropertyEdit::~KexiImagePropertyEdit()
{
}

void KexiImagePropertyEdit::selectPixmap()
{
	TQString fileName( PixmapEdit::selectPixmapFileName() );
	if (fileName.isEmpty())
		return;
	KexiBLOBBuffer::Handle h(KexiBLOBBuffer::self()->insertPixmap( KURL(fileName) ));
	setValue((uint)/*! @todo unsafe*/h.id());
#if 0 //will be reenabled for new image collection
	if(!m_manager->activeForm() || !property())
		return;

	ObjectTreeItem *item = m_manager->activeForm()->objectTree()->lookup(m_manager->activeForm()->selectedWidget()->name());
	TQString name = item ? item->pixmapName(property()->name()) : "";
	PixmapCollectionChooser dialog( m_manager->activeForm()->pixmapCollection(), name, topLevelWidget() );
	if(dialog.exec() == TQDialog::Accepted) {
		setValue(dialog.pixmap(), true);
		item->setPixmapName(property()->name(), dialog.pixmapName());
	}
#endif
}

TQVariant KexiImagePropertyEdit::value() const
{
	return (uint)/*! @todo unsafe*/m_id;
}

void KexiImagePropertyEdit::setValue(const TQVariant &value, bool emitChange)
{
	m_id = value.toInt();
	PixmapEdit::setValue(KexiBLOBBuffer::self()->objectForId(m_id).pixmap(), emitChange);
}

void KexiImagePropertyEdit::drawViewer(TQPainter *p, const TQColorGroup &cg, const TQRect &r, 
	const TQVariant &value)
{
	KexiBLOBBuffer::Handle h( KexiBLOBBuffer::self()->objectForId(value.toInt()) );
	PixmapEdit::drawViewer(p, cg, r, h.pixmap());
}

//----------------------------------------------------------------

KexiIdentifierPropertyEdit::KexiIdentifierPropertyEdit(
	Property *property, TQWidget *parent, const char *name)
 : StringEdit(property, parent, name)
{
	m_edit->setValidator( 
		new KexiUtils::IdentifierValidator(m_edit, "KexiIdentifierPropertyEdit Validator") );
}

KexiIdentifierPropertyEdit::~KexiIdentifierPropertyEdit()
{
}

void KexiIdentifierPropertyEdit::setValue(const TQVariant &value, bool emitChange)
{
	TQString string(value.toString());
	if (string.isEmpty()) {
		kdWarning() << "KexiIdentifierPropertyEdit::setValue(): "
			"Value cannot be empty. This call has no effect." << endl;
		return;
	}
	TQString identifier( KexiUtils::string2Identifier(string) );
	if (identifier!=string)
		kdDebug() << TQString("KexiIdentifierPropertyEdit::setValue(): "
			"String \"%1\" converted to identifier \"%2\".").arg(string).arg(identifier) << endl;
	StringEdit::setValue( identifier, emitChange );
}

#include "kexicustompropertyfactory_p.moc"
