/***************************************************************************
    copyright            : (C) 2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file has been modified to match the requirements of KBibTeX.     *
 *   In case of problems or bugs arising from this implementation, please  *
 *   contact the KBibTeX team first.                                       *
 *                             Thomas Fischer <fischer@unix-ag.uni-kl.de>  *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef KBIBTEX_ISO6937CONVERTER_H
#define KBIBTEX_ISO6937CONVERTER_H

class TQCString;
class TQString;
class TQChar;

namespace KBibTeX {

/**
 * @author Robby Stephenson
 */
class Iso6937Converter {
public:
  static TQString toUtf8(const TQCString& text);

private:
  static bool hasNext(unsigned int pos, unsigned int len);
  static bool isAscii(unsigned char c);
  static bool isCombining(unsigned char c);

  static TQChar getChar(unsigned char c);
  static TQChar getCombiningChar(unsigned int c);
};

} // end namespace

#endif
