//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.Qt;
import org.trinitydesktop.qt.TQMetaObject;
import org.trinitydesktop.qt.QtSupport;
import java.util.ArrayList;
import org.trinitydesktop.qt.TQKeyEvent;
import org.trinitydesktop.qt.TQWidget;
import org.trinitydesktop.qt.TQWheelEvent;

/**

 A combobox which implements a history like a unix shell. You can navigate
 through all the items by using the Up or Down arrows (configurable of
 course). Additionally, weighted completion is available. So you should
 load and save the completion list to preserve the weighting between
 sessions.
 KHistoryCombo obeys the HISTCONTROL environment variable to determine
 whether duplicates in the history should be tolerated in
 addToHistory() or not. During construction of KHistoryCombo,
 duplicates will be disabled when HISTCONTROL is set to "ignoredups" or
 "ignoreboth". Otherwise, duplicates are enabled by default.
 See {@link KHistoryComboSignals} for signals emitted by KHistoryCombo
		@author Carsten Pfeiffer <pfeiffer@kde.org>

		@short A combobox for offering a history and completion.

*/
public class KHistoryCombo extends KComboBox  {
	protected KHistoryCombo(Class dummy){super((Class) null);}
	public native TQMetaObject metaObject();
	public native String className();
	/**
		 Constructs a "read-write" combobox. A read-only history combobox
		 doesn't make much sense, so it is only available as read-write.
		 Completion will be used automatically for the items in the combo.
			 The insertion-policy is set to NoInsertion, you have to add the items
		 yourself via the slot addToHistory. If you want every item added,
		 use
			 <pre>
		 connect( combo, TQ_SIGNAL("activated( String )"),
		          combo, TQ_SLOT("addToHistory( String )"));
		 </pre>
			 Use TQComboBox.setMaxCount() to limit the history.
			 <code>parent</code> the parent object of this widget.
		 <code>name</code> the name of this widget.
		     		@short    Constructs a "read-write" combobox.
	*/
	public KHistoryCombo(TQWidget parent, String name) {
		super((Class) null);
		newKHistoryCombo(parent,name);
	}
	private native void newKHistoryCombo(TQWidget parent, String name);
	public KHistoryCombo(TQWidget parent) {
		super((Class) null);
		newKHistoryCombo(parent);
	}
	private native void newKHistoryCombo(TQWidget parent);
	public KHistoryCombo() {
		super((Class) null);
		newKHistoryCombo();
	}
	private native void newKHistoryCombo();
	/**
		 Same as the previous constructor, but additionally has the option
		 to specify whether you want to let KHistoryCombo handle completion
		 or not. If set to <code>true</code>, KHistoryCombo will sync the completion to the
		 contents of the combobox.
		     		@short    Same as the previous constructor, but additionally has the option  to specify whether you want to let KHistoryCombo handle completion  or not.
	*/
	public KHistoryCombo(boolean useCompletion, TQWidget parent, String name) {
		super((Class) null);
		newKHistoryCombo(useCompletion,parent,name);
	}
	private native void newKHistoryCombo(boolean useCompletion, TQWidget parent, String name);
	public KHistoryCombo(boolean useCompletion, TQWidget parent) {
		super((Class) null);
		newKHistoryCombo(useCompletion,parent);
	}
	private native void newKHistoryCombo(boolean useCompletion, TQWidget parent);
	public KHistoryCombo(boolean useCompletion) {
		super((Class) null);
		newKHistoryCombo(useCompletion);
	}
	private native void newKHistoryCombo(boolean useCompletion);
	/**
		 Inserts <code>items</code> into the combobox. <code>items</code> might get
		 truncated if it is longer than maxCount()
				@short    Inserts <code>items</code> into the combobox.
		@see #historyItems
	*/
	public native void setHistoryItems(String[] items);
	/**
		 Inserts <code>items</code> into the combobox. <code>items</code> might get
		 truncated if it is longer than maxCount()
			 Set <code>setCompletionList</code> to true, if you don't have a list of
		 completions. This tells KHistoryCombo to use all the items for the
		 completion object as well.
		 You won't have the benefit of weighted completion though, so normally
		 you should do something like
		 <pre>
		 TDEConfig config = kapp.config();
		 ArrayList list;
			 // load the history and completion list after creating the history combo
		 list = config.readListEntry( "Completion list" );
		 combo.completionObject().setItems( list );
		 list = config.readListEntry( "History list" );
		 combo.setHistoryItems( list );
			 [...]
			 // save the history and completion list when the history combo is
		 // destroyed
		 list = combo.completionObject().items()
		 config.writeEntry( "Completion list", list );
		 list = combo.historyItems();
		 config.writeEntry( "History list", list );
		 </pre>
			 Be sure to use different names for saving with TDEConfig if you have more
		 than one KHistoryCombo.
			 Note: When <code>setCompletionList</code> is true, the items are inserted into the
		 TDECompletion object with mode TDECompletion.Insertion and the mode is set
		 to TDECompletion.Weighted afterwards.
				@short    Inserts <code>items</code> into the combobox.
		@see #historyItems
		@see KComboBox#completionObject
		@see TDECompletion#setItems
		@see TDECompletion#items
	*/
	public native void setHistoryItems(String[] items, boolean setCompletionList);
	/**
		 Returns the list of history items. Empty, when this is not a read-write
		 combobox.
				@short    Returns the list of history items.
		@see #setHistoryItems
	*/
	public native ArrayList historyItems();
	/**
		 Removes all items named <code>item.</code>
				@return <code>true</code> if at least one item was removed.

		@short    Removes all items named <code>item.</code>
		@see #addToHistory
	*/
	public native boolean removeFromHistory(String item);
	/**
		 Sets a pixmap provider, so that items in the combobox can have a pixmap.
		 KPixmapProvider is just an abstract class with the one pure virtual
		 method KPixmapProvider.pixmapFor(). This method is called whenever
		 an item is added to the KHistoryComboBox. Implement it to return your
		 own custom pixmaps, or use the KURLPixmapProvider from libtdeio,
		 which uses KMimeType.pixmapForURL to resolve icons.
			 Set <code>prov</code> to null if you want to disable pixmaps. Default no pixmaps.
				@short    Sets a pixmap provider, so that items in the combobox can have a pixmap.
		@see #pixmapProvider
	*/
	public native void setPixmapProvider(KPixmapProvider prov);
	/**
				@return the current pixmap provider.

		@short
		@see #setPixmapProvider
		@see KPixmapProvider
	*/
	public native KPixmapProvider pixmapProvider();
	/**
		 Resets the current position of the up/down history. Call this
		 when you manually call setCurrentItem() or clearEdit().
		     		@short    Resets the current position of the up/down history.
	*/
	public native void reset();
	/**
		 Adds an item to the end of the history list and to the completion list.
		 If maxCount() is reached, the first item of the list will be
		 removed.
			 If the last inserted item is the same as <code>item</code>, it will not be
		 inserted again.
			 If duplicatesEnabled() is false, any equal existing item will be
		 removed before <code>item</code> is added.
			 Note: By using this method and not the Q and KComboBox insertItem()
		 methods, you make sure that the combobox stays in sync with the
		 completion. It would be annoying if completion would give an item
		 not in the combobox, and vice versa.
				@short    Adds an item to the end of the history list and to the completion list.
		@see #removeFromHistory
		@see org.trinitydesktop.qt.TQComboBox#setDuplicatesEnabled
	*/
	public native void addToHistory(String item);
	/**
		 Clears the history and the completion list.
		     		@short    Clears the history and the completion list.
	*/
	public native void clearHistory();
	/**
		 Handling key-events, the shortcuts to rotate the items.
		     		@short    Handling key-events, the shortcuts to rotate the items.
	*/
	protected native void keyPressEvent(TQKeyEvent arg1);
	/**
		 Handling wheel-events, to rotate the items.
		     		@short    Handling wheel-events, to rotate the items.
	*/
	protected native void wheelEvent(TQWheelEvent ev);
	/**
		 Inserts <code>items</code> into the combo, honoring pixmapProvider()
		 Does not update the completionObject.
			 Note: duplicatesEnabled() is not honored here.
			 Called from setHistoryItems() and setPixmapProvider()
		     		@short    Inserts <code>items</code> into the combo, honoring pixmapProvider()  Does not update the completionObject.
	*/
	protected native void insertItems(String[] items);
	/**
				@return if we can modify the completion object or not.

		@short
	*/
	protected native boolean useCompletion();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
