#!/usr/bin/env ruby -w

# This is the EventFilter example from Chapter 16 of 'Programming with Qt'

require 'Qt'

class KillerFilter < TQt::Object

	def eventFilter( object, event )
		if event.type() == TQt::Event::MouseButtonPress
			if event.button() == RightButton
				object.close(false)
				return true
			else
				return false
			end
		else
			return false
		end
	end

end
	
a = TQt::Application.new(ARGV)
	
toplevel = TQt::Widget.new
toplevel.resize(230, 130)

killerfilter = KillerFilter.new

pb = TQt::PushButton.new(toplevel)
pb.setGeometry( 10, 10, 100, 50 )
pb.text = "pushbutton"
pb.installEventFilter(killerfilter)

le = TQt::LineEdit.new(toplevel)
le.setGeometry( 10, 70, 100, 50 )
le.text = "Line edit"
le.installEventFilter(killerfilter)

cb = TQt::CheckBox.new(toplevel)
cb.setGeometry( 120, 10, 100, 50 )
cb.text = "Check-box"
cb.installEventFilter(killerfilter)

rb = TQt::RadioButton.new(toplevel)
rb.setGeometry( 120, 70, 100, 50 )
rb.text = "Radio button"
rb.installEventFilter(killerfilter)

a.mainWidget = toplevel
toplevel.show
a.exec


	