/***************************************************************************
    smb4kshareslistviewitem  -  The shares list view item class of Smb4K.
                             -------------------
    begin                : Sa Jun 30 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSHARESLISTVIEWITEM_H
#define SMB4KSHARESLISTVIEWITEM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// TQt includes
#include <tqpainter.h>
#include <tqpalette.h>

// KDE includes
#include <tdelistview.h>
#include <kiconloader.h>

// application specific includes
#include "../core/smb4kshare.h"

// forward declarations
class Smb4KSharesListView;

/**
 * This class provides the items for the shares icon view
 * of Smb4K.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KSharesListViewItem : public TDEListViewItem
{
  public:
    /**
     * The constructor.
     *
     * @param share         The Smb4KShare object that represents the share.
     *
     * @param mountpoint    Tells the item if the mount point instead of the
     *                      share name should be shown. Default is false.
     *
     * @param parent        The parent widget of this item.
     */
    Smb4KSharesListViewItem( Smb4KShare *share,
                             bool mountpoint = false,
                             Smb4KSharesListView *parent = 0 );

    /**
     * The destructor
     */
    ~Smb4KSharesListViewItem();

    /**
     * This function compares the encapsulated Smb4KShare object with @p item
     * and returns true if they contain equal values.
     *
     * @param item          A Smb4KShare object that should be compared
     *
     * @returns             true if @p item has the same values stored as the
     *                      encapsulated Smb4KShare object.
     */
    bool sameShareObject( Smb4KShare *share );

    /**
     * Replace the encapsulated Smb4KShare object. This function just passes
     * the share object to setupItem() which does all the work.
     *
     * @param share         The new Smb4KShare object
     */
    void replaceShareObject( Smb4KShare *share );

    /**
     * Returns a pointer to the share object that's represented by this item.
     * You have to use it to access its data.
     *
     * @returns a pointer to a Smb4KShare object.
     */
    Smb4KShare *shareObject() { return &m_share; }

    /**
     * Enumeration for the columns.
     */
#ifndef __FreeBSD__    
    enum Columns { Item = 0,
                   Owner = 1,
                   Login = 2,
                   FileSystem = 3,
                   Free = 4,
                   Used = 5,
                   Total = 6,
                   Usage = 7 };
#else
    enum Columns { Item = 0,
                   Owner = 1,
                   FileSystem = 2,
                   Free = 3,
                   Used = 4,
                   Total = 5,
                   Usage = 6 };
#endif

    /**
     * This function returns the desktop pixmap of this item.
     *
     * @returns the destop pixmap of this item.
     */
    const TQPixmap &desktopPixmap() { return m_desktop_pixmap; }

  protected:
    /**
     * Reimplemented from TDEListViewItem.
     *
     * This function paints the icon text and the usage. It uses Smb4KShare::isForeign() to
     * determine the color of the icon text (true: gray, false: the default color).
     *
     * @param p             The painter
     *
     * @param cg            The color group
     *
     * @param column        The column of the list view
     *
     * @param width         The width of the area that will be painted.
     *
     * @param alignment     The alignment of the column that will be used.
     */
    void paintCell( TQPainter *p,
                    const TQColorGroup &cg,
                    int column,
                    int width,
                    int alignment );

    /**
     * Reimplemented from TDEListViewItem.
     *
     * This function accepts or denies drops according to the contents of @p source.
     *
     * @param source        The mime source
     */
    bool acceptDrop( const TQMimeSource *source ) const;

  private:
    /**
     * Set up the icon and text of the item with respect to @p share and @p mountpoint.
     *
     * @param share         The Smb4KShare object.
     *
     * @param mountpoint    If true, the mount point will be shown instead of the
     *                      share name.
     */
    void setupItem( const Smb4KShare &share,
                    bool mountpoint = false );

    /**
     * The Smb4KShare object representing the share.
     */
    Smb4KShare m_share;

    /**
     * Tells us if the mount point instead of the share
     * name should be shown.
     */
    bool m_mountpoint;

    /**
     * Tells us that the initial setup already happened.
     */
    bool m_initial_setup;

    /**
     * The icon loader for this item.
     */
    TDEIconLoader *m_loader;

    /**
     * The desktop pixmap
     */
    TQPixmap m_desktop_pixmap;
};

#endif
