#ifndef VBUTTON_H
#define VBUTTON_H

#include <tqpushbutton.h>
#include <tqevent.h>

class VButton : public TQPushButton
{
TQ_OBJECT
  
public:
	VButton(TQWidget *parent=0, const char *name=0);
	~VButton();

	unsigned int getKeyCode();
	void setKeyCode(unsigned int keycode);
	void setText(const TQString &text);
	void setShiftText(const TQString &text);
	void setColor(const TQColor &color);
	void setupTexts(Display *display);

	void reposition(int width, int height);
	void res();

	static double pw;
	static double ph;

protected:
	bool press;
	bool inrpt;
	bool inside;
	bool isAlpha;
	unsigned int keycode;
	TQString normalText;
	TQString shiftText;
	TQString capsText;
	TQString capsShiftText;
	TQString capsAltGrText;
	TQString capsAltGrShiftText;
	TQString altGrText;
	TQString altGrShiftText;
	TQRect orig_size;

	void timerEvent ( TQTimerEvent * );

public slots:
	void sendKey();
	void shiftCapsAltGrPressed(bool shift, bool caps, bool altGrState);

protected slots:
	void enterEvent(TQEvent *e);
	void leaveEvent(TQEvent *e);
	void mousePressEvent(TQMouseEvent *e);
	void mouseReleaseEvent(TQMouseEvent *e);

signals:
	void keyClick(unsigned int keycode);
};

#endif
