/***************************************************************************
 *   Copyright Sean Meiners 2004 <Sean.Meiners@LinspireInc.com>            *
 *   Copyright (C) by                                                      *
 *     - 2005: Christian Leh <moodwrod@web.de>                             *
 *                                                                         * 
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License (version 2) as   *
 *   published by the Free Software Foundation. (The original KSplash/ML   *
 *   codebase (upto version 0.95.3) is BSD-licensed.)                      *
 *                                                                         *
 ***************************************************************************/

#include <tqwidget.h>
#include <tqstyle.h>
#include <tqtimer.h>
#include <tqpainter.h>
#include <tqimage.h>

#include "effectwidget.h"

TQImage* EffectWidget::bgImage = 0;

EffectWidget::EffectWidget(TQWidget* parent, const char* name)
           :TQWidget(parent, name)
{
  timer = 0;
  delayMS = 20;
  currentStep = 0;
  totalSteps = 0;
  playing = false;
  loop = false;
  beginOpacity = 20.0;
  endOpacity = 80.0;
  setBackgroundMode(NoBackground);
  setBackgroundOrigin(TQWidget::ParentOrigin);
  updateCache();
}


void EffectWidget::setImage(TQImage *i)
{
  image = i;
}


void EffectWidget::setDelay(int delayInMS)
{
  delayMS = delayInMS;

  if (timer)
    timer->changeInterval(delayMS);
}


void EffectWidget::setLoop(bool loop)
{
  this->loop = loop;
}


void EffectWidget::setSteps(int steps)
{
  totalSteps = steps;
}


void EffectWidget::start()
{
  if ((playing) || (!image) || (totalSteps < 1) || (image->isNull()))
    return;

  if (!timer)
  {
    timer = new TQTimer(this);
    connect(timer,TQ_SIGNAL(timeout()),this,TQ_SLOT(timerTick()));
  }
  
  playing = true;
  update();
  timer->start(delayMS);
}


void EffectWidget::stop()
{
  if ((!playing) || (!timer))
    return;

  timer->stop();
  playing = false;
}


void EffectWidget::setStart(float begin, float end, bool reverse)
{
  beginOpacity = begin;
  endOpacity = end - beginOpacity;

  if (reverse)
  {
    float h = beginOpacity;
    beginOpacity = endOpacity;
    endOpacity = h;
  }
}


void EffectWidget::rewind()
{
  stop();
  currentStep = 0;
}


void EffectWidget::timerTick()
{
  if (loop)
  {
    currentStep ++;
    currentStep %= totalSteps;
  }
  else if (currentStep + 1 < totalSteps)
    currentStep ++;
  else
    timer->stop();

  update();
}


void EffectWidget::moveEvent(TQMoveEvent *)
{
  updateCache();
}


void EffectWidget::resizeEvent(TQResizeEvent *)
{
  updateCache();
}


void EffectWidget::updateCache()
{
  if (!bgImage)
    return;

  TQPoint pos(mapToParent(TQPoint(0, 0)));
  background = bgImage->copy(pos.x(), pos.y(), width(), height());
  bitBlt(this, 0, 0, &background);
}

void EffectWidget::paintEvent(TQPaintEvent *)
{
  if (background.isNull())
    return;

  TQImage upper = image->copy();
  TQImage lower = background.copy();
  KImageEffect::blendOnLower(upper, lower, KImageEffect::Centered, (currentStep + 1 == totalSteps) ? 1.0 : endOpacity / float(totalSteps) * float(currentStep) + beginOpacity);

  bitBlt(this, 0, 0, &lower);
}

#include "effectwidget.moc"
