/***************************************************************************
                          kreplacements.cpp  -  description
                             -------------------
    begin                : Sat Aug 3 2002
    copyright            : (C) 2002-2007 by Joachim Eibl
    email                : joachim.eibl at gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kreplacements.h"
#include "common.h"

#include <assert.h>

#include <tqnamespace.h>
#include <tqmessagebox.h>
#include <tqpopupmenu.h>
#include <tqmenubar.h>
#include <tqpainter.h>
#include <tqcolordialog.h>
#include <tqfontdialog.h>
#include <tqlabel.h>
#include <tqtextbrowser.h>
#include <tqtextstream.h>
#include <tqlayout.h>
#include <tqdockarea.h>

#include <vector>
#include <iostream>
#include <algorithm>


static TQString s_copyright;
static TQString s_email;
static TQString s_description;
static TQString s_appName;
static TQString s_version;
static TQString s_homepage;
static TDEAboutData* s_pAboutData;


#ifdef _WIN32
#include <process.h>
#include <windows.h>
#endif

static void showHelp()
{
   #ifdef _WIN32
      char buf[200];
      int r= SearchPathA( 0, ".",  0, sizeof(buf), buf, 0 );

      TQString exePath;
      if (r!=0)  {  exePath = buf; }
      else       {  exePath = "."; }

      TQFileInfo helpFile( exePath + "\\doc\\en\\index.html" );
      if ( ! helpFile.exists() ) {  helpFile.setFile( exePath + "\\..\\doc\\en\\index.html" );     }
      if ( ! helpFile.exists() ) {  helpFile.setFile( exePath + "\\doc\\index.html"         );     }
      if ( ! helpFile.exists() ) {  helpFile.setFile( exePath + "\\..\\doc\\index.html"     );     }
      if ( ! helpFile.exists() )
      {
         TQMessageBox::warning( 0, "KDiff3 documentation not found",
            "Couldn't find the documentation. \n\n"
            "The documentation can also be found at the homepage:\n\n "
            "    http://kdiff3.sourceforge.net/");
         return;
      }

      HINSTANCE hi = FindExecutableA( helpFile.fileName().ascii(), helpFile.dirPath(true).ascii(), buf );
      if ( int(hi)<=32 )
      {
         static TQTextBrowser* pBrowser = 0;
         if (pBrowser==0)
         {
            pBrowser = new TQTextBrowser( 0 );
            pBrowser->setMinimumSize( 600, 400 );
         }
         pBrowser->setSource(helpFile.filePath());
         pBrowser->show();
      }
      else
      {
         TQFileInfo prog( buf );
         _spawnlp( _P_NOWAIT , prog.filePath().ascii(), prog.fileName().ascii(), ("\"file:///"+helpFile.absFilePath()+"\"").ascii(), NULL );
      }

   #else
      static TQTextBrowser* pBrowser = 0;
      if (pBrowser==0)
      {
         pBrowser = new TQTextBrowser( 0 );
         pBrowser->setMinimumSize( 600, 400 );
      }
      pBrowser->setSource("/usr/local/share/doc/kdiff3/en/index.html");
      pBrowser->show();
   #endif
}

TQString getTranslationDir()
{
   #ifdef _WIN32
      char buf[200];
      int r= SearchPathA( 0, ".",  0, sizeof(buf), buf, 0 );

      TQString exePath;
      if (r!=0)  {  exePath = buf; }
      else       {  exePath = "."; }
      return exePath+"/translations";
   #else
      return ".";
   #endif
}

// static
void KMessageBox::error( TQWidget* parent, const TQString& text, const TQString& caption )
{
   TQMessageBox::critical( parent, caption, text );
}

int KMessageBox::warningContinueCancel( TQWidget* parent, const TQString& text, const TQString& caption,
   const TQString& button1 )
{
   return  0 == TQMessageBox::warning( parent, caption, text, button1, "Cancel" ) ? Continue : Cancel;
}

void KMessageBox::sorry(  TQWidget* parent, const TQString& text, const TQString& caption )
{
   TQMessageBox::information( parent, caption, text );
}

void KMessageBox::information(  TQWidget* parent, const TQString& text, const TQString& caption )
{
   TQMessageBox::information( parent, caption, text );
}

int  KMessageBox::warningYesNo( TQWidget* parent, const TQString& text, const TQString& caption,
   const TQString& button1, const TQString& button2 )
{
   return  0 == TQMessageBox::warning( parent, caption, text, button1, button2, TQString(), 1, 1 ) ? Yes : No;
}

int KMessageBox::warningYesNoCancel( TQWidget* parent, const TQString& text, const TQString& caption,
   const TQString& button1, const TQString& button2 )
{
   int val = TQMessageBox::warning( parent, caption, text,
      button1, button2, i18n("Cancel") );
   if ( val==0 ) return Yes;
   if ( val==1 ) return No;
   else return Cancel;
}


KDialogBase::KDialogBase( int, const TQString& caption, int, int, TQWidget* parent, const char* name,
  bool /*modal*/, bool )
: TQTabDialog( parent, name, true /* modal */ )
{
   setCaption( caption );
   setDefaultButton();
   setHelpButton();
   setCancelButton();
   //setApplyButton();
   setOkButton();
   setDefaultButton();

   connect( this, TQT_SIGNAL( defaultButtonPressed() ), this, TQT_SLOT(slotDefault()) );
   connect( this, TQT_SIGNAL( helpButtonPressed() ), this, TQT_SLOT(slotHelp()));
   connect( this, TQT_SIGNAL( applyButtonPressed() ), this, TQT_SLOT( slotApply() ));
}

KDialogBase::~KDialogBase()
{
}

void KDialogBase::incInitialSize ( const TQSize& )
{
}

void KDialogBase::setHelp(const TQString&, const TQString& )
{
}


int KDialogBase::BarIcon(const TQString& /*iconName*/, int )
{
   return 0; // Not used for replacement.
}


TQVBox* KDialogBase::addVBoxPage( const TQString& name, const TQString& /*info*/, int )
{
   TQVBox* p = new TQVBox(this, name.ascii());
   addTab( p, name );
   return p;
}

TQFrame* KDialogBase::addPage(  const TQString& name, const TQString& /*info*/, int )
{
   TQFrame* p = new TQFrame( this, name.ascii() );
   addTab( p, name );
   return p;
}

int KDialogBase::spacingHint()
{
   return 5;
}

static bool s_inAccept = false;
static bool s_bAccepted = false;
void KDialogBase::accept()
{
   if( ! s_inAccept )
   {
      s_bAccepted = false;
      s_inAccept = true;
      slotOk();
      s_inAccept = false;
      if ( s_bAccepted )
         TQTabDialog::accept();
   }
   else
   {
      s_bAccepted = true;   
   }   
}

void KDialogBase::slotDefault( )
{
}
void KDialogBase::slotOk()
{
}
void KDialogBase::slotCancel( )
{
}
void KDialogBase::slotApply( )
{
   emit applyClicked();
}
void KDialogBase::slotHelp( )
{
   showHelp();
}

KURL KFileDialog::getSaveURL( const TQString &startDir,
                              const TQString &filter,
                              TQWidget *parent, const TQString &caption)
{
   TQString s = TQFileDialog::getSaveFileName(startDir, filter, parent, 0, caption);
   return KURL(s);
}

KURL KFileDialog::getOpenURL( const TQString &  startDir,
                           const TQString &  filter,
                           TQWidget *  parent,
                           const TQString &  caption )
{
   TQString s = TQFileDialog::getOpenFileName(startDir, filter, parent, 0, caption);
   return KURL(s);
}

KURL KFileDialog::getExistingURL( const TQString &  startDir,
                               TQWidget *  parent,
                               const TQString &  caption)
{
   TQString s = TQFileDialog::getExistingDirectory(startDir, parent, 0, caption);
   return KURL(s);
}

TQString KFileDialog::getSaveFileName (const TQString &startDir, 
                        const TQString &filter, 
                        TQWidget *parent, 
                        const TQString &caption)
{
   return TQFileDialog::getSaveFileName( startDir, filter, parent, 0, caption );
}


TDEToolBar::BarPosition TDEToolBar::barPos()
{
   if ( m_pMainWindow->leftDock()->hasDockWindow(this) ) return Left;
   if ( m_pMainWindow->rightDock()->hasDockWindow(this) ) return Right;
   if ( m_pMainWindow->topDock()->hasDockWindow(this) ) return Top;
   if ( m_pMainWindow->bottomDock()->hasDockWindow(this) ) return Bottom;
   return Top;
}

void TDEToolBar::setBarPos(BarPosition bp)
{
   if ( bp == Left ) m_pMainWindow->moveDockWindow( this, DockLeft );
   else if ( bp == Right ) m_pMainWindow->moveDockWindow( this, DockRight );
   else if ( bp == Bottom ) m_pMainWindow->moveDockWindow( this, DockBottom );
   else if ( bp == Top ) m_pMainWindow->moveDockWindow( this, DockTop );
}

TDEToolBar::TDEToolBar( TQMainWindow* parent )
: TQToolBar( parent )
{
   m_pMainWindow = parent;
}


TDEMainWindow::TDEMainWindow( TQWidget* parent, const char* name )
: TQMainWindow( parent, name ), m_actionCollection(this)
{
   fileMenu = new TQPopupMenu();
   menuBar()->insertItem(i18n("&File"), fileMenu);
   editMenu = new TQPopupMenu();
   menuBar()->insertItem(i18n("&Edit"), editMenu);
   directoryMenu = new TQPopupMenu();
   menuBar()->insertItem(i18n("&Directory"), directoryMenu);
   dirCurrentItemMenu = 0;
   dirCurrentSyncItemMenu = 0;
   movementMenu = new TQPopupMenu();
   menuBar()->insertItem(i18n("&Movement"), movementMenu);
   diffMenu = new TQPopupMenu();
   menuBar()->insertItem(i18n("D&iffview"), diffMenu);
   mergeMenu = new TQPopupMenu();
   menuBar()->insertItem(i18n("&Merge"), mergeMenu);
   windowsMenu = new TQPopupMenu();
   menuBar()->insertItem(i18n("&Window"), windowsMenu);
   settingsMenu = new TQPopupMenu();
   menuBar()->insertItem(i18n("&Settings"), settingsMenu);
   helpMenu = new TQPopupMenu();
   menuBar()->insertItem(i18n("&Help"), helpMenu);

   m_pToolBar = new TDEToolBar(this);
      
   memberList = new TQPtrList<TDEMainWindow>;
   memberList->append(this);
}

TDEToolBar* TDEMainWindow::toolBar(const TQString&)
{
   return m_pToolBar;
}

TDEActionCollection* TDEMainWindow::actionCollection()
{
   return &m_actionCollection;
}

void TDEMainWindow::createGUI()
{
   KStdAction::help(this, TQT_SLOT(slotHelp()), actionCollection());
   KStdAction::about(this, TQT_SLOT(slotAbout()), actionCollection());
   KStdAction::aboutTQt(actionCollection());
}

void TDEMainWindow::slotAbout()
{
   TQTabDialog d;
   d.setCaption("About " + s_appName);
   TQTextBrowser* tb1 = new TQTextBrowser(&d);
   tb1->setWordWrap( TQTextEdit::NoWrap );
   tb1->setText(
      s_appName + " Version " + s_version +
      "\n\n" + s_description + 
      "\n\n" + s_copyright +
      "\n\nHomepage: " + s_homepage +
      "\n\nLicence: GNU GPL Version 2"
      );
   d.addTab(tb1,i18n("&About"));
      
   std::list<TDEAboutData::AboutDataEntry>::iterator i;
   
   TQString s2;   
   for( i=s_pAboutData->m_authorList.begin(); i!=s_pAboutData->m_authorList.end(); ++i )
   {
      if ( !i->m_name.isEmpty() )    s2 +=         i->m_name    + "\n";
      if ( !i->m_task.isEmpty() )    s2 += "   " + i->m_task    + "\n";
      if ( !i->m_email.isEmpty() )   s2 += "   " + i->m_email   + "\n";
      if ( !i->m_weblink.isEmpty() ) s2 += "   " + i->m_weblink + "\n";
      s2 += "\n";
   }
   TQTextBrowser* tb2 = new TQTextBrowser(&d);
   tb2->setWordWrap( TQTextEdit::NoWrap );
   tb2->setText(s2);
   d.addTab(tb2,i18n("A&uthor"));
   
   TQString s3;
   for( i=s_pAboutData->m_creditList.begin(); i!=s_pAboutData->m_creditList.end(); ++i )
   {
      if ( !i->m_name.isEmpty() )    s3 +=         i->m_name    + "\n";
      if ( !i->m_task.isEmpty() )    s3 += "   " + i->m_task    + "\n";
      if ( !i->m_email.isEmpty() )   s3 += "   " + i->m_email   + "\n";
      if ( !i->m_weblink.isEmpty() ) s3 += "   " + i->m_weblink + "\n";
      s3 += "\n";
   }
   TQTextBrowser* tb3 = new TQTextBrowser(&d);
   tb3->setWordWrap( TQTextEdit::NoWrap );
   tb3->setText(s3);
   d.addTab(tb3,i18n("&Thanks To"));
   
   d.resize(400,300);
   d.exec();
/*
   TQMessageBox::information(
      this,
      "About " + s_appName,
      s_appName + " Version " + s_version +
      "\n\n" + s_description + 
      "\n\n" + s_copyright +
      "\n\nHomepage: " + s_homepage +
      "\n\nLicence: GNU GPL Version 2"
      );
*/
}

void TDEMainWindow::slotHelp()
{
   showHelp();
}


TQString TDEStandardDirs::findResource(const TQString& resource, const TQString& /*appName*/)
{
   if (resource=="config")
   {
      TQString home = TQDir::homeDirPath();
      return home + "/.kdiff3rc";
   }
   return TQString();
}

TDEConfig::TDEConfig()
{
}

void TDEConfig::readConfigFile( const TQString& configFileName )
{
   if ( !configFileName.isEmpty() )
   {
      m_fileName = configFileName;
   }
   else
   {
      m_fileName = TDEStandardDirs().findResource("config","kdiff3rc");
   }

   TQFile f( m_fileName );
   if ( f.open(IO_ReadOnly) )
   {                               // file opened successfully
      TQTextStream t( &f );         // use a text stream
      load(t);
      f.close();
   }
}

TDEConfig::~TDEConfig()
{
   TQFile f(m_fileName);
   if ( f.open( IO_WriteOnly | IO_Translate ) )
   {                               // file opened successfully
       TQTextStream t( &f );        // use a text stream
       save(t);
       f.close();
   }
}

void TDEConfig::setGroup(const TQString&)
{
}

void TDEAction::init(TQObject* receiver, const char* slot, TDEActionCollection* actionCollection, 
                   const char* name, bool bToggle, bool bMenu)
{
   TQString n(name);
   TDEMainWindow* p = actionCollection->m_pMainWindow;
   if( slot!=0 )
   {
      if (!bToggle)
         connect(this, TQT_SIGNAL(activated()), receiver, slot);
      else
      {
         connect(this, TQT_SIGNAL(toggled(bool)), receiver, slot);
      }
   }

   if (bMenu)
   {
      if( n[0]=='g')       addTo( p->movementMenu );
      else if( n.left(16)=="dir_current_sync")
      {
         if ( p->dirCurrentItemMenu==0 )
         {
            p->dirCurrentItemMenu = new TQPopupMenu();
            p->directoryMenu->insertItem(i18n("Current Item Merge Operation"), p->dirCurrentItemMenu);
            p->dirCurrentSyncItemMenu = new TQPopupMenu();
            p->directoryMenu->insertItem(i18n("Current Item Sync Operation"), p->dirCurrentSyncItemMenu);
         }
         addTo( p->dirCurrentItemMenu );
      }
      else if( n.left(11)=="dir_current")
      {
         if ( p->dirCurrentItemMenu==0 )
         {
            p->dirCurrentItemMenu = new TQPopupMenu();
            p->directoryMenu->insertItem(i18n("Current Item Merge Operation"), p->dirCurrentItemMenu);
            p->dirCurrentSyncItemMenu = new TQPopupMenu();
            p->directoryMenu->insertItem(i18n("Current Item Sync Operation"), p->dirCurrentSyncItemMenu);
         }
         addTo( p->dirCurrentSyncItemMenu );
      }
      else if( n.left(4)=="diff")  addTo( p->diffMenu );
      else if( name[0]=='d')  addTo( p->directoryMenu );
      else if( name[0]=='f')  addTo( p->fileMenu );
      else if( name[0]=='w')  addTo( p->windowsMenu );
      else                    addTo( p->mergeMenu );
   }
}


TDEAction::TDEAction(const TQString& text, const TQIconSet& icon, int accel,
 TQObject* receiver, const char* slot, TDEActionCollection* actionCollection,
 const char* name, bool bToggle, bool bMenu
 )
: TQAction ( text, icon, text, accel, actionCollection->m_pMainWindow, name, bToggle )
{
   TDEMainWindow* p = actionCollection->m_pMainWindow;
   if ( !icon.isNull() && p ) this->addTo( p->m_pToolBar );

   init(receiver,slot,actionCollection,name,bToggle,bMenu);
}

TDEAction::TDEAction(const TQString& text, int accel,
 TQObject* receiver, const char* slot, TDEActionCollection* actionCollection,
 const char* name, bool bToggle, bool bMenu
 )
: TQAction ( text, text, accel, actionCollection->m_pMainWindow, name, bToggle )
{
   init(receiver,slot,actionCollection,name,bToggle,bMenu);
}

void TDEAction::setStatusText(const TQString&)
{
}

void TDEAction::plug(TQPopupMenu* menu)
{
   addTo(menu);
}


TDEToggleAction::TDEToggleAction(const TQString& text, const TQIconSet& icon, int accel, TQObject* receiver, const char* slot, TDEActionCollection* actionCollection, const char* name, bool bMenu)
: TDEAction( text, icon, accel, receiver, slot, actionCollection, name, true, bMenu)
{
}

TDEToggleAction::TDEToggleAction(const TQString& text, int accel, TQObject* receiver, const char* slot, TDEActionCollection* actionCollection, const char* name, bool bMenu)
: TDEAction( text, accel, receiver, slot, actionCollection, name, true, bMenu)
{
}

TDEToggleAction::TDEToggleAction(const TQString& text, const TQIconSet& icon, int accel, TDEActionCollection* actionCollection, const char* name, bool bMenu)
: TDEAction( text, icon, accel, 0, 0, actionCollection, name, true, bMenu)
{
}

void TDEToggleAction::setChecked(bool bChecked)
{
   blockSignals( true );
   setOn( bChecked );
   blockSignals( false );
}

bool TDEToggleAction::isChecked()
{
   return isOn();
}



//static
TDEAction* KStdAction::open( TQWidget* parent, const char* slot, TDEActionCollection* actionCollection)
{
   #include "../xpm/fileopen.xpm"
   TDEMainWindow* p = actionCollection->m_pMainWindow;
   TDEAction* a = new TDEAction( i18n("Open"), TQIconSet(TQPixmap(fileopen)), TQt::CTRL+TQt::Key_O, parent, slot, actionCollection, "open", false, false);
   if(p){ a->addTo( p->fileMenu ); }
   return a;
}

TDEAction* KStdAction::save( TQWidget* parent, const char* slot, TDEActionCollection* actionCollection )
{
   #include "../xpm/filesave.xpm"
   TDEMainWindow* p = actionCollection->m_pMainWindow;
   TDEAction* a = new TDEAction( i18n("Save"), TQIconSet(TQPixmap(filesave)), TQt::CTRL+TQt::Key_S, parent, slot, actionCollection, "save", false, false);
   if(p){ a->addTo( p->fileMenu ); }
   return a;
}

TDEAction* KStdAction::saveAs( TQWidget* parent, const char* slot, TDEActionCollection* actionCollection)
{
   TDEMainWindow* p = actionCollection->m_pMainWindow;
   TDEAction* a = new TDEAction( i18n("Save As..."), 0, parent, slot, actionCollection, "saveas", false, false);
   if(p) a->addTo( p->fileMenu );
   return a;
}

TDEAction* KStdAction::print( TQWidget* parent, const char* slot, TDEActionCollection* actionCollection)
{
   #include "../xpm/fileprint.xpm"
   TDEMainWindow* p = actionCollection->m_pMainWindow;
   TDEAction* a = new TDEAction( i18n("Print..."), TQIconSet(TQPixmap(fileprint)),TQt::CTRL+TQt::Key_P, parent, slot, actionCollection, "print", false, false);
   if(p) a->addTo( p->fileMenu );
   return a;
}

TDEAction* KStdAction::quit( TQWidget* parent, const char* slot, TDEActionCollection* actionCollection)
{
   TDEMainWindow* p = actionCollection->m_pMainWindow;
   TDEAction* a = new TDEAction( i18n("Quit"), TQt::CTRL+TQt::Key_Q, parent, slot, actionCollection, "quit", false, false);
   if(p) a->addTo( p->fileMenu );
   return a;
}

TDEAction* KStdAction::cut( TQWidget* parent, const char* slot, TDEActionCollection* actionCollection)
{
   TDEMainWindow* p = actionCollection->m_pMainWindow;
   TDEAction* a = new TDEAction( i18n("Cut"), TQt::CTRL+TQt::Key_X, parent, slot, actionCollection, "cut", false, false );
   if(p) a->addTo( p->editMenu );
   return a;
}

TDEAction* KStdAction::copy( TQWidget* parent, const char* slot, TDEActionCollection* actionCollection)
{
   TDEMainWindow* p = actionCollection->m_pMainWindow;
   TDEAction* a = new TDEAction( i18n("Copy"), TQt::CTRL+TQt::Key_C, parent, slot, actionCollection, "copy", false, false );
   if(p) a->addTo( p->editMenu );
   return a;
}

TDEAction* KStdAction::paste( TQWidget* parent, const char* slot, TDEActionCollection* actionCollection)
{
   TDEMainWindow* p = actionCollection->m_pMainWindow;
   TDEAction* a = new TDEAction( i18n("Paste"), TQt::CTRL+TQt::Key_V, parent, slot, actionCollection, "paste", false, false );
   if(p) a->addTo( p->editMenu );
   return a;
}

TDEAction* KStdAction::selectAll( TQWidget* parent, const char* slot, TDEActionCollection* actionCollection)
{
   TDEMainWindow* p = actionCollection->m_pMainWindow;
   TDEAction* a = new TDEAction( i18n("Select All"), TQt::CTRL+TQt::Key_A, parent, slot, actionCollection, "selectall", false, false );
   if(p) a->addTo( p->editMenu );
   return a;
}

TDEToggleAction* KStdAction::showToolbar( TQWidget* parent, const char* slot, TDEActionCollection* actionCollection)
{
   TDEMainWindow* p = actionCollection->m_pMainWindow;
   TDEToggleAction* a = new TDEToggleAction( i18n("Show Toolbar"), 0, parent, slot, actionCollection, "showtoolbar", false );
   if(p) a->addTo( p->settingsMenu );
   return a;
}

TDEToggleAction* KStdAction::showStatusbar( TQWidget* parent, const char* slot, TDEActionCollection* actionCollection)
{
   TDEMainWindow* p = actionCollection->m_pMainWindow;
   TDEToggleAction* a = new TDEToggleAction( i18n("Show &Statusbar"), 0, parent, slot, actionCollection, "showstatusbar", false );
   if(p) a->addTo( p->settingsMenu );
   return a;
}

TDEAction* KStdAction::preferences( TQWidget* parent, const char* slot, TDEActionCollection* actionCollection)
{
   TDEMainWindow* p = actionCollection->m_pMainWindow;
   TDEAction* a = new TDEAction( i18n("&Configure %1...").arg("KDiff3"), 0, parent, slot, actionCollection, "settings", false, false );
   if(p) a->addTo( p->settingsMenu );
   return a;
}
TDEAction* KStdAction::keyBindings( TQWidget*, const char*, TDEActionCollection*)
{
   return 0;
}

TDEAction* KStdAction::about( TQWidget* parent, const char* slot, TDEActionCollection* actionCollection)
{
   TDEMainWindow* p = actionCollection->m_pMainWindow;
   TDEAction* a = new TDEAction( i18n("About")+" KDiff3", 0, parent, slot, actionCollection, "about_kdiff3", false, false );
   if(p) a->addTo( p->helpMenu );
   return a;
}

TDEAction* KStdAction::aboutTQt( TDEActionCollection* actionCollection )
{
   TDEMainWindow* p = actionCollection->m_pMainWindow;
   TDEAction* a = new TDEAction( i18n("About")+" TQt", 0, tqApp, TQT_SLOT(aboutTQt()), actionCollection, "about_qt", false, false );
   if(p) a->addTo( p->helpMenu );
   return a;
}

TDEAction* KStdAction::help( TQWidget* parent, const char* slot, TDEActionCollection* actionCollection)
{
   TDEMainWindow* p = actionCollection->m_pMainWindow;
   TDEAction* a = new TDEAction( i18n("Help"), TQt::Key_F1, parent, slot, actionCollection, "help", false, false );
   if(p) a->addTo( p->helpMenu );
   return a;
}
TDEAction* KStdAction::find( TQWidget* parent, const char* slot, TDEActionCollection* actionCollection)
{
   TDEMainWindow* p = actionCollection->m_pMainWindow;
   TDEAction* a = new TDEAction( i18n("Find"), TQt::CTRL+TQt::Key_F, parent, slot, actionCollection, "find", false, false );
   if(p) a->addTo( p->editMenu );
   return a;
}

TDEAction* KStdAction::findNext( TQWidget* parent, const char* slot, TDEActionCollection* actionCollection)
{
   TDEMainWindow* p = actionCollection->m_pMainWindow;
   TDEAction* a = new TDEAction( i18n("Find Next"), TQt::Key_F3, parent, slot, actionCollection, "findNext", false, false );
   if(p) a->addTo( p->editMenu );
   return a;
}




TDEFontChooser::TDEFontChooser( TQWidget* pParent, const TQString& /*name*/, bool, const TQStringList&, bool, int )
: TQWidget(pParent)
{
   m_pParent = pParent;
   TQVBoxLayout* pLayout = new TQVBoxLayout( this );
   m_pSelectFont = new TQPushButton(i18n("Select Font"), this );
   connect(m_pSelectFont, TQT_SIGNAL(clicked()), this, TQT_SLOT(slotSelectFont()));
   pLayout->addWidget(m_pSelectFont);

   m_pLabel = new TQLabel( "", this );
   m_pLabel->setFont( m_font );
   m_pLabel->setMinimumWidth(200);
   m_pLabel->setText( "The quick brown fox jumps over the river\n"
                      "but the little red hen escapes with a shiver.\n"
                      ":-)");
   pLayout->addWidget(m_pLabel);
}

TQFont TDEFontChooser::font()
{
   return m_font;//TQFont("courier",10);
}

void TDEFontChooser::setFont( const TQFont& font, bool )
{
   m_font = font;
   m_pLabel->setFont( m_font );
   //update();
}

void TDEFontChooser::slotSelectFont()
{
   for(;;)
   {
      bool bOk;
      m_font = TQFontDialog::getFont(&bOk, m_font );
      m_pLabel->setFont( m_font );   
      TQFontMetrics fm(m_font);

      // Variable width font.
      if ( fm.width('W')!=fm.width('i') )
      {
         int result = KMessageBox::warningYesNo(m_pParent, i18n(
            "You selected a variable width font.\n\n"
            "Because this program doesn't handle variable width fonts\n"
            "correctly, you might experience problems while editing.\n\n"
            "Do you want to continue or do you want to select another font."),
            i18n("Incompatible font."),
            i18n("Continue at my own risk"), i18n("Select another font"));
         if (result==KMessageBox::Yes)
            return;
      }
      else
         return;
   }
}


KColorButton::KColorButton(TQWidget* parent)
: TQPushButton(parent)
{
   connect( this, TQT_SIGNAL(clicked()), this, TQT_SLOT(slotClicked()));
}

TQColor KColorButton::color()
{
   return m_color;
}

void KColorButton::setColor( const TQColor& color )
{
   m_color = color;
   update();
}

void KColorButton::paintEvent( TQPaintEvent* e )
{
   TQPushButton::paintEvent(e);
   TQPainter p(this);

   int w = width();
   int h = height();
   p.fillRect( 10, 5, w-20, h-10, m_color );
   p.drawRect( 10, 5, w-20, h-10 );
}

void KColorButton::slotClicked()
{
   // Under Windows ChooseColor() should be used. (Nicer if few colors exist.)
   TQColor c = TQColorDialog::getColor ( m_color, this );
   if ( c.isValid() ) m_color = c;
   update();
}

KPrinter::KPrinter()
{
}
TQValueList<int> KPrinter::pageList()
{
   TQValueList<int> vl;
   int to = toPage();
   for(int i=fromPage(); i<=to; ++i)
   {
      vl.push_back(i);
   }
   return vl;
}
void KPrinter::setCurrentPage(int)
{
}
void KPrinter::setPageSelection(e_PageSelection)
{
}


TQPixmap TDEIconLoader::loadIcon( const TQString&, int )
{
   return TQPixmap();
}

TDEAboutData::TDEAboutData( const TQString& /*name*/, const TQString& appName, const TQString& version,
      const TQString& description, int,
      const TQString& copyright, int, const TQString& homepage, const TQString& email)
{
   s_copyright = copyright;
   s_email = email;
   s_appName = appName;
   s_description = description;
   s_version = version;
   s_homepage = homepage;
}

TDEAboutData::TDEAboutData( const TQString& /*name*/, const TQString& /*appName*/, const TQString& /*version*/ )
{
}

void TDEAboutData::addAuthor(const char* name, const char* task, const char* email, const char* weblink)
{
   m_authorList.push_back( AboutDataEntry( name, task, email, weblink) );
}

void TDEAboutData::addCredit(const char* name, const char* task, const char* email, const char* weblink)
{
   m_creditList.push_back( AboutDataEntry( name, task, email, weblink) );
}

/*  Option structure: e.g.:
  { "m", 0, 0 },
  { "merge", I18N_NOOP("Automatically merge the input."), 0 },
  { "o", 0, 0 },
  { "output file", I18N_NOOP("Output file. Implies -m. E.g.: -o newfile.txt"), 0 },
  { "+[File1]", I18N_NOOP("file1 to open (base)"), 0 },
  { "+[File2]", I18N_NOOP("file2 to open"), 0 },
  { "+[File3]", I18N_NOOP("file3 to open"), 0 },
*/
////////////////
static TDECmdLineArgs s_cmdLineArgs;
static int s_argc;
static char** s_argv;
static TDECmdLineOptions* s_pOptions;

static std::vector<QCStringList> s_vOption;
static std::vector<const char*> s_vArg;

TDECmdLineArgs* TDECmdLineArgs::parsedArgs()  // static
{
   return &s_cmdLineArgs;
}

void TDECmdLineArgs::init( int argc, char**argv, TDEAboutData* pAboutData )  // static
{
   s_argc = argc;
   s_argv = argv;
   s_pAboutData = pAboutData;
}

void TDECmdLineArgs::addCmdLineOptions( TDECmdLineOptions* options ) // static
{
   s_pOptions = options;
}

int TDECmdLineArgs::count()
{
   return s_vArg.size();
}

TQString TDECmdLineArgs::arg(int idx)
{
   return TQString::fromLocal8Bit( s_vArg[idx] );
}

void TDECmdLineArgs::clear()
{
}

TQString TDECmdLineArgs::getOption( const TQString& s )
{
   // Find the option
   int j=0;
   for( j=0; j<(int)s_vOption.size(); ++j )
   {
      const char* optName = s_pOptions[j].name;
      const char* pos = strchr( optName,' ' );
      int len = pos==0 ? strlen( optName ) : pos - optName;

      if( s == (const char*)( TQCString( optName, len+1) ) )
      {
         return s_vOption[j].isEmpty() ? TQString() : s_vOption[j].last();
      }
   }
   assert(false);
   return TQString();
}

QCStringList TDECmdLineArgs::getOptionList( const TQString& s )
{   
   // Find the option
   int j=0;
   for( j=0; j<(int)s_vOption.size(); ++j )
   {
      const char* optName = s_pOptions[j].name;
      const char* pos = strchr( optName,' ' );
      int len = pos==0 ? strlen( optName ) : pos - optName;

      if( s == (const char*)( TQCString( optName, len+1) ) )
      {
         return s_vOption[j];
      }
   }

   assert(false);
   return QCStringList();
}

bool TDECmdLineArgs::isSet(const TQString& s)
{
   // Find the option
   int j=0;
   for( j=0; j<(int)s_vOption.size(); ++j )
   {
      const char* optName = s_pOptions[j].name;
      if( s == TQString( optName ) )
      {
         return ! s_vOption[j].isEmpty();
      }
   }
   assert(false);
   return false;
}

///////////////////
TDEApplication* kapp;

TDEApplication::TDEApplication()
: TQApplication( s_argc,s_argv )
{
   kapp = this;

   int nofOptions=0;
   int nofArgs=0;
   int i=0;
   while( s_pOptions[i].name != 0 )
   {
      if ( s_pOptions[i].name[0]=='[' )
         nofArgs++;
      else
         nofOptions++;

      ++i;
   }

   // First find the option "-config" or "--config" to allow loading of options
   TQString configFileName;
   for( i=1; i<s_argc-1; ++i )
   {
      TQString arg = s_argv[i];
      if ( arg == "-config" || arg == "--config" )
      {
         configFileName = s_argv[i+1];
      }
   }
   m_config.readConfigFile(configFileName);

   TQStringList ignorableCmdLineOptionsList = m_config.readListEntry("IgnorableCmdLineOptions", TQString("-u;-query;-html;-abort"), '|');
   TQString ignorableCmdLineOptions;
   if ( !ignorableCmdLineOptionsList.isEmpty() ) 
      ignorableCmdLineOptions = ignorableCmdLineOptionsList.front() + ";";

   s_vOption.resize(nofOptions);

   for( i=1; i<s_argc; ++i )
   {
      if ( s_argv[i][0]=='-' )  // An option
      {
         if ( ignorableCmdLineOptions.contains(TQString(s_argv[i])+";") )
            continue;
         // Find the option
         int j=0;
         for( j=0; j<nofOptions; ++j )
         {
            const char* optName = s_pOptions[j].name;
            const char* pos = strchr( optName,' ' );
            int len = pos==0 ? strlen( optName ) : pos - optName;
            int len2 = strlen(s_argv[i]);

            if( len>0 && ( s_argv[i][1]=='-' && len2-2==len && memcmp( &s_argv[i][2], optName, len )==0  ||
                                                len2-1==len && memcmp( &s_argv[i][1], optName, len )==0  ))
            {
               if (s_pOptions[j].description == 0)  // alias, because without description.
               {
                  ++j;
                  optName = s_pOptions[j].name;
                  pos = strchr( optName,' ' );
               }
               if (pos!=0){ ++i; s_vOption[j].append(s_argv[i]); } //use param
               else       { s_vOption[j].append("1"); }           //set state
               break;
            }
         }
         if (j==nofOptions)
         {
            TQString s;
            s = TQString("Unknown option: ") +  s_argv[i] + "\n";
            s += "If KDiff3 should ignore this option, run KDiff3 normally and edit\n"
                 "the \"Command line options to ignore\" in the \"Integration Settings\".\n\n";

            s += "KDiff3-Usage when starting via commandline: \n";
            s += "- Comparing 2 files:\t\tkdiff3 file1 file2\n";
            s += "- Merging 2 files:  \t\tkdiff3 file1 file2 -o outputfile\n";
            s += "- Comparing 3 files:\t\tkdiff3 file1 file2 file3\n";
            s += "- Merging 3 files:  \t\tkdiff3 file1 file2 file3 -o outputfile\n";
            s += "     Note that file1 will be treated as base of file2 and file3.\n";
            s += "\n";
            s += "If you start without arguments, then a dialog will appear\n";
            s += "where you can select your files via a filebrowser.\n";
            s += "\n";

            s += "Options:\n";

            j=0;
            int pos=s.length();
            for( j=0; j<nofOptions; ++j )
            {
               if ( s_pOptions[j].description!=0 )
               {
                  if (s_pOptions[j].name[0]!='+')
                  {
                     s += "-";
                     if ( strlen(s_pOptions[j].name)>1 ) s += "-";
                  }
                  s += s_pOptions[j].name;
                  s += TQString().fill(' ', minMaxLimiter( 20 - ((int)s.length()-pos), 3, 20 ) );
                  s += s_pOptions[j].description;
                  s +="\n";
                  pos=s.length();
               }
               else
               {
                  s += "-";
                  if ( strlen(s_pOptions[j].name)>1 ) s += "-";
                  s += s_pOptions[j].name;
                  s += ", ";
               }
            }

            s += "\n"+i18n("For more documentation, see the help-menu or the subdirectory doc.")+"\n";
#ifdef _WIN32
            // A windows program has no console
            if ( 0==TQMessageBox::information(0, i18n("KDiff3-Usage"), s, i18n("Ignore"),i18n("Exit") ) )
               continue;
#else
            std::cerr << s.latin1() << std::endl;
#endif

            ::exit(-1);
         }
      }
      else
         s_vArg.push_back( s_argv[i] );
   }
}

TDEConfig* TDEApplication::config()
{
   return &m_config;
}

bool TDEApplication::isRestored()
{
   return false;
}

TDEApplication* TDEApplication::kApplication()
{
   return kapp;
}

TDEIconLoader* TDEApplication::iconLoader()
{
   return &m_iconLoader;
}


namespace TDEIO
{
   SimpleJob* mkdir( KURL ){return 0;}
   SimpleJob* rmdir( KURL ){return 0;}
   SimpleJob* file_delete( KURL, bool ){return 0;}
   FileCopyJob* file_move(  KURL, KURL, int, bool, bool, bool ) {return 0;}
   FileCopyJob* file_copy(  KURL, KURL, int, bool, bool, bool ) {return 0;}
   CopyJob* link(  KURL, KURL, bool ) {return 0;}
   ListJob* listRecursive( KURL, bool, bool ){return 0;}
   ListJob* listDir( KURL, bool, bool ){return 0;}
   StatJob* stat( KURL, bool, int, bool ){return 0;}
   TransferJob* get( KURL, bool, bool ){return (TransferJob*)0;}
   TransferJob* put( KURL, int, bool, bool, bool ){return (TransferJob*)0;}
};

TDEActionCollection* KParts::Part::actionCollection()
{
   return 0;
}

TDEApplication* KParts::Part::instance()
{
   return kapp;
}


KLibLoader* KLibLoader::self()
{
   static KLibLoader ll;
   return &ll;
}

extern "C" void* init_libkdiff3part();
KLibFactory* KLibLoader::factory(TQString const&)
{
   return (KLibFactory*) init_libkdiff3part();
}

TQObject* KLibFactory::create(TQObject* pParent, const TQString& name, const TQString& classname )
{
   KParts::Factory* f = dynamic_cast<KParts::Factory*>(this);
   if (f!=0)
      return f->createPartObject( (TQWidget*)pParent, name.ascii(),
                                            pParent, name.ascii(),
                                            classname.ascii(),  TQStringList() );
   else
      return 0;
}




#include "kreplacements.moc"
