// File autogenerated

// declaration include
#include "networkmanagerproxy.h"

// TQt includes
#include <tqmap.h>
#include <tqstring.h>
#include <tqvaluelist.h>

// TQt D-Bus includes
#include <tqdbusconnection.h>
#include <tqdbusdata.h>
#include <tqdbusdatalist.h>
#include <tqdbusdatamap.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusobjectpath.h>
#include <tqdbusproxy.h>
#include <tqdbusvariant.h>


namespace DBus
{

NetworkManagerProxy::NetworkManagerProxy(const TQString& service, const TQString& path, TQObject* parent, const char* name)
    : TQObject(parent, name),
      m_baseProxy(new TQT_DBusProxy())
{
    m_baseProxy->setInterface("org.freedesktop.NetworkManager");
    m_baseProxy->setPath(path);
    m_baseProxy->setService(service);

    TQObject::connect(m_baseProxy, TQ_SIGNAL(dbusSignal(const TQT_DBusMessage&)),
                     this,        TQ_SLOT(slotHandleDBusSignal(const TQT_DBusMessage&)));
    TQObject::connect(m_baseProxy, TQ_SIGNAL(asyncReply(int, const TQT_DBusMessage&)),
                     this,        TQ_SLOT(slotHandleAsyncReply(int, const TQT_DBusMessage&)));
}

NetworkManagerProxy::~NetworkManagerProxy()
{
    delete m_baseProxy;
}

void NetworkManagerProxy::setConnection(const TQT_DBusConnection& connection)
{
    m_baseProxy->setConnection(connection);
}

bool NetworkManagerProxy::GetDevices(TQValueList< TQT_DBusObjectPath >& devices, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    TQT_DBusMessage reply = m_baseProxy->sendWithReply("GetDevices", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;

    if (reply.count() != 1) return false;

    bool ok = false;

    bool subOK = false;

    devices = reply.front().toList(&ok).toObjectPathList(&subOK);
    if (!subOK) return false;
    if (!ok) return false;

    return true;
}

bool NetworkManagerProxy::GetDeviceByIpIface(const TQString& iface, TQT_DBusObjectPath& device, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromString(iface);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("GetDeviceByIpIface", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;

    if (reply.count() != 1) return false;

    bool ok = false;

    device = reply.front().toObjectPath(&ok);
    if (!ok) return false;

    return true;
}

bool NetworkManagerProxy::SetLogging(const TQString& level, const TQString& domains, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromString(level);
    parameters << TQT_DBusData::fromString(domains);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("SetLogging", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

bool NetworkManagerProxy::state(TQ_UINT32& state, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    TQT_DBusMessage reply = m_baseProxy->sendWithReply("state", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;

    if (reply.count() != 1) return false;

    bool ok = false;

    state = reply.front().toUInt32(&ok);
    if (!ok) return false;

    return true;
}

bool NetworkManagerProxy::ActivateConnectionAsync(int& asyncCallId, const TQT_DBusObjectPath& connection, const TQT_DBusObjectPath& device, const TQT_DBusObjectPath& specific_object, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromObjectPath(connection);
    parameters << TQT_DBusData::fromObjectPath(device);
    parameters << TQT_DBusData::fromObjectPath(specific_object);

    asyncCallId = m_baseProxy->sendWithAsyncReply("ActivateConnection", parameters);

    if (asyncCallId != 0) m_asyncCalls[asyncCallId] = "ActivateConnection";

    error = TQT_DBusError();
    return (asyncCallId != 0);
}

bool NetworkManagerProxy::AddAndActivateConnectionAsync(int& asyncCallId, const TQT_DBusDataMap< TQString >& connection, const TQT_DBusObjectPath& device, const TQT_DBusObjectPath& specific_object, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromStringKeyMap(connection);
    parameters << TQT_DBusData::fromObjectPath(device);
    parameters << TQT_DBusData::fromObjectPath(specific_object);

    asyncCallId = m_baseProxy->sendWithAsyncReply("AddAndActivateConnection", parameters);

    if (asyncCallId != 0) m_asyncCalls[asyncCallId] = "AddAndActivateConnection";

    error = TQT_DBusError();
    return (asyncCallId != 0);
}

bool NetworkManagerProxy::DeactivateConnectionAsync(int& asyncCallId, const TQT_DBusObjectPath& active_connection, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromObjectPath(active_connection);

    asyncCallId = m_baseProxy->sendWithAsyncReply("DeactivateConnection", parameters);

    if (asyncCallId != 0) m_asyncCalls[asyncCallId] = "DeactivateConnection";

    error = TQT_DBusError();
    return (asyncCallId != 0);
}

bool NetworkManagerProxy::SleepAsync(int& asyncCallId, bool sleep, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromBool(sleep);

    asyncCallId = m_baseProxy->sendWithAsyncReply("Sleep", parameters);

    if (asyncCallId != 0) m_asyncCalls[asyncCallId] = "Sleep";

    error = TQT_DBusError();
    return (asyncCallId != 0);
}

bool NetworkManagerProxy::EnableAsync(int& asyncCallId, bool enable, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromBool(enable);

    asyncCallId = m_baseProxy->sendWithAsyncReply("Enable", parameters);

    if (asyncCallId != 0) m_asyncCalls[asyncCallId] = "Enable";

    error = TQT_DBusError();
    return (asyncCallId != 0);
}

bool NetworkManagerProxy::GetPermissionsAsync(int& asyncCallId, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    asyncCallId = m_baseProxy->sendWithAsyncReply("GetPermissions", parameters);

    if (asyncCallId != 0) m_asyncCalls[asyncCallId] = "GetPermissions";

    error = TQT_DBusError();
    return (asyncCallId != 0);
}

void NetworkManagerProxy::setDBusProperty(const TQString& name, const TQT_DBusVariant& value, TQT_DBusError& error)
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Set");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);
    message << TQT_DBusData::fromVariant(value);

    connection.sendWithReply(message, &error);
}

TQT_DBusVariant NetworkManagerProxy::getDBusProperty(const TQString& name, TQT_DBusError& error) const
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Get");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);

    TQT_DBusMessage reply = connection.sendWithReply(message, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return TQT_DBusVariant();
    if (reply.count() != 1) return TQT_DBusVariant();

    bool ok = false;
    TQT_DBusVariant value = reply.front().toVariant(&ok);
    if (!ok) return TQT_DBusVariant();

    return value;
}

bool NetworkManagerProxy::getNetworkingEnabled(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("NetworkingEnabled", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

void NetworkManagerProxy::setWirelessEnabled(bool value, TQT_DBusError& error)
{
    TQT_DBusVariant variant;
    variant.value = TQT_DBusData::fromBool(value);
    variant.signature = "b";

    setDBusProperty("WirelessEnabled", variant, error);
}

bool NetworkManagerProxy::getWirelessEnabled(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("WirelessEnabled", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

bool NetworkManagerProxy::getWirelessHardwareEnabled(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("WirelessHardwareEnabled", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

void NetworkManagerProxy::setWwanEnabled(bool value, TQT_DBusError& error)
{
    TQT_DBusVariant variant;
    variant.value = TQT_DBusData::fromBool(value);
    variant.signature = "b";

    setDBusProperty("WwanEnabled", variant, error);
}

bool NetworkManagerProxy::getWwanEnabled(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("WwanEnabled", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

bool NetworkManagerProxy::getWwanHardwareEnabled(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("WwanHardwareEnabled", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

void NetworkManagerProxy::setWimaxEnabled(bool value, TQT_DBusError& error)
{
    TQT_DBusVariant variant;
    variant.value = TQT_DBusData::fromBool(value);
    variant.signature = "b";

    setDBusProperty("WimaxEnabled", variant, error);
}

bool NetworkManagerProxy::getWimaxEnabled(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("WimaxEnabled", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

bool NetworkManagerProxy::getWimaxHardwareEnabled(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("WimaxHardwareEnabled", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

TQValueList< TQT_DBusObjectPath > NetworkManagerProxy::getActiveConnections(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("ActiveConnections", error);

    if (error.isValid()) return TQValueList< TQT_DBusObjectPath >();

    bool ok = false;

    bool subOK = false;

    TQValueList< TQT_DBusObjectPath > result =  variant.value.toList(&ok).toObjectPathList(&subOK);
    if (!subOK) {}
    if (!ok) {}

    return result;
}

TQString NetworkManagerProxy::getVersion(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Version", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

TQ_UINT32 NetworkManagerProxy::getState(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("State", error);

    if (error.isValid()) return TQ_UINT32();

    bool ok = false;

    TQ_UINT32 result =  variant.value.toUInt32(&ok);
    if (!ok) {}

    return result;
}

void NetworkManagerProxy::slotHandleDBusSignal(const TQT_DBusMessage& message)
{
    if (message.member() == "CheckPermissions")
    {

        emit CheckPermissions();
    }
    else if (message.member() == "StateChanged")
    {
        TQ_UINT32 _state = message[0].toUInt32();

        emit StateChanged(_state);
    }
    else if (message.member() == "PropertiesChanged")
    {
        TQMap< TQString, TQT_DBusVariant > _properties = message[0].toStringKeyMap().toVariantMap();

        emit PropertiesChanged(_properties);
    }
    else if (message.member() == "DeviceAdded")
    {
        TQT_DBusObjectPath _device_path = message[0].toObjectPath();

        emit DeviceAdded(_device_path);
    }
    else if (message.member() == "DeviceRemoved")
    {
        TQT_DBusObjectPath _device_path = message[0].toObjectPath();

        emit DeviceRemoved(_device_path);
    }
}

void NetworkManagerProxy::slotHandleAsyncReply(int asyncCallId, const TQT_DBusMessage& message)
{
    TQMap<int, TQString>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    const TQString signalName = findIt.data();
    m_asyncCalls.erase(findIt);

    if (signalName == "ActivateConnection")
    {
        int _asyncCallId = asyncCallId;

        if (message.type() == TQT_DBusMessage::ErrorMessage) {
            emit AsyncErrorResponseDetected(_asyncCallId, message.error());
        }

        TQT_DBusObjectPath _active_connection = message[0].toObjectPath();

        emit ActivateConnectionAsyncReply(_asyncCallId, _active_connection);
    }
    else if (signalName == "AddAndActivateConnection")
    {
        int _asyncCallId = asyncCallId;

        if (message.type() == TQT_DBusMessage::ErrorMessage) {
            emit AsyncErrorResponseDetected(_asyncCallId, message.error());
        }

        TQT_DBusObjectPath _path = message[0].toObjectPath();
        TQT_DBusObjectPath _active_connection = message[1].toObjectPath();

        emit AddAndActivateConnectionAsyncReply(_asyncCallId, _path, _active_connection);
    }
    else if (signalName == "DeactivateConnection")
    {
        int _asyncCallId = asyncCallId;

        if (message.type() == TQT_DBusMessage::ErrorMessage) {
            emit AsyncErrorResponseDetected(_asyncCallId, message.error());
        }


        emit DeactivateConnectionAsyncReply(_asyncCallId);
    }
    else if (signalName == "Sleep")
    {
        int _asyncCallId = asyncCallId;

        if (message.type() == TQT_DBusMessage::ErrorMessage) {
            emit AsyncErrorResponseDetected(_asyncCallId, message.error());
        }


        emit SleepAsyncReply(_asyncCallId);
    }
    else if (signalName == "Enable")
    {
        int _asyncCallId = asyncCallId;

        if (message.type() == TQT_DBusMessage::ErrorMessage) {
            emit AsyncErrorResponseDetected(_asyncCallId, message.error());
        }


        emit EnableAsyncReply(_asyncCallId);
    }
    else if (signalName == "GetPermissions")
    {
        int _asyncCallId = asyncCallId;

        if (message.type() == TQT_DBusMessage::ErrorMessage) {
            emit AsyncErrorResponseDetected(_asyncCallId, message.error());
        }

        TQMap< TQString, TQString > _permissions = message[0].toStringKeyMap().toStringMap();

        emit GetPermissionsAsyncReply(_asyncCallId, _permissions);
    }
}

}; // namespace DBus

#include "networkmanagerproxy.moc"

// End of File

