// File autogenerated

#if !defined(DEVICEPROXY_H_INCLUDED)
#define DEVICEPROXY_H_INCLUDED

// TQt includes
#include <tqmap.h>
#include <tqobject.h>

// TQt D-Bus includes
#include <tqdbuserror.h>

// forward declarations
class TQString;
class TQT_DBusConnection;
class TQT_DBusData;
class TQT_DBusDataList;
class TQT_DBusError;
class TQT_DBusMessage;
class TQT_DBusObjectPath;
class TQT_DBusProxy;
class TQT_DBusVariant;
template <typename T> class TQValueList;

namespace DBus
{

class DeviceProxy : public TQObject
{
    TQ_OBJECT
    
public:
    DeviceProxy(const TQString& service, const TQString& path, TQObject* parent = 0, const char* name = 0);

    virtual ~DeviceProxy();

    void setConnection(const TQT_DBusConnection& connection);

signals:
    void AsyncErrorResponseDetected(int asyncCallId, const TQT_DBusError error);

    void StateChanged(TQ_UINT32 new_state, TQ_UINT32 old_state, TQ_UINT32 reason);

    void DisconnectAsyncReply(int asyncCallId);


public:
    virtual bool DisconnectAsync(int& asyncCallId, TQT_DBusError& error);

public:
    virtual void setDBusProperty(const TQString& name, const TQT_DBusVariant& variant, TQT_DBusError& error);
    virtual TQT_DBusVariant getDBusProperty(const TQString& name, TQT_DBusError& error) const;

    virtual TQString getUdi(TQT_DBusError& error) const;

    virtual TQString getInterface(TQT_DBusError& error) const;

    virtual TQString getIpInterface(TQT_DBusError& error) const;

    virtual TQString getDriver(TQT_DBusError& error) const;

    virtual TQString getDriverVersion(TQT_DBusError& error) const;

    virtual TQString getFirmwareVersion(TQT_DBusError& error) const;

    virtual TQ_UINT32 getCapabilities(TQT_DBusError& error) const;

    virtual TQ_INT32 getIp4Address(TQT_DBusError& error) const;

    virtual TQ_UINT32 getState(TQT_DBusError& error) const;

    virtual TQT_DBusData getStateReason(TQT_DBusError& error) const;

    virtual TQT_DBusObjectPath getActiveConnection(TQT_DBusError& error) const;

    virtual TQT_DBusObjectPath getIp4Config(TQT_DBusError& error) const;

    virtual TQT_DBusObjectPath getDhcp4Config(TQT_DBusError& error) const;

    virtual TQT_DBusObjectPath getIp6Config(TQT_DBusError& error) const;

    virtual TQT_DBusObjectPath getDhcp6Config(TQT_DBusError& error) const;

    virtual bool getManaged(TQT_DBusError& error) const;

    virtual void setAutoconnect(bool value, TQT_DBusError& error);
    virtual bool getAutoconnect(TQT_DBusError& error) const;

    virtual bool getFirmwareMissing(TQT_DBusError& error) const;

    virtual TQ_UINT32 getDeviceType(TQT_DBusError& error) const;

    virtual TQValueList< TQT_DBusObjectPath > getAvailableConnections(TQT_DBusError& error) const;

protected slots: // usually no need to reimplement
    virtual void slotHandleDBusSignal(const TQT_DBusMessage& message);

    virtual void slotHandleAsyncReply(int id, const TQT_DBusMessage& message);

protected:
    TQT_DBusProxy* m_baseProxy;

    TQMap<int, TQString> m_asyncCalls;

private: // Hiding copy constructor and assignment operator
    DeviceProxy(const DeviceProxy&);
    DeviceProxy& operator=(const DeviceProxy&);
}; // class DeviceProxy

}; // namespace DBus

#endif //DEVICEPROXY_H_INCLUDED

// End of File

