/*  This file is part of ksquirrel-libs (http://ksquirrel.sf.net)

    Copyright (c) 2004 Dmitry Baryshev <ksquirrel@tut.by>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation;
    either version 2 of the License, or (at your option) any later
    version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef KSQUIRREL_LIBS_UTILS_H
#define KSQUIRREL_LIBS_UTILS_H

#include <string>

using namespace std;

#include <ksquirrel-libs/fmt_types.h>

struct RGBA;

////////////////////////
//                    //
//  Helper namespace  //
//                    //
////////////////////////


namespace fmt_utils
{
  void LIBKSQUIRREL_EXPORT fillAlpha(RGBA *scan, int w, u8 value = 255);

	// flip the image vertically
	// usually BMP, SGI (or some other formats) need to be flipped
	void LIBKSQUIRREL_EXPORT flipv(s8 *image, s32 bytes_w, s32 h);

	// flip the image horizontally
	void LIBKSQUIRREL_EXPORT fliph(s8 *image, s32 w, s32 h, s32 bpp);

	// Big endian to Little endian conversion
	u16 LIBKSQUIRREL_EXPORT konvertWord(u16 a);
	u32 LIBKSQUIRREL_EXPORT konvertLong(u32 a);

	// return color system name by bpp.
	// for example 32 bpp means RGBA image, 1 bpp - monochrome
	std::string LIBKSQUIRREL_EXPORT colorSpaceByBpp(const s32 bpp);
	
	void LIBKSQUIRREL_EXPORT expandMono1Byte(const u32 byte, u8 *array);
	void LIBKSQUIRREL_EXPORT expandMono2Byte(const u32 byte, u8 *array);
	void LIBKSQUIRREL_EXPORT expandMono4Byte(const u32 byte, u8 *array);
}

#endif
