/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the tools applications of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of Qt Designer.  This header
// file may change from version to version without notice, or even be removed.
//
// We mean it.
//

// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT!

#ifndef UI4_H
#define UI4_H

#include <qlist.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qvector.h>
#include <qxmlstream.h>
#include <qglobal.h>

QT_BEGIN_NAMESPACE

#define QDESIGNER_UILIB_EXTERN Q_DECL_EXPORT
#define QDESIGNER_UILIB_IMPORT Q_DECL_IMPORT

#if defined(QT_DESIGNER_STATIC) || defined(QT_UIC) || defined(QT_UIC3)
#  define QDESIGNER_UILIB_EXPORT
#elif defined(QDESIGNER_UILIB_LIBRARY)
#  define QDESIGNER_UILIB_EXPORT QDESIGNER_UILIB_EXTERN
#else
#  define QDESIGNER_UILIB_EXPORT QDESIGNER_UILIB_IMPORT
#endif

#ifndef QDESIGNER_UILIB_EXPORT
#    define QDESIGNER_UILIB_EXPORT
#endif

#ifdef QFORMINTERNAL_NAMESPACE
namespace QFormInternal
{
#endif


/*******************************************************************************
** Forward declarations
*/

class DomUI;
class DomIncludes;
class DomInclude;
class DomResources;
class DomResource;
class DomActionGroup;
class DomAction;
class DomActionRef;
class DomButtonGroup;
class DomButtonGroups;
class DomCustomWidgets;
class DomHeader;
class DomCustomWidget;
class DomLayoutDefault;
class DomLayoutFunction;
class DomTabStops;
class DomLayout;
class DomLayoutItem;
class DomRow;
class DomColumn;
class DomItem;
class DomWidget;
class DomSpacer;
class DomColor;
class DomGradientStop;
class DomGradient;
class DomBrush;
class DomColorRole;
class DomColorGroup;
class DomPalette;
class DomFont;
class DomPoint;
class DomRect;
class DomLocale;
class DomSizePolicy;
class DomSize;
class DomDate;
class DomTime;
class DomDateTime;
class DomStringList;
class DomResourcePixmap;
class DomResourceIcon;
class DomString;
class DomPointF;
class DomRectF;
class DomSizeF;
class DomChar;
class DomUrl;
class DomProperty;
class DomConnections;
class DomConnection;
class DomConnectionHints;
class DomConnectionHint;
class DomDesignerData;
class DomSlots;
class DomPropertySpecifications;
class DomPropertyToolTip;
class DomStringPropertySpecification;

/*******************************************************************************
** Declarations
*/

class QDESIGNER_UILIB_EXPORT DomUI {
    Q_DISABLE_COPY(DomUI)
public:
    DomUI() = default;
    ~DomUI();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeVersion() const { return m_has_attr_version; }
    inline QString attributeVersion() const { return m_attr_version; }
    inline void setAttributeVersion(const QString &a) { m_attr_version = a; m_has_attr_version = true; }
    inline void clearAttributeVersion() { m_has_attr_version = false; }

    inline bool hasAttributeLanguage() const { return m_has_attr_language; }
    inline QString attributeLanguage() const { return m_attr_language; }
    inline void setAttributeLanguage(const QString &a) { m_attr_language = a; m_has_attr_language = true; }
    inline void clearAttributeLanguage() { m_has_attr_language = false; }

    inline bool hasAttributeDisplayname() const { return m_has_attr_displayname; }
    inline QString attributeDisplayname() const { return m_attr_displayname; }
    inline void setAttributeDisplayname(const QString &a) { m_attr_displayname = a; m_has_attr_displayname = true; }
    inline void clearAttributeDisplayname() { m_has_attr_displayname = false; }

    inline bool hasAttributeStdsetdef() const { return m_has_attr_stdsetdef; }
    inline int attributeStdsetdef() const { return m_attr_stdsetdef; }
    inline void setAttributeStdsetdef(int a) { m_attr_stdsetdef = a; m_has_attr_stdsetdef = true; }
    inline void clearAttributeStdsetdef() { m_has_attr_stdsetdef = false; }

    inline bool hasAttributeStdSetDef() const { return m_has_attr_stdSetDef; }
    inline int attributeStdSetDef() const { return m_attr_stdSetDef; }
    inline void setAttributeStdSetDef(int a) { m_attr_stdSetDef = a; m_has_attr_stdSetDef = true; }
    inline void clearAttributeStdSetDef() { m_has_attr_stdSetDef = false; }

    // child element accessors
    inline QString elementAuthor() const { return m_author; }
    void setElementAuthor(const QString &a);
    inline bool hasElementAuthor() const { return m_children & Author; }
    void clearElementAuthor();

    inline QString elementComment() const { return m_comment; }
    void setElementComment(const QString &a);
    inline bool hasElementComment() const { return m_children & Comment; }
    void clearElementComment();

    inline QString elementExportMacro() const { return m_exportMacro; }
    void setElementExportMacro(const QString &a);
    inline bool hasElementExportMacro() const { return m_children & ExportMacro; }
    void clearElementExportMacro();

    inline QString elementClass() const { return m_class; }
    void setElementClass(const QString &a);
    inline bool hasElementClass() const { return m_children & Class; }
    void clearElementClass();

    inline DomWidget *elementWidget() const { return m_widget; }
    DomWidget *takeElementWidget();
    void setElementWidget(DomWidget *a);
    inline bool hasElementWidget() const { return m_children & Widget; }
    void clearElementWidget();

    inline DomLayoutDefault *elementLayoutDefault() const { return m_layoutDefault; }
    DomLayoutDefault *takeElementLayoutDefault();
    void setElementLayoutDefault(DomLayoutDefault *a);
    inline bool hasElementLayoutDefault() const { return m_children & LayoutDefault; }
    void clearElementLayoutDefault();

    inline DomLayoutFunction *elementLayoutFunction() const { return m_layoutFunction; }
    DomLayoutFunction *takeElementLayoutFunction();
    void setElementLayoutFunction(DomLayoutFunction *a);
    inline bool hasElementLayoutFunction() const { return m_children & LayoutFunction; }
    void clearElementLayoutFunction();

    inline QString elementPixmapFunction() const { return m_pixmapFunction; }
    void setElementPixmapFunction(const QString &a);
    inline bool hasElementPixmapFunction() const { return m_children & PixmapFunction; }
    void clearElementPixmapFunction();

    inline DomCustomWidgets *elementCustomWidgets() const { return m_customWidgets; }
    DomCustomWidgets *takeElementCustomWidgets();
    void setElementCustomWidgets(DomCustomWidgets *a);
    inline bool hasElementCustomWidgets() const { return m_children & CustomWidgets; }
    void clearElementCustomWidgets();

    inline DomTabStops *elementTabStops() const { return m_tabStops; }
    DomTabStops *takeElementTabStops();
    void setElementTabStops(DomTabStops *a);
    inline bool hasElementTabStops() const { return m_children & TabStops; }
    void clearElementTabStops();

    inline DomIncludes *elementIncludes() const { return m_includes; }
    DomIncludes *takeElementIncludes();
    void setElementIncludes(DomIncludes *a);
    inline bool hasElementIncludes() const { return m_children & Includes; }
    void clearElementIncludes();

    inline DomResources *elementResources() const { return m_resources; }
    DomResources *takeElementResources();
    void setElementResources(DomResources *a);
    inline bool hasElementResources() const { return m_children & Resources; }
    void clearElementResources();

    inline DomConnections *elementConnections() const { return m_connections; }
    DomConnections *takeElementConnections();
    void setElementConnections(DomConnections *a);
    inline bool hasElementConnections() const { return m_children & Connections; }
    void clearElementConnections();

    inline DomDesignerData *elementDesignerdata() const { return m_designerdata; }
    DomDesignerData *takeElementDesignerdata();
    void setElementDesignerdata(DomDesignerData *a);
    inline bool hasElementDesignerdata() const { return m_children & Designerdata; }
    void clearElementDesignerdata();

    inline DomSlots *elementSlots() const { return m_slots; }
    DomSlots *takeElementSlots();
    void setElementSlots(DomSlots *a);
    inline bool hasElementSlots() const { return m_children & Slots; }
    void clearElementSlots();

    inline DomButtonGroups *elementButtonGroups() const { return m_buttonGroups; }
    DomButtonGroups *takeElementButtonGroups();
    void setElementButtonGroups(DomButtonGroups *a);
    inline bool hasElementButtonGroups() const { return m_children & ButtonGroups; }
    void clearElementButtonGroups();

private:
    // attribute data
    QString m_attr_version;
    bool m_has_attr_version = false;

    QString m_attr_language;
    bool m_has_attr_language = false;

    QString m_attr_displayname;
    bool m_has_attr_displayname = false;

    int m_attr_stdsetdef = 0;
    bool m_has_attr_stdsetdef = false;

    int m_attr_stdSetDef = 0;
    bool m_has_attr_stdSetDef = false;

    // child element data
    uint m_children = 0;
    QString m_author;
    QString m_comment;
    QString m_exportMacro;
    QString m_class;
    DomWidget *m_widget = nullptr;
    DomLayoutDefault *m_layoutDefault = nullptr;
    DomLayoutFunction *m_layoutFunction = nullptr;
    QString m_pixmapFunction;
    DomCustomWidgets *m_customWidgets = nullptr;
    DomTabStops *m_tabStops = nullptr;
    DomIncludes *m_includes = nullptr;
    DomResources *m_resources = nullptr;
    DomConnections *m_connections = nullptr;
    DomDesignerData *m_designerdata = nullptr;
    DomSlots *m_slots = nullptr;
    DomButtonGroups *m_buttonGroups = nullptr;

    enum Child {
        Author = 1,
        Comment = 2,
        ExportMacro = 4,
        Class = 8,
        Widget = 16,
        LayoutDefault = 32,
        LayoutFunction = 64,
        PixmapFunction = 128,
        CustomWidgets = 256,
        TabStops = 512,
        Includes = 1024,
        Resources = 2048,
        Connections = 4096,
        Designerdata = 8192,
        Slots = 16384,
        ButtonGroups = 32768
    };
};

class QDESIGNER_UILIB_EXPORT DomIncludes {
    Q_DISABLE_COPY(DomIncludes)
public:
    DomIncludes() = default;
    ~DomIncludes();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline QVector<DomInclude *> elementInclude() const { return m_include; }
    void setElementInclude(const QVector<DomInclude *> &a);

private:

    // child element data
    uint m_children = 0;
    QVector<DomInclude *> m_include;

    enum Child {
        Include = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomInclude {
    Q_DISABLE_COPY(DomInclude)
public:
    DomInclude() = default;
    ~DomInclude();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    inline QString text() const { return m_text; }
    inline void setText(const QString &s) { m_text = s; }

    // attribute accessors
    inline bool hasAttributeLocation() const { return m_has_attr_location; }
    inline QString attributeLocation() const { return m_attr_location; }
    inline void setAttributeLocation(const QString &a) { m_attr_location = a; m_has_attr_location = true; }
    inline void clearAttributeLocation() { m_has_attr_location = false; }

    inline bool hasAttributeImpldecl() const { return m_has_attr_impldecl; }
    inline QString attributeImpldecl() const { return m_attr_impldecl; }
    inline void setAttributeImpldecl(const QString &a) { m_attr_impldecl = a; m_has_attr_impldecl = true; }
    inline void clearAttributeImpldecl() { m_has_attr_impldecl = false; }

private:
    QString m_text;

    // attribute data
    QString m_attr_location;
    bool m_has_attr_location = false;

    QString m_attr_impldecl;
    bool m_has_attr_impldecl = false;
};

class QDESIGNER_UILIB_EXPORT DomResources {
    Q_DISABLE_COPY(DomResources)
public:
    DomResources() = default;
    ~DomResources();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeName() const { return m_has_attr_name; }
    inline QString attributeName() const { return m_attr_name; }
    inline void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    inline void clearAttributeName() { m_has_attr_name = false; }

    // child element accessors
    inline QVector<DomResource *> elementInclude() const { return m_include; }
    void setElementInclude(const QVector<DomResource *> &a);

private:
    // attribute data
    QString m_attr_name;
    bool m_has_attr_name = false;

    // child element data
    uint m_children = 0;
    QVector<DomResource *> m_include;

    enum Child {
        Include = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomResource {
    Q_DISABLE_COPY(DomResource)
public:
    DomResource() = default;
    ~DomResource();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeLocation() const { return m_has_attr_location; }
    inline QString attributeLocation() const { return m_attr_location; }
    inline void setAttributeLocation(const QString &a) { m_attr_location = a; m_has_attr_location = true; }
    inline void clearAttributeLocation() { m_has_attr_location = false; }

private:
    // attribute data
    QString m_attr_location;
    bool m_has_attr_location = false;
};

class QDESIGNER_UILIB_EXPORT DomActionGroup {
    Q_DISABLE_COPY(DomActionGroup)
public:
    DomActionGroup() = default;
    ~DomActionGroup();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeName() const { return m_has_attr_name; }
    inline QString attributeName() const { return m_attr_name; }
    inline void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    inline void clearAttributeName() { m_has_attr_name = false; }

    // child element accessors
    inline QVector<DomAction *> elementAction() const { return m_action; }
    void setElementAction(const QVector<DomAction *> &a);

    inline QVector<DomActionGroup *> elementActionGroup() const { return m_actionGroup; }
    void setElementActionGroup(const QVector<DomActionGroup *> &a);

    inline QList<DomProperty*> elementProperty() const { return m_property; }
    void setElementProperty(const QList<DomProperty *> &a);

    inline QList<DomProperty*> elementAttribute() const { return m_attribute; }
    void setElementAttribute(const QList<DomProperty *> &a);

private:
    // attribute data
    QString m_attr_name;
    bool m_has_attr_name = false;

    // child element data
    uint m_children = 0;
    QVector<DomAction *> m_action;
    QVector<DomActionGroup *> m_actionGroup;
    QList<DomProperty*> m_property;
    QList<DomProperty*> m_attribute;

    enum Child {
        Action = 1,
        ActionGroup = 2,
        Property = 4,
        Attribute = 8
    };
};

class QDESIGNER_UILIB_EXPORT DomAction {
    Q_DISABLE_COPY(DomAction)
public:
    DomAction() = default;
    ~DomAction();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeName() const { return m_has_attr_name; }
    inline QString attributeName() const { return m_attr_name; }
    inline void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    inline void clearAttributeName() { m_has_attr_name = false; }

    inline bool hasAttributeMenu() const { return m_has_attr_menu; }
    inline QString attributeMenu() const { return m_attr_menu; }
    inline void setAttributeMenu(const QString &a) { m_attr_menu = a; m_has_attr_menu = true; }
    inline void clearAttributeMenu() { m_has_attr_menu = false; }

    // child element accessors
    inline QList<DomProperty*> elementProperty() const { return m_property; }
    void setElementProperty(const QList<DomProperty *> &a);

    inline QList<DomProperty*> elementAttribute() const { return m_attribute; }
    void setElementAttribute(const QList<DomProperty *> &a);

private:
    // attribute data
    QString m_attr_name;
    bool m_has_attr_name = false;

    QString m_attr_menu;
    bool m_has_attr_menu = false;

    // child element data
    uint m_children = 0;
    QList<DomProperty*> m_property;
    QList<DomProperty*> m_attribute;

    enum Child {
        Property = 1,
        Attribute = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomActionRef {
    Q_DISABLE_COPY(DomActionRef)
public:
    DomActionRef() = default;
    ~DomActionRef();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeName() const { return m_has_attr_name; }
    inline QString attributeName() const { return m_attr_name; }
    inline void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    inline void clearAttributeName() { m_has_attr_name = false; }

private:
    // attribute data
    QString m_attr_name;
    bool m_has_attr_name = false;
};

class QDESIGNER_UILIB_EXPORT DomButtonGroup {
    Q_DISABLE_COPY(DomButtonGroup)
public:
    DomButtonGroup() = default;
    ~DomButtonGroup();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeName() const { return m_has_attr_name; }
    inline QString attributeName() const { return m_attr_name; }
    inline void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    inline void clearAttributeName() { m_has_attr_name = false; }

    // child element accessors
    inline QList<DomProperty*> elementProperty() const { return m_property; }
    void setElementProperty(const QList<DomProperty *> &a);

    inline QList<DomProperty*> elementAttribute() const { return m_attribute; }
    void setElementAttribute(const QList<DomProperty *> &a);

private:
    // attribute data
    QString m_attr_name;
    bool m_has_attr_name = false;

    // child element data
    uint m_children = 0;
    QList<DomProperty*> m_property;
    QList<DomProperty*> m_attribute;

    enum Child {
        Property = 1,
        Attribute = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomButtonGroups {
    Q_DISABLE_COPY(DomButtonGroups)
public:
    DomButtonGroups() = default;
    ~DomButtonGroups();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline QVector<DomButtonGroup *> elementButtonGroup() const { return m_buttonGroup; }
    void setElementButtonGroup(const QVector<DomButtonGroup *> &a);

private:

    // child element data
    uint m_children = 0;
    QVector<DomButtonGroup *> m_buttonGroup;

    enum Child {
        ButtonGroup = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomCustomWidgets {
    Q_DISABLE_COPY(DomCustomWidgets)
public:
    DomCustomWidgets() = default;
    ~DomCustomWidgets();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline QVector<DomCustomWidget *> elementCustomWidget() const { return m_customWidget; }
    void setElementCustomWidget(const QVector<DomCustomWidget *> &a);

private:

    // child element data
    uint m_children = 0;
    QVector<DomCustomWidget *> m_customWidget;

    enum Child {
        CustomWidget = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomHeader {
    Q_DISABLE_COPY(DomHeader)
public:
    DomHeader() = default;
    ~DomHeader();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    inline QString text() const { return m_text; }
    inline void setText(const QString &s) { m_text = s; }

    // attribute accessors
    inline bool hasAttributeLocation() const { return m_has_attr_location; }
    inline QString attributeLocation() const { return m_attr_location; }
    inline void setAttributeLocation(const QString &a) { m_attr_location = a; m_has_attr_location = true; }
    inline void clearAttributeLocation() { m_has_attr_location = false; }

private:
    QString m_text;

    // attribute data
    QString m_attr_location;
    bool m_has_attr_location = false;
};

class QDESIGNER_UILIB_EXPORT DomCustomWidget {
    Q_DISABLE_COPY(DomCustomWidget)
public:
    DomCustomWidget() = default;
    ~DomCustomWidget();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline QString elementClass() const { return m_class; }
    void setElementClass(const QString &a);
    inline bool hasElementClass() const { return m_children & Class; }
    void clearElementClass();

    inline QString elementExtends() const { return m_extends; }
    void setElementExtends(const QString &a);
    inline bool hasElementExtends() const { return m_children & Extends; }
    void clearElementExtends();

    inline DomHeader *elementHeader() const { return m_header; }
    DomHeader *takeElementHeader();
    void setElementHeader(DomHeader *a);
    inline bool hasElementHeader() const { return m_children & Header; }
    void clearElementHeader();

    inline DomSize *elementSizeHint() const { return m_sizeHint; }
    DomSize *takeElementSizeHint();
    void setElementSizeHint(DomSize *a);
    inline bool hasElementSizeHint() const { return m_children & SizeHint; }
    void clearElementSizeHint();

    inline QString elementAddPageMethod() const { return m_addPageMethod; }
    void setElementAddPageMethod(const QString &a);
    inline bool hasElementAddPageMethod() const { return m_children & AddPageMethod; }
    void clearElementAddPageMethod();

    inline int elementContainer() const { return m_container; }
    void setElementContainer(int a);
    inline bool hasElementContainer() const { return m_children & Container; }
    void clearElementContainer();

    inline QString elementPixmap() const { return m_pixmap; }
    void setElementPixmap(const QString &a);
    inline bool hasElementPixmap() const { return m_children & Pixmap; }
    void clearElementPixmap();

    inline DomSlots *elementSlots() const { return m_slots; }
    DomSlots *takeElementSlots();
    void setElementSlots(DomSlots *a);
    inline bool hasElementSlots() const { return m_children & Slots; }
    void clearElementSlots();

    inline DomPropertySpecifications *elementPropertyspecifications() const { return m_propertyspecifications; }
    DomPropertySpecifications *takeElementPropertyspecifications();
    void setElementPropertyspecifications(DomPropertySpecifications *a);
    inline bool hasElementPropertyspecifications() const { return m_children & Propertyspecifications; }
    void clearElementPropertyspecifications();

private:

    // child element data
    uint m_children = 0;
    QString m_class;
    QString m_extends;
    DomHeader *m_header = nullptr;
    DomSize *m_sizeHint = nullptr;
    QString m_addPageMethod;
    int m_container = 0;
    QString m_pixmap;
    DomSlots *m_slots = nullptr;
    DomPropertySpecifications *m_propertyspecifications = nullptr;

    enum Child {
        Class = 1,
        Extends = 2,
        Header = 4,
        SizeHint = 8,
        AddPageMethod = 16,
        Container = 32,
        Pixmap = 64,
        Slots = 128,
        Propertyspecifications = 256
    };
};

class QDESIGNER_UILIB_EXPORT DomLayoutDefault {
    Q_DISABLE_COPY(DomLayoutDefault)
public:
    DomLayoutDefault() = default;
    ~DomLayoutDefault();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeSpacing() const { return m_has_attr_spacing; }
    inline int attributeSpacing() const { return m_attr_spacing; }
    inline void setAttributeSpacing(int a) { m_attr_spacing = a; m_has_attr_spacing = true; }
    inline void clearAttributeSpacing() { m_has_attr_spacing = false; }

    inline bool hasAttributeMargin() const { return m_has_attr_margin; }
    inline int attributeMargin() const { return m_attr_margin; }
    inline void setAttributeMargin(int a) { m_attr_margin = a; m_has_attr_margin = true; }
    inline void clearAttributeMargin() { m_has_attr_margin = false; }

private:
    // attribute data
    int m_attr_spacing = 0;
    bool m_has_attr_spacing = false;

    int m_attr_margin = 0;
    bool m_has_attr_margin = false;
};

class QDESIGNER_UILIB_EXPORT DomLayoutFunction {
    Q_DISABLE_COPY(DomLayoutFunction)
public:
    DomLayoutFunction() = default;
    ~DomLayoutFunction();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeSpacing() const { return m_has_attr_spacing; }
    inline QString attributeSpacing() const { return m_attr_spacing; }
    inline void setAttributeSpacing(const QString &a) { m_attr_spacing = a; m_has_attr_spacing = true; }
    inline void clearAttributeSpacing() { m_has_attr_spacing = false; }

    inline bool hasAttributeMargin() const { return m_has_attr_margin; }
    inline QString attributeMargin() const { return m_attr_margin; }
    inline void setAttributeMargin(const QString &a) { m_attr_margin = a; m_has_attr_margin = true; }
    inline void clearAttributeMargin() { m_has_attr_margin = false; }

private:
    // attribute data
    QString m_attr_spacing;
    bool m_has_attr_spacing = false;

    QString m_attr_margin;
    bool m_has_attr_margin = false;
};

class QDESIGNER_UILIB_EXPORT DomTabStops {
    Q_DISABLE_COPY(DomTabStops)
public:
    DomTabStops() = default;
    ~DomTabStops();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline QStringList elementTabStop() const { return m_tabStop; }
    void setElementTabStop(const QStringList &a);

private:

    // child element data
    uint m_children = 0;
    QStringList m_tabStop;

    enum Child {
        TabStop = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomLayout {
    Q_DISABLE_COPY(DomLayout)
public:
    DomLayout() = default;
    ~DomLayout();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeClass() const { return m_has_attr_class; }
    inline QString attributeClass() const { return m_attr_class; }
    inline void setAttributeClass(const QString &a) { m_attr_class = a; m_has_attr_class = true; }
    inline void clearAttributeClass() { m_has_attr_class = false; }

    inline bool hasAttributeName() const { return m_has_attr_name; }
    inline QString attributeName() const { return m_attr_name; }
    inline void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    inline void clearAttributeName() { m_has_attr_name = false; }

    inline bool hasAttributeStretch() const { return m_has_attr_stretch; }
    inline QString attributeStretch() const { return m_attr_stretch; }
    inline void setAttributeStretch(const QString &a) { m_attr_stretch = a; m_has_attr_stretch = true; }
    inline void clearAttributeStretch() { m_has_attr_stretch = false; }

    inline bool hasAttributeRowStretch() const { return m_has_attr_rowStretch; }
    inline QString attributeRowStretch() const { return m_attr_rowStretch; }
    inline void setAttributeRowStretch(const QString &a) { m_attr_rowStretch = a; m_has_attr_rowStretch = true; }
    inline void clearAttributeRowStretch() { m_has_attr_rowStretch = false; }

    inline bool hasAttributeColumnStretch() const { return m_has_attr_columnStretch; }
    inline QString attributeColumnStretch() const { return m_attr_columnStretch; }
    inline void setAttributeColumnStretch(const QString &a) { m_attr_columnStretch = a; m_has_attr_columnStretch = true; }
    inline void clearAttributeColumnStretch() { m_has_attr_columnStretch = false; }

    inline bool hasAttributeRowMinimumHeight() const { return m_has_attr_rowMinimumHeight; }
    inline QString attributeRowMinimumHeight() const { return m_attr_rowMinimumHeight; }
    inline void setAttributeRowMinimumHeight(const QString &a) { m_attr_rowMinimumHeight = a; m_has_attr_rowMinimumHeight = true; }
    inline void clearAttributeRowMinimumHeight() { m_has_attr_rowMinimumHeight = false; }

    inline bool hasAttributeColumnMinimumWidth() const { return m_has_attr_columnMinimumWidth; }
    inline QString attributeColumnMinimumWidth() const { return m_attr_columnMinimumWidth; }
    inline void setAttributeColumnMinimumWidth(const QString &a) { m_attr_columnMinimumWidth = a; m_has_attr_columnMinimumWidth = true; }
    inline void clearAttributeColumnMinimumWidth() { m_has_attr_columnMinimumWidth = false; }

    // child element accessors
    inline QList<DomProperty*> elementProperty() const { return m_property; }
    void setElementProperty(const QList<DomProperty *> &a);

    inline QList<DomProperty*> elementAttribute() const { return m_attribute; }
    void setElementAttribute(const QList<DomProperty *> &a);

    inline QVector<DomLayoutItem *> elementItem() const { return m_item; }
    void setElementItem(const QVector<DomLayoutItem *> &a);

private:
    // attribute data
    QString m_attr_class;
    bool m_has_attr_class = false;

    QString m_attr_name;
    bool m_has_attr_name = false;

    QString m_attr_stretch;
    bool m_has_attr_stretch = false;

    QString m_attr_rowStretch;
    bool m_has_attr_rowStretch = false;

    QString m_attr_columnStretch;
    bool m_has_attr_columnStretch = false;

    QString m_attr_rowMinimumHeight;
    bool m_has_attr_rowMinimumHeight = false;

    QString m_attr_columnMinimumWidth;
    bool m_has_attr_columnMinimumWidth = false;

    // child element data
    uint m_children = 0;
    QList<DomProperty*> m_property;
    QList<DomProperty*> m_attribute;
    QVector<DomLayoutItem *> m_item;

    enum Child {
        Property = 1,
        Attribute = 2,
        Item = 4
    };
};

class QDESIGNER_UILIB_EXPORT DomLayoutItem {
    Q_DISABLE_COPY(DomLayoutItem)
public:
    DomLayoutItem() = default;
    ~DomLayoutItem();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeRow() const { return m_has_attr_row; }
    inline int attributeRow() const { return m_attr_row; }
    inline void setAttributeRow(int a) { m_attr_row = a; m_has_attr_row = true; }
    inline void clearAttributeRow() { m_has_attr_row = false; }

    inline bool hasAttributeColumn() const { return m_has_attr_column; }
    inline int attributeColumn() const { return m_attr_column; }
    inline void setAttributeColumn(int a) { m_attr_column = a; m_has_attr_column = true; }
    inline void clearAttributeColumn() { m_has_attr_column = false; }

    inline bool hasAttributeRowSpan() const { return m_has_attr_rowSpan; }
    inline int attributeRowSpan() const { return m_attr_rowSpan; }
    inline void setAttributeRowSpan(int a) { m_attr_rowSpan = a; m_has_attr_rowSpan = true; }
    inline void clearAttributeRowSpan() { m_has_attr_rowSpan = false; }

    inline bool hasAttributeColSpan() const { return m_has_attr_colSpan; }
    inline int attributeColSpan() const { return m_attr_colSpan; }
    inline void setAttributeColSpan(int a) { m_attr_colSpan = a; m_has_attr_colSpan = true; }
    inline void clearAttributeColSpan() { m_has_attr_colSpan = false; }

    inline bool hasAttributeAlignment() const { return m_has_attr_alignment; }
    inline QString attributeAlignment() const { return m_attr_alignment; }
    inline void setAttributeAlignment(const QString &a) { m_attr_alignment = a; m_has_attr_alignment = true; }
    inline void clearAttributeAlignment() { m_has_attr_alignment = false; }

    // child element accessors
    enum Kind { Unknown = 0, Widget, Layout, Spacer };
    inline Kind kind() const { return m_kind; }

    inline DomWidget *elementWidget() const { return m_widget; }
    DomWidget *takeElementWidget();
    void setElementWidget(DomWidget *a);

    inline DomLayout *elementLayout() const { return m_layout; }
    DomLayout *takeElementLayout();
    void setElementLayout(DomLayout *a);

    inline DomSpacer *elementSpacer() const { return m_spacer; }
    DomSpacer *takeElementSpacer();
    void setElementSpacer(DomSpacer *a);

private:
    void clear();

    // attribute data
    int m_attr_row = 0;
    bool m_has_attr_row = false;

    int m_attr_column = 0;
    bool m_has_attr_column = false;

    int m_attr_rowSpan = 0;
    bool m_has_attr_rowSpan = false;

    int m_attr_colSpan = 0;
    bool m_has_attr_colSpan = false;

    QString m_attr_alignment;
    bool m_has_attr_alignment = false;

    // child element data
    Kind m_kind = Unknown;
    DomWidget *m_widget = nullptr;
    DomLayout *m_layout = nullptr;
    DomSpacer *m_spacer = nullptr;
};

class QDESIGNER_UILIB_EXPORT DomRow {
    Q_DISABLE_COPY(DomRow)
public:
    DomRow() = default;
    ~DomRow();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline QList<DomProperty*> elementProperty() const { return m_property; }
    void setElementProperty(const QList<DomProperty *> &a);

private:

    // child element data
    uint m_children = 0;
    QList<DomProperty*> m_property;

    enum Child {
        Property = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomColumn {
    Q_DISABLE_COPY(DomColumn)
public:
    DomColumn() = default;
    ~DomColumn();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline QList<DomProperty*> elementProperty() const { return m_property; }
    void setElementProperty(const QList<DomProperty *> &a);

private:

    // child element data
    uint m_children = 0;
    QList<DomProperty*> m_property;

    enum Child {
        Property = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomItem {
    Q_DISABLE_COPY(DomItem)
public:
    DomItem() = default;
    ~DomItem();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeRow() const { return m_has_attr_row; }
    inline int attributeRow() const { return m_attr_row; }
    inline void setAttributeRow(int a) { m_attr_row = a; m_has_attr_row = true; }
    inline void clearAttributeRow() { m_has_attr_row = false; }

    inline bool hasAttributeColumn() const { return m_has_attr_column; }
    inline int attributeColumn() const { return m_attr_column; }
    inline void setAttributeColumn(int a) { m_attr_column = a; m_has_attr_column = true; }
    inline void clearAttributeColumn() { m_has_attr_column = false; }

    // child element accessors
    inline QList<DomProperty*> elementProperty() const { return m_property; }
    void setElementProperty(const QList<DomProperty *> &a);

    inline QVector<DomItem *> elementItem() const { return m_item; }
    void setElementItem(const QVector<DomItem *> &a);

private:
    // attribute data
    int m_attr_row = 0;
    bool m_has_attr_row = false;

    int m_attr_column = 0;
    bool m_has_attr_column = false;

    // child element data
    uint m_children = 0;
    QList<DomProperty*> m_property;
    QVector<DomItem *> m_item;

    enum Child {
        Property = 1,
        Item = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomWidget {
    Q_DISABLE_COPY(DomWidget)
public:
    DomWidget() = default;
    ~DomWidget();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeClass() const { return m_has_attr_class; }
    inline QString attributeClass() const { return m_attr_class; }
    inline void setAttributeClass(const QString &a) { m_attr_class = a; m_has_attr_class = true; }
    inline void clearAttributeClass() { m_has_attr_class = false; }

    inline bool hasAttributeName() const { return m_has_attr_name; }
    inline QString attributeName() const { return m_attr_name; }
    inline void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    inline void clearAttributeName() { m_has_attr_name = false; }

    inline bool hasAttributeNative() const { return m_has_attr_native; }
    inline bool attributeNative() const { return m_attr_native; }
    inline void setAttributeNative(bool a) { m_attr_native = a; m_has_attr_native = true; }
    inline void clearAttributeNative() { m_has_attr_native = false; }

    // child element accessors
    inline QStringList elementClass() const { return m_class; }
    void setElementClass(const QStringList &a);

    inline QList<DomProperty*> elementProperty() const { return m_property; }
    void setElementProperty(const QList<DomProperty *> &a);

    inline QList<DomProperty*> elementAttribute() const { return m_attribute; }
    void setElementAttribute(const QList<DomProperty *> &a);

    inline QVector<DomRow *> elementRow() const { return m_row; }
    void setElementRow(const QVector<DomRow *> &a);

    inline QVector<DomColumn *> elementColumn() const { return m_column; }
    void setElementColumn(const QVector<DomColumn *> &a);

    inline QVector<DomItem *> elementItem() const { return m_item; }
    void setElementItem(const QVector<DomItem *> &a);

    inline QVector<DomLayout *> elementLayout() const { return m_layout; }
    void setElementLayout(const QVector<DomLayout *> &a);

    inline QVector<DomWidget *> elementWidget() const { return m_widget; }
    void setElementWidget(const QVector<DomWidget *> &a);

    inline QVector<DomAction *> elementAction() const { return m_action; }
    void setElementAction(const QVector<DomAction *> &a);

    inline QVector<DomActionGroup *> elementActionGroup() const { return m_actionGroup; }
    void setElementActionGroup(const QVector<DomActionGroup *> &a);

    inline QVector<DomActionRef *> elementAddAction() const { return m_addAction; }
    void setElementAddAction(const QVector<DomActionRef *> &a);

    inline QStringList elementZOrder() const { return m_zOrder; }
    void setElementZOrder(const QStringList &a);

private:
    // attribute data
    QString m_attr_class;
    bool m_has_attr_class = false;

    QString m_attr_name;
    bool m_has_attr_name = false;

    bool m_attr_native = false;
    bool m_has_attr_native = false;

    // child element data
    uint m_children = 0;
    QStringList m_class;
    QList<DomProperty*> m_property;
    QList<DomProperty*> m_attribute;
    QVector<DomRow *> m_row;
    QVector<DomColumn *> m_column;
    QVector<DomItem *> m_item;
    QVector<DomLayout *> m_layout;
    QVector<DomWidget *> m_widget;
    QVector<DomAction *> m_action;
    QVector<DomActionGroup *> m_actionGroup;
    QVector<DomActionRef *> m_addAction;
    QStringList m_zOrder;

    enum Child {
        Class = 1,
        Property = 2,
        Attribute = 4,
        Row = 8,
        Column = 16,
        Item = 32,
        Layout = 64,
        Widget = 128,
        Action = 256,
        ActionGroup = 512,
        AddAction = 1024,
        ZOrder = 2048
    };
};

class QDESIGNER_UILIB_EXPORT DomSpacer {
    Q_DISABLE_COPY(DomSpacer)
public:
    DomSpacer() = default;
    ~DomSpacer();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeName() const { return m_has_attr_name; }
    inline QString attributeName() const { return m_attr_name; }
    inline void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    inline void clearAttributeName() { m_has_attr_name = false; }

    // child element accessors
    inline QList<DomProperty*> elementProperty() const { return m_property; }
    void setElementProperty(const QList<DomProperty *> &a);

private:
    // attribute data
    QString m_attr_name;
    bool m_has_attr_name = false;

    // child element data
    uint m_children = 0;
    QList<DomProperty*> m_property;

    enum Child {
        Property = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomColor {
    Q_DISABLE_COPY(DomColor)
public:
    DomColor() = default;
    ~DomColor();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeAlpha() const { return m_has_attr_alpha; }
    inline int attributeAlpha() const { return m_attr_alpha; }
    inline void setAttributeAlpha(int a) { m_attr_alpha = a; m_has_attr_alpha = true; }
    inline void clearAttributeAlpha() { m_has_attr_alpha = false; }

    // child element accessors
    inline int elementRed() const { return m_red; }
    void setElementRed(int a);
    inline bool hasElementRed() const { return m_children & Red; }
    void clearElementRed();

    inline int elementGreen() const { return m_green; }
    void setElementGreen(int a);
    inline bool hasElementGreen() const { return m_children & Green; }
    void clearElementGreen();

    inline int elementBlue() const { return m_blue; }
    void setElementBlue(int a);
    inline bool hasElementBlue() const { return m_children & Blue; }
    void clearElementBlue();

private:
    // attribute data
    int m_attr_alpha = 0;
    bool m_has_attr_alpha = false;

    // child element data
    uint m_children = 0;
    int m_red = 0;
    int m_green = 0;
    int m_blue = 0;

    enum Child {
        Red = 1,
        Green = 2,
        Blue = 4
    };
};

class QDESIGNER_UILIB_EXPORT DomGradientStop {
    Q_DISABLE_COPY(DomGradientStop)
public:
    DomGradientStop() = default;
    ~DomGradientStop();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributePosition() const { return m_has_attr_position; }
    inline double attributePosition() const { return m_attr_position; }
    inline void setAttributePosition(double a) { m_attr_position = a; m_has_attr_position = true; }
    inline void clearAttributePosition() { m_has_attr_position = false; }

    // child element accessors
    inline DomColor *elementColor() const { return m_color; }
    DomColor *takeElementColor();
    void setElementColor(DomColor *a);
    inline bool hasElementColor() const { return m_children & Color; }
    void clearElementColor();

private:
    // attribute data
    double m_attr_position = 0.0;
    bool m_has_attr_position = false;

    // child element data
    uint m_children = 0;
    DomColor *m_color = nullptr;

    enum Child {
        Color = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomGradient {
    Q_DISABLE_COPY(DomGradient)
public:
    DomGradient() = default;
    ~DomGradient();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeStartX() const { return m_has_attr_startX; }
    inline double attributeStartX() const { return m_attr_startX; }
    inline void setAttributeStartX(double a) { m_attr_startX = a; m_has_attr_startX = true; }
    inline void clearAttributeStartX() { m_has_attr_startX = false; }

    inline bool hasAttributeStartY() const { return m_has_attr_startY; }
    inline double attributeStartY() const { return m_attr_startY; }
    inline void setAttributeStartY(double a) { m_attr_startY = a; m_has_attr_startY = true; }
    inline void clearAttributeStartY() { m_has_attr_startY = false; }

    inline bool hasAttributeEndX() const { return m_has_attr_endX; }
    inline double attributeEndX() const { return m_attr_endX; }
    inline void setAttributeEndX(double a) { m_attr_endX = a; m_has_attr_endX = true; }
    inline void clearAttributeEndX() { m_has_attr_endX = false; }

    inline bool hasAttributeEndY() const { return m_has_attr_endY; }
    inline double attributeEndY() const { return m_attr_endY; }
    inline void setAttributeEndY(double a) { m_attr_endY = a; m_has_attr_endY = true; }
    inline void clearAttributeEndY() { m_has_attr_endY = false; }

    inline bool hasAttributeCentralX() const { return m_has_attr_centralX; }
    inline double attributeCentralX() const { return m_attr_centralX; }
    inline void setAttributeCentralX(double a) { m_attr_centralX = a; m_has_attr_centralX = true; }
    inline void clearAttributeCentralX() { m_has_attr_centralX = false; }

    inline bool hasAttributeCentralY() const { return m_has_attr_centralY; }
    inline double attributeCentralY() const { return m_attr_centralY; }
    inline void setAttributeCentralY(double a) { m_attr_centralY = a; m_has_attr_centralY = true; }
    inline void clearAttributeCentralY() { m_has_attr_centralY = false; }

    inline bool hasAttributeFocalX() const { return m_has_attr_focalX; }
    inline double attributeFocalX() const { return m_attr_focalX; }
    inline void setAttributeFocalX(double a) { m_attr_focalX = a; m_has_attr_focalX = true; }
    inline void clearAttributeFocalX() { m_has_attr_focalX = false; }

    inline bool hasAttributeFocalY() const { return m_has_attr_focalY; }
    inline double attributeFocalY() const { return m_attr_focalY; }
    inline void setAttributeFocalY(double a) { m_attr_focalY = a; m_has_attr_focalY = true; }
    inline void clearAttributeFocalY() { m_has_attr_focalY = false; }

    inline bool hasAttributeRadius() const { return m_has_attr_radius; }
    inline double attributeRadius() const { return m_attr_radius; }
    inline void setAttributeRadius(double a) { m_attr_radius = a; m_has_attr_radius = true; }
    inline void clearAttributeRadius() { m_has_attr_radius = false; }

    inline bool hasAttributeAngle() const { return m_has_attr_angle; }
    inline double attributeAngle() const { return m_attr_angle; }
    inline void setAttributeAngle(double a) { m_attr_angle = a; m_has_attr_angle = true; }
    inline void clearAttributeAngle() { m_has_attr_angle = false; }

    inline bool hasAttributeType() const { return m_has_attr_type; }
    inline QString attributeType() const { return m_attr_type; }
    inline void setAttributeType(const QString &a) { m_attr_type = a; m_has_attr_type = true; }
    inline void clearAttributeType() { m_has_attr_type = false; }

    inline bool hasAttributeSpread() const { return m_has_attr_spread; }
    inline QString attributeSpread() const { return m_attr_spread; }
    inline void setAttributeSpread(const QString &a) { m_attr_spread = a; m_has_attr_spread = true; }
    inline void clearAttributeSpread() { m_has_attr_spread = false; }

    inline bool hasAttributeCoordinateMode() const { return m_has_attr_coordinateMode; }
    inline QString attributeCoordinateMode() const { return m_attr_coordinateMode; }
    inline void setAttributeCoordinateMode(const QString &a) { m_attr_coordinateMode = a; m_has_attr_coordinateMode = true; }
    inline void clearAttributeCoordinateMode() { m_has_attr_coordinateMode = false; }

    // child element accessors
    inline QVector<DomGradientStop *> elementGradientStop() const { return m_gradientStop; }
    void setElementGradientStop(const QVector<DomGradientStop *> &a);

private:
    // attribute data
    double m_attr_startX = 0.0;
    bool m_has_attr_startX = false;

    double m_attr_startY = 0.0;
    bool m_has_attr_startY = false;

    double m_attr_endX = 0.0;
    bool m_has_attr_endX = false;

    double m_attr_endY = 0.0;
    bool m_has_attr_endY = false;

    double m_attr_centralX = 0.0;
    bool m_has_attr_centralX = false;

    double m_attr_centralY = 0.0;
    bool m_has_attr_centralY = false;

    double m_attr_focalX = 0.0;
    bool m_has_attr_focalX = false;

    double m_attr_focalY = 0.0;
    bool m_has_attr_focalY = false;

    double m_attr_radius = 0.0;
    bool m_has_attr_radius = false;

    double m_attr_angle = 0.0;
    bool m_has_attr_angle = false;

    QString m_attr_type;
    bool m_has_attr_type = false;

    QString m_attr_spread;
    bool m_has_attr_spread = false;

    QString m_attr_coordinateMode;
    bool m_has_attr_coordinateMode = false;

    // child element data
    uint m_children = 0;
    QVector<DomGradientStop *> m_gradientStop;

    enum Child {
        GradientStop = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomBrush {
    Q_DISABLE_COPY(DomBrush)
public:
    DomBrush() = default;
    ~DomBrush();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeBrushStyle() const { return m_has_attr_brushStyle; }
    inline QString attributeBrushStyle() const { return m_attr_brushStyle; }
    inline void setAttributeBrushStyle(const QString &a) { m_attr_brushStyle = a; m_has_attr_brushStyle = true; }
    inline void clearAttributeBrushStyle() { m_has_attr_brushStyle = false; }

    // child element accessors
    enum Kind { Unknown = 0, Color, Texture, Gradient };
    inline Kind kind() const { return m_kind; }

    inline DomColor *elementColor() const { return m_color; }
    DomColor *takeElementColor();
    void setElementColor(DomColor *a);

    inline DomProperty *elementTexture() const { return m_texture; }
    DomProperty *takeElementTexture();
    void setElementTexture(DomProperty *a);

    inline DomGradient *elementGradient() const { return m_gradient; }
    DomGradient *takeElementGradient();
    void setElementGradient(DomGradient *a);

private:
    void clear();

    // attribute data
    QString m_attr_brushStyle;
    bool m_has_attr_brushStyle = false;

    // child element data
    Kind m_kind = Unknown;
    DomColor *m_color = nullptr;
    DomProperty *m_texture = nullptr;
    DomGradient *m_gradient = nullptr;
};

class QDESIGNER_UILIB_EXPORT DomColorRole {
    Q_DISABLE_COPY(DomColorRole)
public:
    DomColorRole() = default;
    ~DomColorRole();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeRole() const { return m_has_attr_role; }
    inline QString attributeRole() const { return m_attr_role; }
    inline void setAttributeRole(const QString &a) { m_attr_role = a; m_has_attr_role = true; }
    inline void clearAttributeRole() { m_has_attr_role = false; }

    // child element accessors
    inline DomBrush *elementBrush() const { return m_brush; }
    DomBrush *takeElementBrush();
    void setElementBrush(DomBrush *a);
    inline bool hasElementBrush() const { return m_children & Brush; }
    void clearElementBrush();

private:
    // attribute data
    QString m_attr_role;
    bool m_has_attr_role = false;

    // child element data
    uint m_children = 0;
    DomBrush *m_brush = nullptr;

    enum Child {
        Brush = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomColorGroup {
    Q_DISABLE_COPY(DomColorGroup)
public:
    DomColorGroup() = default;
    ~DomColorGroup();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline QVector<DomColorRole *> elementColorRole() const { return m_colorRole; }
    void setElementColorRole(const QVector<DomColorRole *> &a);

    inline QVector<DomColor *> elementColor() const { return m_color; }
    void setElementColor(const QVector<DomColor *> &a);

private:

    // child element data
    uint m_children = 0;
    QVector<DomColorRole *> m_colorRole;
    QVector<DomColor *> m_color;

    enum Child {
        ColorRole = 1,
        Color = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomPalette {
    Q_DISABLE_COPY(DomPalette)
public:
    DomPalette() = default;
    ~DomPalette();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline DomColorGroup *elementActive() const { return m_active; }
    DomColorGroup *takeElementActive();
    void setElementActive(DomColorGroup *a);
    inline bool hasElementActive() const { return m_children & Active; }
    void clearElementActive();

    inline DomColorGroup *elementInactive() const { return m_inactive; }
    DomColorGroup *takeElementInactive();
    void setElementInactive(DomColorGroup *a);
    inline bool hasElementInactive() const { return m_children & Inactive; }
    void clearElementInactive();

    inline DomColorGroup *elementDisabled() const { return m_disabled; }
    DomColorGroup *takeElementDisabled();
    void setElementDisabled(DomColorGroup *a);
    inline bool hasElementDisabled() const { return m_children & Disabled; }
    void clearElementDisabled();

private:

    // child element data
    uint m_children = 0;
    DomColorGroup *m_active = nullptr;
    DomColorGroup *m_inactive = nullptr;
    DomColorGroup *m_disabled = nullptr;

    enum Child {
        Active = 1,
        Inactive = 2,
        Disabled = 4
    };
};

class QDESIGNER_UILIB_EXPORT DomFont {
    Q_DISABLE_COPY(DomFont)
public:
    DomFont() = default;
    ~DomFont();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline QString elementFamily() const { return m_family; }
    void setElementFamily(const QString &a);
    inline bool hasElementFamily() const { return m_children & Family; }
    void clearElementFamily();

    inline int elementPointSize() const { return m_pointSize; }
    void setElementPointSize(int a);
    inline bool hasElementPointSize() const { return m_children & PointSize; }
    void clearElementPointSize();

    inline int elementWeight() const { return m_weight; }
    void setElementWeight(int a);
    inline bool hasElementWeight() const { return m_children & Weight; }
    void clearElementWeight();

    inline bool elementItalic() const { return m_italic; }
    void setElementItalic(bool a);
    inline bool hasElementItalic() const { return m_children & Italic; }
    void clearElementItalic();

    inline bool elementBold() const { return m_bold; }
    void setElementBold(bool a);
    inline bool hasElementBold() const { return m_children & Bold; }
    void clearElementBold();

    inline bool elementUnderline() const { return m_underline; }
    void setElementUnderline(bool a);
    inline bool hasElementUnderline() const { return m_children & Underline; }
    void clearElementUnderline();

    inline bool elementStrikeOut() const { return m_strikeOut; }
    void setElementStrikeOut(bool a);
    inline bool hasElementStrikeOut() const { return m_children & StrikeOut; }
    void clearElementStrikeOut();

    inline bool elementAntialiasing() const { return m_antialiasing; }
    void setElementAntialiasing(bool a);
    inline bool hasElementAntialiasing() const { return m_children & Antialiasing; }
    void clearElementAntialiasing();

    inline QString elementStyleStrategy() const { return m_styleStrategy; }
    void setElementStyleStrategy(const QString &a);
    inline bool hasElementStyleStrategy() const { return m_children & StyleStrategy; }
    void clearElementStyleStrategy();

    inline bool elementKerning() const { return m_kerning; }
    void setElementKerning(bool a);
    inline bool hasElementKerning() const { return m_children & Kerning; }
    void clearElementKerning();

private:

    // child element data
    uint m_children = 0;
    QString m_family;
    int m_pointSize = 0;
    int m_weight = 0;
    bool m_italic = false;
    bool m_bold = false;
    bool m_underline = false;
    bool m_strikeOut = false;
    bool m_antialiasing = false;
    QString m_styleStrategy;
    bool m_kerning = false;

    enum Child {
        Family = 1,
        PointSize = 2,
        Weight = 4,
        Italic = 8,
        Bold = 16,
        Underline = 32,
        StrikeOut = 64,
        Antialiasing = 128,
        StyleStrategy = 256,
        Kerning = 512
    };
};

class QDESIGNER_UILIB_EXPORT DomPoint {
    Q_DISABLE_COPY(DomPoint)
public:
    DomPoint() = default;
    ~DomPoint();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline int elementX() const { return m_x; }
    void setElementX(int a);
    inline bool hasElementX() const { return m_children & X; }
    void clearElementX();

    inline int elementY() const { return m_y; }
    void setElementY(int a);
    inline bool hasElementY() const { return m_children & Y; }
    void clearElementY();

private:

    // child element data
    uint m_children = 0;
    int m_x = 0;
    int m_y = 0;

    enum Child {
        X = 1,
        Y = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomRect {
    Q_DISABLE_COPY(DomRect)
public:
    DomRect() = default;
    ~DomRect();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline int elementX() const { return m_x; }
    void setElementX(int a);
    inline bool hasElementX() const { return m_children & X; }
    void clearElementX();

    inline int elementY() const { return m_y; }
    void setElementY(int a);
    inline bool hasElementY() const { return m_children & Y; }
    void clearElementY();

    inline int elementWidth() const { return m_width; }
    void setElementWidth(int a);
    inline bool hasElementWidth() const { return m_children & Width; }
    void clearElementWidth();

    inline int elementHeight() const { return m_height; }
    void setElementHeight(int a);
    inline bool hasElementHeight() const { return m_children & Height; }
    void clearElementHeight();

private:

    // child element data
    uint m_children = 0;
    int m_x = 0;
    int m_y = 0;
    int m_width = 0;
    int m_height = 0;

    enum Child {
        X = 1,
        Y = 2,
        Width = 4,
        Height = 8
    };
};

class QDESIGNER_UILIB_EXPORT DomLocale {
    Q_DISABLE_COPY(DomLocale)
public:
    DomLocale() = default;
    ~DomLocale();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeLanguage() const { return m_has_attr_language; }
    inline QString attributeLanguage() const { return m_attr_language; }
    inline void setAttributeLanguage(const QString &a) { m_attr_language = a; m_has_attr_language = true; }
    inline void clearAttributeLanguage() { m_has_attr_language = false; }

    inline bool hasAttributeCountry() const { return m_has_attr_country; }
    inline QString attributeCountry() const { return m_attr_country; }
    inline void setAttributeCountry(const QString &a) { m_attr_country = a; m_has_attr_country = true; }
    inline void clearAttributeCountry() { m_has_attr_country = false; }

private:
    // attribute data
    QString m_attr_language;
    bool m_has_attr_language = false;

    QString m_attr_country;
    bool m_has_attr_country = false;
};

class QDESIGNER_UILIB_EXPORT DomSizePolicy {
    Q_DISABLE_COPY(DomSizePolicy)
public:
    DomSizePolicy() = default;
    ~DomSizePolicy();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeHSizeType() const { return m_has_attr_hSizeType; }
    inline QString attributeHSizeType() const { return m_attr_hSizeType; }
    inline void setAttributeHSizeType(const QString &a) { m_attr_hSizeType = a; m_has_attr_hSizeType = true; }
    inline void clearAttributeHSizeType() { m_has_attr_hSizeType = false; }

    inline bool hasAttributeVSizeType() const { return m_has_attr_vSizeType; }
    inline QString attributeVSizeType() const { return m_attr_vSizeType; }
    inline void setAttributeVSizeType(const QString &a) { m_attr_vSizeType = a; m_has_attr_vSizeType = true; }
    inline void clearAttributeVSizeType() { m_has_attr_vSizeType = false; }

    // child element accessors
    inline int elementHSizeType() const { return m_hSizeType; }
    void setElementHSizeType(int a);
    inline bool hasElementHSizeType() const { return m_children & HSizeType; }
    void clearElementHSizeType();

    inline int elementVSizeType() const { return m_vSizeType; }
    void setElementVSizeType(int a);
    inline bool hasElementVSizeType() const { return m_children & VSizeType; }
    void clearElementVSizeType();

    inline int elementHorStretch() const { return m_horStretch; }
    void setElementHorStretch(int a);
    inline bool hasElementHorStretch() const { return m_children & HorStretch; }
    void clearElementHorStretch();

    inline int elementVerStretch() const { return m_verStretch; }
    void setElementVerStretch(int a);
    inline bool hasElementVerStretch() const { return m_children & VerStretch; }
    void clearElementVerStretch();

private:
    // attribute data
    QString m_attr_hSizeType;
    bool m_has_attr_hSizeType = false;

    QString m_attr_vSizeType;
    bool m_has_attr_vSizeType = false;

    // child element data
    uint m_children = 0;
    int m_hSizeType = 0;
    int m_vSizeType = 0;
    int m_horStretch = 0;
    int m_verStretch = 0;

    enum Child {
        HSizeType = 1,
        VSizeType = 2,
        HorStretch = 4,
        VerStretch = 8
    };
};

class QDESIGNER_UILIB_EXPORT DomSize {
    Q_DISABLE_COPY(DomSize)
public:
    DomSize() = default;
    ~DomSize();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline int elementWidth() const { return m_width; }
    void setElementWidth(int a);
    inline bool hasElementWidth() const { return m_children & Width; }
    void clearElementWidth();

    inline int elementHeight() const { return m_height; }
    void setElementHeight(int a);
    inline bool hasElementHeight() const { return m_children & Height; }
    void clearElementHeight();

private:

    // child element data
    uint m_children = 0;
    int m_width = 0;
    int m_height = 0;

    enum Child {
        Width = 1,
        Height = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomDate {
    Q_DISABLE_COPY(DomDate)
public:
    DomDate() = default;
    ~DomDate();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline int elementYear() const { return m_year; }
    void setElementYear(int a);
    inline bool hasElementYear() const { return m_children & Year; }
    void clearElementYear();

    inline int elementMonth() const { return m_month; }
    void setElementMonth(int a);
    inline bool hasElementMonth() const { return m_children & Month; }
    void clearElementMonth();

    inline int elementDay() const { return m_day; }
    void setElementDay(int a);
    inline bool hasElementDay() const { return m_children & Day; }
    void clearElementDay();

private:

    // child element data
    uint m_children = 0;
    int m_year = 0;
    int m_month = 0;
    int m_day = 0;

    enum Child {
        Year = 1,
        Month = 2,
        Day = 4
    };
};

class QDESIGNER_UILIB_EXPORT DomTime {
    Q_DISABLE_COPY(DomTime)
public:
    DomTime() = default;
    ~DomTime();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline int elementHour() const { return m_hour; }
    void setElementHour(int a);
    inline bool hasElementHour() const { return m_children & Hour; }
    void clearElementHour();

    inline int elementMinute() const { return m_minute; }
    void setElementMinute(int a);
    inline bool hasElementMinute() const { return m_children & Minute; }
    void clearElementMinute();

    inline int elementSecond() const { return m_second; }
    void setElementSecond(int a);
    inline bool hasElementSecond() const { return m_children & Second; }
    void clearElementSecond();

private:

    // child element data
    uint m_children = 0;
    int m_hour = 0;
    int m_minute = 0;
    int m_second = 0;

    enum Child {
        Hour = 1,
        Minute = 2,
        Second = 4
    };
};

class QDESIGNER_UILIB_EXPORT DomDateTime {
    Q_DISABLE_COPY(DomDateTime)
public:
    DomDateTime() = default;
    ~DomDateTime();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline int elementHour() const { return m_hour; }
    void setElementHour(int a);
    inline bool hasElementHour() const { return m_children & Hour; }
    void clearElementHour();

    inline int elementMinute() const { return m_minute; }
    void setElementMinute(int a);
    inline bool hasElementMinute() const { return m_children & Minute; }
    void clearElementMinute();

    inline int elementSecond() const { return m_second; }
    void setElementSecond(int a);
    inline bool hasElementSecond() const { return m_children & Second; }
    void clearElementSecond();

    inline int elementYear() const { return m_year; }
    void setElementYear(int a);
    inline bool hasElementYear() const { return m_children & Year; }
    void clearElementYear();

    inline int elementMonth() const { return m_month; }
    void setElementMonth(int a);
    inline bool hasElementMonth() const { return m_children & Month; }
    void clearElementMonth();

    inline int elementDay() const { return m_day; }
    void setElementDay(int a);
    inline bool hasElementDay() const { return m_children & Day; }
    void clearElementDay();

private:

    // child element data
    uint m_children = 0;
    int m_hour = 0;
    int m_minute = 0;
    int m_second = 0;
    int m_year = 0;
    int m_month = 0;
    int m_day = 0;

    enum Child {
        Hour = 1,
        Minute = 2,
        Second = 4,
        Year = 8,
        Month = 16,
        Day = 32
    };
};

class QDESIGNER_UILIB_EXPORT DomStringList {
    Q_DISABLE_COPY(DomStringList)
public:
    DomStringList() = default;
    ~DomStringList();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeNotr() const { return m_has_attr_notr; }
    inline QString attributeNotr() const { return m_attr_notr; }
    inline void setAttributeNotr(const QString &a) { m_attr_notr = a; m_has_attr_notr = true; }
    inline void clearAttributeNotr() { m_has_attr_notr = false; }

    inline bool hasAttributeComment() const { return m_has_attr_comment; }
    inline QString attributeComment() const { return m_attr_comment; }
    inline void setAttributeComment(const QString &a) { m_attr_comment = a; m_has_attr_comment = true; }
    inline void clearAttributeComment() { m_has_attr_comment = false; }

    inline bool hasAttributeExtraComment() const { return m_has_attr_extraComment; }
    inline QString attributeExtraComment() const { return m_attr_extraComment; }
    inline void setAttributeExtraComment(const QString &a) { m_attr_extraComment = a; m_has_attr_extraComment = true; }
    inline void clearAttributeExtraComment() { m_has_attr_extraComment = false; }

    // child element accessors
    inline QStringList elementString() const { return m_string; }
    void setElementString(const QStringList &a);

private:
    // attribute data
    QString m_attr_notr;
    bool m_has_attr_notr = false;

    QString m_attr_comment;
    bool m_has_attr_comment = false;

    QString m_attr_extraComment;
    bool m_has_attr_extraComment = false;

    // child element data
    uint m_children = 0;
    QStringList m_string;

    enum Child {
        String = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomResourcePixmap {
    Q_DISABLE_COPY(DomResourcePixmap)
public:
    DomResourcePixmap() = default;
    ~DomResourcePixmap();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    inline QString text() const { return m_text; }
    inline void setText(const QString &s) { m_text = s; }

    // attribute accessors
    inline bool hasAttributeResource() const { return m_has_attr_resource; }
    inline QString attributeResource() const { return m_attr_resource; }
    inline void setAttributeResource(const QString &a) { m_attr_resource = a; m_has_attr_resource = true; }
    inline void clearAttributeResource() { m_has_attr_resource = false; }

    inline bool hasAttributeAlias() const { return m_has_attr_alias; }
    inline QString attributeAlias() const { return m_attr_alias; }
    inline void setAttributeAlias(const QString &a) { m_attr_alias = a; m_has_attr_alias = true; }
    inline void clearAttributeAlias() { m_has_attr_alias = false; }

private:
    QString m_text;

    // attribute data
    QString m_attr_resource;
    bool m_has_attr_resource = false;

    QString m_attr_alias;
    bool m_has_attr_alias = false;
};

class QDESIGNER_UILIB_EXPORT DomResourceIcon {
    Q_DISABLE_COPY(DomResourceIcon)
public:
    DomResourceIcon() = default;
    ~DomResourceIcon();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    inline QString text() const { return m_text; }
    inline void setText(const QString &s) { m_text = s; }

    // attribute accessors
    inline bool hasAttributeTheme() const { return m_has_attr_theme; }
    inline QString attributeTheme() const { return m_attr_theme; }
    inline void setAttributeTheme(const QString &a) { m_attr_theme = a; m_has_attr_theme = true; }
    inline void clearAttributeTheme() { m_has_attr_theme = false; }

    inline bool hasAttributeResource() const { return m_has_attr_resource; }
    inline QString attributeResource() const { return m_attr_resource; }
    inline void setAttributeResource(const QString &a) { m_attr_resource = a; m_has_attr_resource = true; }
    inline void clearAttributeResource() { m_has_attr_resource = false; }

    // child element accessors
    inline DomResourcePixmap *elementNormalOff() const { return m_normalOff; }
    DomResourcePixmap *takeElementNormalOff();
    void setElementNormalOff(DomResourcePixmap *a);
    inline bool hasElementNormalOff() const { return m_children & NormalOff; }
    void clearElementNormalOff();

    inline DomResourcePixmap *elementNormalOn() const { return m_normalOn; }
    DomResourcePixmap *takeElementNormalOn();
    void setElementNormalOn(DomResourcePixmap *a);
    inline bool hasElementNormalOn() const { return m_children & NormalOn; }
    void clearElementNormalOn();

    inline DomResourcePixmap *elementDisabledOff() const { return m_disabledOff; }
    DomResourcePixmap *takeElementDisabledOff();
    void setElementDisabledOff(DomResourcePixmap *a);
    inline bool hasElementDisabledOff() const { return m_children & DisabledOff; }
    void clearElementDisabledOff();

    inline DomResourcePixmap *elementDisabledOn() const { return m_disabledOn; }
    DomResourcePixmap *takeElementDisabledOn();
    void setElementDisabledOn(DomResourcePixmap *a);
    inline bool hasElementDisabledOn() const { return m_children & DisabledOn; }
    void clearElementDisabledOn();

    inline DomResourcePixmap *elementActiveOff() const { return m_activeOff; }
    DomResourcePixmap *takeElementActiveOff();
    void setElementActiveOff(DomResourcePixmap *a);
    inline bool hasElementActiveOff() const { return m_children & ActiveOff; }
    void clearElementActiveOff();

    inline DomResourcePixmap *elementActiveOn() const { return m_activeOn; }
    DomResourcePixmap *takeElementActiveOn();
    void setElementActiveOn(DomResourcePixmap *a);
    inline bool hasElementActiveOn() const { return m_children & ActiveOn; }
    void clearElementActiveOn();

    inline DomResourcePixmap *elementSelectedOff() const { return m_selectedOff; }
    DomResourcePixmap *takeElementSelectedOff();
    void setElementSelectedOff(DomResourcePixmap *a);
    inline bool hasElementSelectedOff() const { return m_children & SelectedOff; }
    void clearElementSelectedOff();

    inline DomResourcePixmap *elementSelectedOn() const { return m_selectedOn; }
    DomResourcePixmap *takeElementSelectedOn();
    void setElementSelectedOn(DomResourcePixmap *a);
    inline bool hasElementSelectedOn() const { return m_children & SelectedOn; }
    void clearElementSelectedOn();

private:
    QString m_text;

    // attribute data
    QString m_attr_theme;
    bool m_has_attr_theme = false;

    QString m_attr_resource;
    bool m_has_attr_resource = false;

    // child element data
    uint m_children = 0;
    DomResourcePixmap *m_normalOff = nullptr;
    DomResourcePixmap *m_normalOn = nullptr;
    DomResourcePixmap *m_disabledOff = nullptr;
    DomResourcePixmap *m_disabledOn = nullptr;
    DomResourcePixmap *m_activeOff = nullptr;
    DomResourcePixmap *m_activeOn = nullptr;
    DomResourcePixmap *m_selectedOff = nullptr;
    DomResourcePixmap *m_selectedOn = nullptr;

    enum Child {
        NormalOff = 1,
        NormalOn = 2,
        DisabledOff = 4,
        DisabledOn = 8,
        ActiveOff = 16,
        ActiveOn = 32,
        SelectedOff = 64,
        SelectedOn = 128
    };
};

class QDESIGNER_UILIB_EXPORT DomString {
    Q_DISABLE_COPY(DomString)
public:
    DomString() = default;
    ~DomString();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    inline QString text() const { return m_text; }
    inline void setText(const QString &s) { m_text = s; }

    // attribute accessors
    inline bool hasAttributeNotr() const { return m_has_attr_notr; }
    inline QString attributeNotr() const { return m_attr_notr; }
    inline void setAttributeNotr(const QString &a) { m_attr_notr = a; m_has_attr_notr = true; }
    inline void clearAttributeNotr() { m_has_attr_notr = false; }

    inline bool hasAttributeComment() const { return m_has_attr_comment; }
    inline QString attributeComment() const { return m_attr_comment; }
    inline void setAttributeComment(const QString &a) { m_attr_comment = a; m_has_attr_comment = true; }
    inline void clearAttributeComment() { m_has_attr_comment = false; }

    inline bool hasAttributeExtraComment() const { return m_has_attr_extraComment; }
    inline QString attributeExtraComment() const { return m_attr_extraComment; }
    inline void setAttributeExtraComment(const QString &a) { m_attr_extraComment = a; m_has_attr_extraComment = true; }
    inline void clearAttributeExtraComment() { m_has_attr_extraComment = false; }

private:
    QString m_text;

    // attribute data
    QString m_attr_notr;
    bool m_has_attr_notr = false;

    QString m_attr_comment;
    bool m_has_attr_comment = false;

    QString m_attr_extraComment;
    bool m_has_attr_extraComment = false;
};

class QDESIGNER_UILIB_EXPORT DomPointF {
    Q_DISABLE_COPY(DomPointF)
public:
    DomPointF() = default;
    ~DomPointF();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline double elementX() const { return m_x; }
    void setElementX(double a);
    inline bool hasElementX() const { return m_children & X; }
    void clearElementX();

    inline double elementY() const { return m_y; }
    void setElementY(double a);
    inline bool hasElementY() const { return m_children & Y; }
    void clearElementY();

private:

    // child element data
    uint m_children = 0;
    double m_x = 0.0;
    double m_y = 0.0;

    enum Child {
        X = 1,
        Y = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomRectF {
    Q_DISABLE_COPY(DomRectF)
public:
    DomRectF() = default;
    ~DomRectF();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline double elementX() const { return m_x; }
    void setElementX(double a);
    inline bool hasElementX() const { return m_children & X; }
    void clearElementX();

    inline double elementY() const { return m_y; }
    void setElementY(double a);
    inline bool hasElementY() const { return m_children & Y; }
    void clearElementY();

    inline double elementWidth() const { return m_width; }
    void setElementWidth(double a);
    inline bool hasElementWidth() const { return m_children & Width; }
    void clearElementWidth();

    inline double elementHeight() const { return m_height; }
    void setElementHeight(double a);
    inline bool hasElementHeight() const { return m_children & Height; }
    void clearElementHeight();

private:

    // child element data
    uint m_children = 0;
    double m_x = 0.0;
    double m_y = 0.0;
    double m_width = 0.0;
    double m_height = 0.0;

    enum Child {
        X = 1,
        Y = 2,
        Width = 4,
        Height = 8
    };
};

class QDESIGNER_UILIB_EXPORT DomSizeF {
    Q_DISABLE_COPY(DomSizeF)
public:
    DomSizeF() = default;
    ~DomSizeF();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline double elementWidth() const { return m_width; }
    void setElementWidth(double a);
    inline bool hasElementWidth() const { return m_children & Width; }
    void clearElementWidth();

    inline double elementHeight() const { return m_height; }
    void setElementHeight(double a);
    inline bool hasElementHeight() const { return m_children & Height; }
    void clearElementHeight();

private:

    // child element data
    uint m_children = 0;
    double m_width = 0.0;
    double m_height = 0.0;

    enum Child {
        Width = 1,
        Height = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomChar {
    Q_DISABLE_COPY(DomChar)
public:
    DomChar() = default;
    ~DomChar();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline int elementUnicode() const { return m_unicode; }
    void setElementUnicode(int a);
    inline bool hasElementUnicode() const { return m_children & Unicode; }
    void clearElementUnicode();

private:

    // child element data
    uint m_children = 0;
    int m_unicode = 0;

    enum Child {
        Unicode = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomUrl {
    Q_DISABLE_COPY(DomUrl)
public:
    DomUrl() = default;
    ~DomUrl();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline DomString *elementString() const { return m_string; }
    DomString *takeElementString();
    void setElementString(DomString *a);
    inline bool hasElementString() const { return m_children & String; }
    void clearElementString();

private:

    // child element data
    uint m_children = 0;
    DomString *m_string = nullptr;

    enum Child {
        String = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomProperty {
    Q_DISABLE_COPY(DomProperty)
public:
    DomProperty() = default;
    ~DomProperty();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeName() const { return m_has_attr_name; }
    inline QString attributeName() const { return m_attr_name; }
    inline void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    inline void clearAttributeName() { m_has_attr_name = false; }

    inline bool hasAttributeStdset() const { return m_has_attr_stdset; }
    inline int attributeStdset() const { return m_attr_stdset; }
    inline void setAttributeStdset(int a) { m_attr_stdset = a; m_has_attr_stdset = true; }
    inline void clearAttributeStdset() { m_has_attr_stdset = false; }

    // child element accessors
    enum Kind { Unknown = 0, Bool, Color, Cstring, Cursor, CursorShape, Enum, Font, IconSet, Pixmap, Palette, Point, Rect, Set, Locale, SizePolicy, Size, String, StringList, Number, Float, Double, Date, Time, DateTime, PointF, RectF, SizeF, LongLong, Char, Url, UInt, ULongLong, Brush };
    inline Kind kind() const { return m_kind; }

    inline QString elementBool() const { return m_bool; }
    void setElementBool(const QString &a);

    inline DomColor *elementColor() const { return m_color; }
    DomColor *takeElementColor();
    void setElementColor(DomColor *a);

    inline QString elementCstring() const { return m_cstring; }
    void setElementCstring(const QString &a);

    inline int elementCursor() const { return m_cursor; }
    void setElementCursor(int a);

    inline QString elementCursorShape() const { return m_cursorShape; }
    void setElementCursorShape(const QString &a);

    inline QString elementEnum() const { return m_enum; }
    void setElementEnum(const QString &a);

    inline DomFont *elementFont() const { return m_font; }
    DomFont *takeElementFont();
    void setElementFont(DomFont *a);

    inline DomResourceIcon *elementIconSet() const { return m_iconSet; }
    DomResourceIcon *takeElementIconSet();
    void setElementIconSet(DomResourceIcon *a);

    inline DomResourcePixmap *elementPixmap() const { return m_pixmap; }
    DomResourcePixmap *takeElementPixmap();
    void setElementPixmap(DomResourcePixmap *a);

    inline DomPalette *elementPalette() const { return m_palette; }
    DomPalette *takeElementPalette();
    void setElementPalette(DomPalette *a);

    inline DomPoint *elementPoint() const { return m_point; }
    DomPoint *takeElementPoint();
    void setElementPoint(DomPoint *a);

    inline DomRect *elementRect() const { return m_rect; }
    DomRect *takeElementRect();
    void setElementRect(DomRect *a);

    inline QString elementSet() const { return m_set; }
    void setElementSet(const QString &a);

    inline DomLocale *elementLocale() const { return m_locale; }
    DomLocale *takeElementLocale();
    void setElementLocale(DomLocale *a);

    inline DomSizePolicy *elementSizePolicy() const { return m_sizePolicy; }
    DomSizePolicy *takeElementSizePolicy();
    void setElementSizePolicy(DomSizePolicy *a);

    inline DomSize *elementSize() const { return m_size; }
    DomSize *takeElementSize();
    void setElementSize(DomSize *a);

    inline DomString *elementString() const { return m_string; }
    DomString *takeElementString();
    void setElementString(DomString *a);

    inline DomStringList *elementStringList() const { return m_stringList; }
    DomStringList *takeElementStringList();
    void setElementStringList(DomStringList *a);

    inline int elementNumber() const { return m_number; }
    void setElementNumber(int a);

    inline float elementFloat() const { return m_float; }
    void setElementFloat(float a);

    inline double elementDouble() const { return m_double; }
    void setElementDouble(double a);

    inline DomDate *elementDate() const { return m_date; }
    DomDate *takeElementDate();
    void setElementDate(DomDate *a);

    inline DomTime *elementTime() const { return m_time; }
    DomTime *takeElementTime();
    void setElementTime(DomTime *a);

    inline DomDateTime *elementDateTime() const { return m_dateTime; }
    DomDateTime *takeElementDateTime();
    void setElementDateTime(DomDateTime *a);

    inline DomPointF *elementPointF() const { return m_pointF; }
    DomPointF *takeElementPointF();
    void setElementPointF(DomPointF *a);

    inline DomRectF *elementRectF() const { return m_rectF; }
    DomRectF *takeElementRectF();
    void setElementRectF(DomRectF *a);

    inline DomSizeF *elementSizeF() const { return m_sizeF; }
    DomSizeF *takeElementSizeF();
    void setElementSizeF(DomSizeF *a);

    inline qlonglong elementLongLong() const { return m_longLong; }
    void setElementLongLong(qlonglong a);

    inline DomChar *elementChar() const { return m_char; }
    DomChar *takeElementChar();
    void setElementChar(DomChar *a);

    inline DomUrl *elementUrl() const { return m_url; }
    DomUrl *takeElementUrl();
    void setElementUrl(DomUrl *a);

    inline uint elementUInt() const { return m_UInt; }
    void setElementUInt(uint a);

    inline qulonglong elementULongLong() const { return m_uLongLong; }
    void setElementULongLong(qulonglong a);

    inline DomBrush *elementBrush() const { return m_brush; }
    DomBrush *takeElementBrush();
    void setElementBrush(DomBrush *a);

private:
    void clear();

    // attribute data
    QString m_attr_name;
    bool m_has_attr_name = false;

    int m_attr_stdset = 0;
    bool m_has_attr_stdset = false;

    // child element data
    Kind m_kind = Unknown;
    QString m_bool;
    DomColor *m_color = nullptr;
    QString m_cstring;
    int m_cursor = 0;
    QString m_cursorShape;
    QString m_enum;
    DomFont *m_font = nullptr;
    DomResourceIcon *m_iconSet = nullptr;
    DomResourcePixmap *m_pixmap = nullptr;
    DomPalette *m_palette = nullptr;
    DomPoint *m_point = nullptr;
    DomRect *m_rect = nullptr;
    QString m_set;
    DomLocale *m_locale = nullptr;
    DomSizePolicy *m_sizePolicy = nullptr;
    DomSize *m_size = nullptr;
    DomString *m_string = nullptr;
    DomStringList *m_stringList = nullptr;
    int m_number = 0;
    float m_float = 0.0;
    double m_double = 0.0;
    DomDate *m_date = nullptr;
    DomTime *m_time = nullptr;
    DomDateTime *m_dateTime = nullptr;
    DomPointF *m_pointF = nullptr;
    DomRectF *m_rectF = nullptr;
    DomSizeF *m_sizeF = nullptr;
    qlonglong m_longLong = 0;
    DomChar *m_char = nullptr;
    DomUrl *m_url = nullptr;
    uint m_UInt = 0;
    qulonglong m_uLongLong = 0;
    DomBrush *m_brush = nullptr;
};

class QDESIGNER_UILIB_EXPORT DomConnections {
    Q_DISABLE_COPY(DomConnections)
public:
    DomConnections() = default;
    ~DomConnections();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline QVector<DomConnection *> elementConnection() const { return m_connection; }
    void setElementConnection(const QVector<DomConnection *> &a);

private:

    // child element data
    uint m_children = 0;
    QVector<DomConnection *> m_connection;

    enum Child {
        Connection = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomConnection {
    Q_DISABLE_COPY(DomConnection)
public:
    DomConnection() = default;
    ~DomConnection();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline QString elementSender() const { return m_sender; }
    void setElementSender(const QString &a);
    inline bool hasElementSender() const { return m_children & Sender; }
    void clearElementSender();

    inline QString elementSignal() const { return m_signal; }
    void setElementSignal(const QString &a);
    inline bool hasElementSignal() const { return m_children & Signal; }
    void clearElementSignal();

    inline QString elementReceiver() const { return m_receiver; }
    void setElementReceiver(const QString &a);
    inline bool hasElementReceiver() const { return m_children & Receiver; }
    void clearElementReceiver();

    inline QString elementSlot() const { return m_slot; }
    void setElementSlot(const QString &a);
    inline bool hasElementSlot() const { return m_children & Slot; }
    void clearElementSlot();

    inline DomConnectionHints *elementHints() const { return m_hints; }
    DomConnectionHints *takeElementHints();
    void setElementHints(DomConnectionHints *a);
    inline bool hasElementHints() const { return m_children & Hints; }
    void clearElementHints();

private:

    // child element data
    uint m_children = 0;
    QString m_sender;
    QString m_signal;
    QString m_receiver;
    QString m_slot;
    DomConnectionHints *m_hints = nullptr;

    enum Child {
        Sender = 1,
        Signal = 2,
        Receiver = 4,
        Slot = 8,
        Hints = 16
    };
};

class QDESIGNER_UILIB_EXPORT DomConnectionHints {
    Q_DISABLE_COPY(DomConnectionHints)
public:
    DomConnectionHints() = default;
    ~DomConnectionHints();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline QVector<DomConnectionHint *> elementHint() const { return m_hint; }
    void setElementHint(const QVector<DomConnectionHint *> &a);

private:

    // child element data
    uint m_children = 0;
    QVector<DomConnectionHint *> m_hint;

    enum Child {
        Hint = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomConnectionHint {
    Q_DISABLE_COPY(DomConnectionHint)
public:
    DomConnectionHint() = default;
    ~DomConnectionHint();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeType() const { return m_has_attr_type; }
    inline QString attributeType() const { return m_attr_type; }
    inline void setAttributeType(const QString &a) { m_attr_type = a; m_has_attr_type = true; }
    inline void clearAttributeType() { m_has_attr_type = false; }

    // child element accessors
    inline int elementX() const { return m_x; }
    void setElementX(int a);
    inline bool hasElementX() const { return m_children & X; }
    void clearElementX();

    inline int elementY() const { return m_y; }
    void setElementY(int a);
    inline bool hasElementY() const { return m_children & Y; }
    void clearElementY();

private:
    // attribute data
    QString m_attr_type;
    bool m_has_attr_type = false;

    // child element data
    uint m_children = 0;
    int m_x = 0;
    int m_y = 0;

    enum Child {
        X = 1,
        Y = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomDesignerData {
    Q_DISABLE_COPY(DomDesignerData)
public:
    DomDesignerData() = default;
    ~DomDesignerData();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline QList<DomProperty*> elementProperty() const { return m_property; }
    void setElementProperty(const QList<DomProperty *> &a);

private:

    // child element data
    uint m_children = 0;
    QList<DomProperty*> m_property;

    enum Child {
        Property = 1
    };
};

class QDESIGNER_UILIB_EXPORT DomSlots {
    Q_DISABLE_COPY(DomSlots)
public:
    DomSlots() = default;
    ~DomSlots();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline QStringList elementSignal() const { return m_signal; }
    void setElementSignal(const QStringList &a);

    inline QStringList elementSlot() const { return m_slot; }
    void setElementSlot(const QStringList &a);

private:

    // child element data
    uint m_children = 0;
    QStringList m_signal;
    QStringList m_slot;

    enum Child {
        Signal = 1,
        Slot = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomPropertySpecifications {
    Q_DISABLE_COPY(DomPropertySpecifications)
public:
    DomPropertySpecifications() = default;
    ~DomPropertySpecifications();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // child element accessors
    inline QVector<DomPropertyToolTip *> elementTooltip() const { return m_tooltip; }
    void setElementTooltip(const QVector<DomPropertyToolTip *> &a);

    inline QVector<DomStringPropertySpecification *> elementStringpropertyspecification() const { return m_stringpropertyspecification; }
    void setElementStringpropertyspecification(const QVector<DomStringPropertySpecification *> &a);

private:

    // child element data
    uint m_children = 0;
    QVector<DomPropertyToolTip *> m_tooltip;
    QVector<DomStringPropertySpecification *> m_stringpropertyspecification;

    enum Child {
        Tooltip = 1,
        Stringpropertyspecification = 2
    };
};

class QDESIGNER_UILIB_EXPORT DomPropertyToolTip {
    Q_DISABLE_COPY(DomPropertyToolTip)
public:
    DomPropertyToolTip() = default;
    ~DomPropertyToolTip();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeName() const { return m_has_attr_name; }
    inline QString attributeName() const { return m_attr_name; }
    inline void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    inline void clearAttributeName() { m_has_attr_name = false; }

private:
    // attribute data
    QString m_attr_name;
    bool m_has_attr_name = false;
};

class QDESIGNER_UILIB_EXPORT DomStringPropertySpecification {
    Q_DISABLE_COPY(DomStringPropertySpecification)
public:
    DomStringPropertySpecification() = default;
    ~DomStringPropertySpecification();

    void read(QXmlStreamReader &reader);
    void write(QXmlStreamWriter &writer, const QString &tagName = QString()) const;

    // attribute accessors
    inline bool hasAttributeName() const { return m_has_attr_name; }
    inline QString attributeName() const { return m_attr_name; }
    inline void setAttributeName(const QString &a) { m_attr_name = a; m_has_attr_name = true; }
    inline void clearAttributeName() { m_has_attr_name = false; }

    inline bool hasAttributeType() const { return m_has_attr_type; }
    inline QString attributeType() const { return m_attr_type; }
    inline void setAttributeType(const QString &a) { m_attr_type = a; m_has_attr_type = true; }
    inline void clearAttributeType() { m_has_attr_type = false; }

    inline bool hasAttributeNotr() const { return m_has_attr_notr; }
    inline QString attributeNotr() const { return m_attr_notr; }
    inline void setAttributeNotr(const QString &a) { m_attr_notr = a; m_has_attr_notr = true; }
    inline void clearAttributeNotr() { m_has_attr_notr = false; }

private:
    // attribute data
    QString m_attr_name;
    bool m_has_attr_name = false;

    QString m_attr_type;
    bool m_has_attr_type = false;

    QString m_attr_notr;
    bool m_has_attr_notr = false;
};


#ifdef QFORMINTERNAL_NAMESPACE
}
#endif

QT_END_NAMESPACE

#endif // UI4_H
