import QtQuick
import QtQuick.Controls

Item {
    id: welcomeOverlay

    enabled: overlayMouseArea.enabled
    anchors.fill: parent

    Rectangle {
        id: overlayRectangle

        width: parent.width / 2
        height: parent.height / 3
        opacity: 1
        color: "#dd000000"
        radius: 16
        anchors.centerIn: parent

        Text {
            id: overlayText

            color: "#ffffff"
            text: "To control the camera,\ndrag and zoom the object."
            anchors.fill: parent
            font.pixelSize: Math.min(50, Math.max(12, parent.width / 30))
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            font.styleName: "Regular"
            font.family: "Titillium Web"
        }
    }

    MouseArea {
        id: overlayMouseArea

        anchors.fill: parent
        Connections {
            target: overlayMouseArea
            onClicked: overlayMouseArea.enabled = false
        }

        Connections {
            target: overlayMouseArea
            onPressed: overlayMouseArea.enabled = false
        }

        Connections {
            target: overlayMouseArea
            onWheel: overlayMouseArea.enabled = false
        }

    }
    states: [
        State {
            name: "invisible"
            when: !overlayMouseArea.enabled

            PropertyChanges {
                target: welcomeOverlay
                opacity: 0
                visible: false
            }
        }
    ]

    transitions: [
        Transition {
            id: transition

            PropertyAnimation {
                target: welcomeOverlay
                property: "opacity"
                duration: 500
            }

            PropertyAnimation {
                target: welcomeOverlay
                property: "visible"
                duration: 500
            }
        }
    ]
}

/*##^##
Designer {
    D{i:0}D{i:9;transitionDuration:2000}
}
##^##*/
