import QtQuick
import QtQuick.Controls

Button {
    id: selectionButton

    width: 250
    height: 100
    text: qsTr("ButtonText")
    font.styleName: "Regular"
    font.family: "Titillium Web"
    font.pixelSize: Math.min(selectionButton.width / 8, selectionButton.height / 4)
    checkable: true
    contentItem: Text {
        id: buttonText

        color: "#00414a"
        text: selectionButton.text
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        font: selectionButton.font
    }

    background: Rectangle {
        id: rectangle

        color: "#99ffffff"
        radius: 10
        border.color: "#99ffffff"
        border.width: 2
    }

    states: [
        State {
            name: "default"
            when: welcomeOverlay.enabled

            PropertyChanges {
                target: rectangle
                color: "#e06f6f6f"
                border.color: "#ec555555"
            }

            PropertyChanges {
                target: buttonText
                color: "#b7b7b7"
            }
        },

        State {
            name: "pressed"
            when: selectionButton.pressed

            PropertyChanges {
                target: rectangle
                color: "#177948"
                border.color: "#00414a"
            }
        },

        State {
            name: "checkedHovered"
            when: selectionButton.checked && selectionButton.hovered
            PropertyChanges {
                target: buttonText
                color: "#177948"
            }

            PropertyChanges {
                target: rectangle
                color: "#2cde85"
                border.color: "#86e7b7"
            }

            PropertyChanges {
                target: selectionButton
                flat: true
            }
        },

        State {
            name: "checked"
            when: selectionButton.checked

            PropertyChanges {
                target: rectangle
                color: "#2cde85"
                border.color: "#23784d"
            }
        },

        State {
            name: "hovered"
            when: selectionButton.hovered

            PropertyChanges {
                target: buttonText
                color: "#86e7b7"
            }

            PropertyChanges {
                target: rectangle
                color: "#23784d"
                border.color: "#2cde85"
            }

            PropertyChanges {
                target: selectionButton
                flat: true
            }
        }
    ]

    transitions: [
        Transition {
            id: transition

            PropertyAnimation {
                target: rectangle
                property: "border.color"
                duration: 150
            }

            PropertyAnimation {
                target: rectangle
                property: "color"
                duration: 150
            }

            PropertyAnimation {
                target: buttonText
                property: "color"
                duration: 150
            }
        }
    ]
}

/*##^##
Designer {
    D{i:0}D{i:18;transitionDuration:2000}
}
##^##*/
