
// Created with Qt Design Studio (version 4.7.0), Thu Nov 14 16:08:30 2024
// Do not manually edit this file, it will be overwritten if effect is modified in Qt Design Studio.

import QtQuick

Item {
    id: rootItem

    // Use visible property to show and hide the effect.
    visible: true

    // This is an internal property used by tooling to identify effect items. Do not modify.
    property bool _isEffectItem

    // This is an internal property used to manage the effect. Do not modify.
    property Item _oldParent: null

    // This is the main source for the effect. Set internally to the current parent item. Do not modify.
    property Item source: null

    // This property specifies how much of extra space is reserved for the effect outside the parent geometry.
    // It should be sufficient for most use cases but if the application uses extreme values it may be necessary to
    // increase this value.
    property int extraMargin: 80

    onExtraMarginChanged: setupSourceRect()

    function setupSourceRect() {
        if (source) {
            var w = source.width + extraMargin * 2
            var h = source.height + extraMargin * 2
            source.layer.sourceRect = Qt.rect(-extraMargin, -extraMargin, w, h)
        }
    }

    function connectSource(enable) {
        if (source) {
            if (enable) {
                source.widthChanged.connect(setupSourceRect)
                source.heightChanged.connect(setupSourceRect)
            } else {
                source.widthChanged.disconnect(setupSourceRect)
                source.heightChanged.disconnect(setupSourceRect)
            }
        }
    }

    function setupParentLayer()
    {
        if (_oldParent && _oldParent !== parent) {
            _oldParent.layer.enabled = false
            _oldParent.layer.effect = null
            
            connectSource(false)
            source = null
            _oldParent.update()
            _oldParent = null
        }
        if (parent) {
            _oldParent = parent
            if (visible) {
                parent.layer.enabled = true
                parent.layer.effect = effectComponent
                
                connectSource(false)
            source = parent
            connectSource(true)
            setupSourceRect()
            } else {
                parent.layer.enabled = false
                parent.layer.effect = null
                
                connectSource(false)
            source = null
            }
            parent.update()
        }

        setupLayer_displaceDisplacementSource()
    }

    onParentChanged: setupParentLayer()

    onVisibleChanged: setupParentLayer()

    // This property defines the item that is going to be used as the displacement map. The source item gets rendered into the intermediate pixel buffer. The red and green component values from the result determine the displacement of the pixels from the source item.
    //
    // The format for the displacement map is similar to the tangent space normal maps, which can be created with most 3D-modeling tools. Many image processing tools include the support for generating normal maps. Alternatively, the displacement map for this effect can also be a QML element which is colored appropriately. Like any QML element, it can be animated. It is recommended that the size of the diplacement map matches the size of the source image.
    //
    // The displace data is interpreted in the RGBA format. For every pixel: the red channel stores the x-axis displacement, and the green channel stores the y-axis displacement. Blue and alpha channels are ignored for this effect.
    //
    // Assuming that red channel value 1.0 is fully red (0.0 having no red at all), this effect considers pixel component value 0.5 to cause no displacement at all. Values above 0.5 shift pixels to the left, values below 0.5 do the shift to the right. In a similar way, green channel values above 0.5 displace the pixels upwards, and values below 0.5 shift the pixels downwards. The actual amount of displacement in pixels depends on the displacement property.
    property var displaceDisplacementSource: imageItemdisplaceDisplacementSource
    // This property defines the scale for the displacement. The bigger scale, the bigger the displacement of the pixels. The value set to 0.0 causes no displacement.
    //
    // The value ranges from -1.0 (inverted maximum shift, according to displacementSource) to 1.0 (maximum shift, according to displacementSource). By default, the property is set to 0.0 (no displacement).
    property real displaceDisplacement: -0.26


    property var oldDisplaceDisplacementSource: null
    function setupLayer_displaceDisplacementSource()
    {
        if (oldDisplaceDisplacementSource) {
            oldDisplaceDisplacementSource.layer.enabled = false
            oldDisplaceDisplacementSource = null
        }
        if (displaceDisplacementSource != imageItemdisplaceDisplacementSource) {
            displaceDisplacementSource.layer.enabled = true
            oldDisplaceDisplacementSource = displaceDisplacementSource
        }
    }
    onDisplaceDisplacementSourceChanged: setupLayer_displaceDisplacementSource()
    property url displaceDisplacementSourceUrl: "fog2.png"
    Image {
        id: imageItemdisplaceDisplacementSource
        anchors.fill: parent
        source: rootItem.displaceDisplacementSourceUrl
        visible: false
    }
    Component {
        id: effectComponent
        ShaderEffect {
            property Item source: null
            readonly property Item iSource: rootItem.source
            readonly property var displaceDisplacementSource: rootItem.displaceDisplacementSource
            readonly property real displaceDisplacement: rootItem.displaceDisplacement

            vertexShader: 'displaceeffect.vert.qsb'
            fragmentShader: 'displaceeffect.frag.qsb'
            anchors.fill: rootItem.source
            anchors.margins: -rootItem.extraMargin
        }
    }
}
