// Copyright (C) 2016 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

#include "qlayoutwidget_propertysheet.h"
#include "qlayout_widget_p.h"
#include "formwindow.h"
#include "formeditor.h"

#include <QtDesigner/qextensionmanager.h>

#include <QtWidgets/qlayout.h>

QT_BEGIN_NAMESPACE

using namespace qdesigner_internal;

QLayoutWidgetPropertySheet::QLayoutWidgetPropertySheet(QLayoutWidget *object, QObject *parent)
    : QDesignerPropertySheet(object, parent)
{
    clearFakeProperties();
}

QLayoutWidgetPropertySheet::~QLayoutWidgetPropertySheet() = default;

bool QLayoutWidgetPropertySheet::isVisible(int index) const
{
    static const QString layoutPropertyGroup = QStringLiteral("Layout");
    if (propertyGroup(index) == layoutPropertyGroup)
        return QDesignerPropertySheet::isVisible(index);
    return false;
}

void QLayoutWidgetPropertySheet::setProperty(int index, const QVariant &value)
{
    QDesignerPropertySheet::setProperty(index, value);
}

bool QLayoutWidgetPropertySheet::dynamicPropertiesAllowed() const
{
    return false;
}

QT_END_NAMESPACE
