# Copyright (c) 1998                            RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

#------------------------------------------------------------------------------
# Module Header
# Filename          :   RobotConfig.pm
# Purpose           :   Provide a single location for variables influencing the
#                       robot's behaviour
# Author            :   Lee Wilmot
# Date              :   971112
# Language Version  :   Perl 5, version 5.003_07
# OSs Tested        :   BSD
# Command Line      :   Nothing executable from the command line
# Input Files       :   NONE
# Output Files      :   NONE
# External Programs :   NONE
#-------------------------------------------------------------------------------
#

#------------------------------------------------------------------------------
# Module Change History
# Author            : MGTM
# Date              : 19990310
# Changes           : Added some variables for things specific to html output
# Comments          :

############### PACKAGE INTERFACE ###################

package RobotConfig;

use Exporter ();
@ISA = qw(Exporter);

# MGTM added, web report misses out some problems: %DONT_REPORT_THESE_FOR_WEB
# $WEBTEXT_FILE, $REPORT_TYPE_FLAG for web report texts

@EXPORT_OK = qw( 
        %F 

        @F_MUST_BE_INTEGER @F_MULTIPLE_ALLOWED %F_MISSPELLING @F_MUST_BE_SINGLE_VALUE
        @F_MAY_USE_SLASH_NOTATION

        $FORM_FS $PROB_FS $PLAN_FS @F_INTERNAL $VISIBLE_FS $MAX_FIELD_KEY_LENGTH

        $TEMPLATE_NAME_EXTENSION %TEMPLATE_NAMES %TEMPLATE_DATA %TEMPLATE_MISSPELLINGS
        %TEMPLATE_KEYFIELDS

        $ROBOT_NAME $ROBOT_TITLE $ROBOT_ADDRESS_STANDALONE $ROBOT_ADDRESS_REAL
        $VERSION_NUMBER
        $INADDR_ROBOT_ADDRESS $DB_ROBOT_ADDRESS $DIST_ROBOT_ADDRESS
        $WAIT_QUEUE_NAME $FATAL_ERROR_EXIT_TXT $NORMAL_COMPLETION_TXT
        $NOT_A_REQUEST_ERROR_TXT
        $EMAIL_REPORT_NO_OF_COLUMNS $EMAILHEADER_CONTACT_FIELDS_TXT
        $SECTION_ONE_HEADER     $SECTION_TWO_HEADER     $SECTION_THREE_HEADER   
        $SECTION_ONE_HEADER_HTML     $SECTION_TWO_HEADER_HTML     $SECTION_THREE_HEADER_HTML

        $IMMEDIATE_OVERALL_EFFICIENCY_THRESHOLD 
        $YEAR1_OVERALL_EFFICIENCY_THRESHOLD $OVERALL_EFFICIENCY_TOLERANCE 
        $SUBNET_EFFICIENCY_THRESHOLD  $HOLE_WARN_THRESHOLD 
        $PLANLINES_IGNORE_THRESHOLD

        $WARNING_REJECT_THRESHOLD $MAX_NO_ERRORS_IN_TEMPLATE_THRESHOLD 
        $MAX_NO_WARNS_IN_TEMPLATE_THRESHOLD $LOCK_EX $LOCK_UN 
        %REPORT_TYPE %PROBLEM_TYPE
        %TEXT_VARIABLES $TMP_FILE_MAX_AGE $UNIQUE_AFFIX @SPECIAL_COUNTRIES

        $SENDMAIL_COM @SENDMAIL_FLAGS
        $DEBUG_REGID

        $ROBOT_HOME_DIR $ROBOT_INSTALL_DIR 

        $PUBLIC_INSTALL_DIR $PUBLIC_DISTRIBUTION_DIR @PUBLIC_DISTRIBUTION_FILES
        $PUBLIC_CUT_REG $PUBLIC_CUT_END_REG

        @INSTALL_CREATE_DIRS @INSTALL_CLEAN_DIRS @INSTALL_COPY_DIRS
	@INSTALL_EXECUTABLES
        $TMP_DIR $FROMCUST_LOG_DIR $TOCUST_LOG_DIR
        $PROBLEMTEXT_FILE $EMAILTEXT_FILE 

        $WEBTEXT_FILE

        $FROMCUST_MAIL_FILE
        $TOCUST_MAIL_FILE $CCODE_FILE $DIAGNOSTIC_FILE $FATAL_FILE

        $REG_COM $DATE_COM $HOSTNAME_COM
        $TEXT_AUTO_HM_COM

	%DONT_REPORT_THESE_FOR_WEB

);

%EXPORT_TAGS = ( 
        DEBUG_FLAGS =>  [qw(
                $MODE_FLAG $VERBOSE_FLAG $DETAIL_EXTRACT_FLAG
                $NO_TICKETS_PERIOD_FLAG $TICKETIZE_FLAG $LOGGING_FLAG 
                $EMAIL_FLAG $CLR_TMPFILES_FLAG
                $CHECK_DUPLICATES_FLAG $CHECK_ARINDB_FLAG $CHECK_ARIN_DB_FLAG
                $SHOW_INTERNAL_FIELDS_FLAG $REGID_FLAG
		$REPORT_TYPE_FLAG
        )],
        RTT_VARS =>     [qw(
                $RTT_COM %RTT_FLAGS %RTT_OPTS $TICKNO_REG
                $RTT_TICKET_NUMBER_PREFIX
                $RTT_ERROR_OUTPUT_REG $RTT_NEW_TICKET_CREATED_REG
                $RTT_MALFORMEDTICKNO_REG $RTT_HISTORY_REG
                $RTT_REGID_REG
		$RTT_TICKEXISTS_REG
                $RTT_MAX_NO_MESSAGES_ON_TICKET_THRESHOLD
                $RTT_LOG_MSG_HISTORY_TOO_LONG 
                $RTT_NEW_TICKET_STATUS $RTT_NEW_TICKET_CATEGORY
                $RTT_NEW_TICKET_ORIGIN_WEB
                $RTT_NEW_TICKET_ORIGIN_EMAIL
                $RTT_CATEGORY_PI_STRING $RTT_CATEGORY_PA_STRING
                $RTT_DEBUG_TICKET
        )],
        WHOIS_VARS =>   [qw(
                $WHOIS_COM $WHOIS_RETRY_PERIOD $WHOIS_RETRY_TIMES 
                $WHOIS_NOTFOUND_REG $WHOIS_RECURSEOFF_OPT 
                $WHOIS_OBJECTSELECT_OPT $ARINDB_USE_OPT 
                $ARINDB_SEARCH_OPT $ARINDB_NOTFOUND_REG $ARINDB_FOUND_REG 
                $ARINDB_RETRY_PERIOD $ARINDB_RETRY_TIMES $ARINDB_CONTACT_HANDLE_SUFFIX
        )],
        REGULAR_EXPRESSIONS => [qw(
                $TEMPLATE_START_REG $TEMPLATE_END_REG $LAST_TEMPLATE_REG 
                $DOMAINNAME_REG $AUTONIC_REG  $NEARLY_AUTONIC_REG  $NIC_REG
                $NETNAME_REG $FIELD_REG $REGID_REG $BAREREGID_REG
                $SERVICEFIELD_REG $SERVICEOK_REG $STATUS_REG $RESERVE_REG
                $MISSING_MASK_REG $MISSING_VALUE_REG $PRVCONSID_REG
                $PIREQNEG_REG $PIREQPOS_REG
                $TEXTEND_REG $TEXTS_IGNORE_LINE_REG
                $LONGACK_REG $QUOTED_LINE_START_REG $NOT_USE_AS_DESCR_REG
                $DOSCONVERSION_REG                   
        )]
);

Exporter::export_ok_tags('DEBUG_FLAGS', 'RTT_VARS', 'WHOIS_VARS', 'REGULAR_EXPRESSIONS');

################## DEBUG FLAGS / VARIABLES  ######################

$MODE_FLAG = 0;                # THE BIG SWITCH
                                # 0 =   debug mode: the flags below will be used as
                                #       as the flag values.
                                # 1 =   the default command line test mode values will
                                #       be used.
                                # 2 =   the default stand-alone values will be used
                                # 3 =   the default real values will be used
                                #       
                                #       See Misc.pm::parse_arguments for default settings
                                #       The value given here will be overridden by
                                #       a mode given as an argument to the program.

$VERBOSE_FLAG = 1;              # 0 =   no talking please.
                                # 1 =   [DEFAULT] talk to me on STDOUT & STDERR, I'm curious.

$DETAIL_EXTRACT_FLAG = 1;       # 0 =   [DEFAULT] don't
                                # 1 =   Show the extraction process with more detail, if
                                #       $VERBOSE_FLAG == 1 

$REPORT_TYPE_FLAG = 1;          # MGTM is this an email or an html report ?
				# See %ReportAux::REPORT_TYPE for value explanation

$EMAIL_FLAG = 1;                # 0 =   no 'email' output in any way to anyone, punt.
                                # 1 =   send 'email' output to STDOUT.
                                # 2     [DEFAULT] = emails sent

$LOGGING_FLAG = 0;              # 0 =   no log files maintained
                                # 1 =   [DEFAULT] logfiles of all emails sent and 
                                #       received are maintained

$TICKETIZE_FLAG = 0;            # 0 =   *Nothing* is added to *any* ticket,
                                #       no changes are made. If a new
                                #       ticket must be made, $RTT_DEBUG_TICKET is returned
                                #       as the new ticket number. No ticket details
                                #       are changed.
                                # 1 =   $RTT_DEBUG_TICKET is used for all ticket operations.
                                # 2 =   [DEFAULT] normal ticket operations.

$NO_TICKETS_PERIOD_FLAG = 1;    # 0 =   [DEFAULT] do.
                                # 1 =   Don't do ANY ticket operations. 

$REGID_FLAG = 1;                # 0 =   Don't check for/use regid in customer message.
                                #       Use $DEBUG_REGID instead. This will affect:
                                #       a) the check for duplicate tickets
                                #       b) the regid when a new ticket is made
                                # 1 =   [DEFAULT] Use regid from ticket.

$CLR_TMPFILES_FLAG = 1;         # 0 =   don't remove files in $TMP_DIR after processing
                                # 1 =   [DEFAULT] remove them. Note: these will in any 
                                #       case not be removed if an error has arisen.

$CHECK_DUPLICATES_FLAG  = 0;    # 0 =   don't
                                # 1 =   [DEFAULT] check a registry's tickets for
                                #        possible duplicates

$CHECK_ARIN_DB_FLAG = 1;        # 0 =   don't
                                # 1 =   [DEFAULT] check in ARINDB for persons if we
                                #       can't find in RIPE DB

$SHOW_INTERNAL_FIELDS_FLAG = 0; # 0 =   [DEFAULT] don't
                                # 1 =   Show the fields in @F_INTERNAL in the second
                                #       section of the report

$RTT_DEBUG_TICKET =     'NCC#1998056978';       # ticket used if $TICKETIZE_FLAG = 2;

$DEBUG_REGID =          'eu.zz';                # used if $REGID_FLAG = 0

############################# VARIABLES RELATING TO FIELDS ###########################

%F = (
        PERSON =>               'person',               # person
        ROLE =>                 'role',                 #
        ADDRESS =>              'address',              #
        NOTIFY =>               'notify',               #

        INETNUM =>              'inetnum',              # network
        NETNAME =>              'netname',              #
        TECHC =>                'tech-c',               #
        ADMINC =>               'admin-c',              #
        STATUS =>               'status',               #
        DESCR =>                'descr',                #

        NICHDL =>               'nic-hdl',              # person & network
        SOURCE =>               'source',               #
        MNTBY =>                'mnt-by',               #
        CHANGED =>              'changed',              #

        FAXNO =>                'fax-no',               # requester & user
        NAME =>                 'name',
        ORG =>                  'organisation',

        EMAIL =>                'e-mail',               # requester & user & person
        PHONE =>                'phone',                #

        COUNTRY =>              'country',              # requester & user & network
        RSIZE =>                'request-size',         # request overview
        OVRIMM =>               'addresses-immediate',  #
        OVRYR1 =>               'addresses-year-1',     #       
        OVRYR2 =>               'addresses-year-2',     #       
        OVRSUBIMM =>            'subnets-immediate',    #
        OVRSUBYR1 =>            'subnets-year-1',       #
        OVRSUBYR2 =>            'subnets-year-2',       #
        INETCONNECT =>          'inet-connect',         #
        CNTRYNET =>             'country-net',          #
        PRVCONSID =>            'private-considered',   #
        PIREQ =>                'PI-requested',         #

        TEXT =>                 'text',                 # overview of organisation template
        SUBNETSIZE =>           'subnetsize',           # addressing plan
        APTOTALS =>             'totals',               #

        EMAILTO =>              'To',                   # email header fields
        EMAILFROM =>            'From',                 #
        EMAILCC =>              'Cc',                   #
        EMAILREPLTO =>          'Reply-To',             #
        EMAILSUBJECT =>         'Subject',              #
        EMAILDATE =>            'Date',                 #
        EMAILMESSAGEID =>       'Message-ID',           #
        REGID =>                'X-NCC-RegID',          #
        TICKET =>               'X-NCC-Ticket',         #

        # THE FOLLOWING FIELDS DO NOT APPEAR ON THE FORM AT ALL
        # They are for internal tracking. Values should be chosen
        # which will not clash with future field names on the
        # request form.

        REGFILESERVICELEVEL =>  'Service Level',        # in a reg file

	EMAILBODY =>		'body',                 # meta template
                                                        # all of email other
                                                        # than email header

        TNAME =>                'templatename',         # all templates
                                                        # holds template name

        PROBLEMS =>             'problem',              # all templates
                                                        # holds problem codes with args

                                                        # all templates
        WARNCOUNT =>            'warncount',            # hold problem counts
        ERRORCOUNT =>           'errorcount',           #
        INFORMCOUNT =>          'informcount',          #

        FIELD_ORDER =>          'field order',          # 'field' type templates
                                                        # dictates order of output for 
                                                        # fields on report

        REMAINDER =>            'remainder',            # 'field' and 'plan' type templates
                                                        # anything unexpected goes in here

        ADRRSIZE =>             'addresses needed',
        ADRIMM =>               'immediate addresses',  # used as fields in '%Check::found'
        ADRYR1 =>               'year 1 addresses',     # for recording what data found
        ADRYR2 =>               'year 2 addresses',     #
        ADRSUBIMM =>            'immediate subnets',    #
        ADRSUBYR1 =>            'year 1 subnets',       #
        ADRSUBYR2 =>            'year 2 subnets',       #
);

# Fields which must have an INTEGER VALUE
# See &Check::check_request_overview
#
@F_MUST_BE_INTEGER = ( 
        RSIZE, OVRSUBIMM, OVRSUBYR1, OVRSUBYR2, OVRIMM, OVRYR1, OVRYR2
);

# Fields which must have a SINGLE VALUE.
# This also implies they must HAVE a value
#
@F_MUST_BE_SINGLE_VALUE = (
        RSIZE, OVRSUBIMM, OVRSUBYR1, OVRSUBYR2, OVRIMM, OVRYR1, OVRYR2  
);

@F_MAY_USE_SLASH_NOTATION = (
        RSIZE, OVRIMM, OVRYR1, OVRYR2
);

# Fields for which MULTIPLE ENTRIES ALLOWED in a particular template
# REMAINDER and PROBLEMS do not appear on the form. They must still
# be included here because they hold multiple lines and would produce
# an error/warning otherwise.
# Neither PIREQ nor NETNAME may be multiple: this could potentially
# cause a serious problem in EmailReport.pm.
# See &Check::multiple_check

@F_MULTIPLE_ALLOWED = ( 
        ADMINC, TECHC, CNTRYNET, EMAIL, PHONE, DESCR,
        NOTIFY, MNTBY, CHANGED, ADDRESS, INETCONNECT,
        REMAINDER, PROBLEMS
);

# A hash of possible MISSPELLINGS to check for in field names
# Key: the misspelt fieldname
# Value: what the spelling really should be
# See &Check::misspelling_check

%F_MISSPELLING = ( 
        "organization" =>       $F{ORG},
        "email" =>              $F{EMAIL},
        "faxno" =>              $F{FAXNO},
        "PIrequested" =>        $F{PIREQ},
        "netnum" =>             $F{INETNUM},
        "adminc" =>             $F{ADMINC},
        "techc" =>              $F{TECHC},
        "mntby" =>              $F{MNTBY},
        "nichdl" =>             $F{NICHDL},
        "subnets-years-1" =>    $F{OVRSUBYR1},
        "subnets-years-2" =>    $F{OVRSUBYR2},
        "subnet-years-1" =>     $F{OVRSUBYR1},
        "subnet-years-2" =>     $F{OVRSUBYR2},
        "subnet-year-1" =>      $F{OVRSUBYR1},
        "subnet-year-2" =>      $F{OVRSUBYR2},
        "address-immediate" =>  $F{OVRIMM},
        "address-year-1" =>     $F{OVRYR1},
        "address-year-2" =>     $F{OVRYR2},
        "addresses-years-1" =>     $F{OVRYR1},
        "addresses-years-2" =>     $F{OVRYR2}
);

# Field separators

# For separating values within one field of a hash. i.e. enabling
# multiple values to be stored in one field of a hash. These three
# variables MAY NOT interfere with each other: none of their
# values should be capable of matching with one of the values
# of the other separators if a regular expression match were
# applied.

# Each field on the form is stored has a Field : Value pair in a hash. 
# If fields have more than one line, the values are still only stored in 
# one hash entry, but separated by a special 'field separator' string: 
# $FORM_FS. T
# The danger is, of course, if this separator string is found in the
# original data. Therefore, we pick something very unlikely to occur 
# 'naturally'. 
# CHOICE: Other than rarity, it doesn't really matter what we pick.
# Probably best not to use Perl meta-characters, just in case :)

$FORM_FS = '-_==_-___-';

# Problem descriptions attached to templates by Check.pm consist of 
# PROB_CODE $PROB_FS ARG1 $PROB_FS ARG2 $PROB_FS ARG3 ....
# (spaces only introduced for clarity)

$PROB_FS = '-==__-=-==';

# Values extracted from subnet and 'total' lines in a plan are separated by
# $PLAN_FS.

$PLAN_FS = '--=d=w=x=_';                                        

# Fields which are used for internal tracking.
# Defining a field in this array has two effects:
# 1) Any field on the form with one of these names is ignored.
# 2) Fields with one of these names are not displayed to the user
# at any point. (unless $SHOW_INTERNAL_FIELDS_FLAG is 1: see above).
# See &Extract::extract_field_template, &EmailReport::print_template

@F_INTERNAL = ( 
        EMAILBODY, TNAME, REMAINDER, PROBLEMS, WARNCOUNT, ERRORCOUNT, 
        INFORMCOUNT, FIELD_ORDER
);

# When we display the template, we don't want to display the horrible field
# separators above, so we replace them with this before output.
# See &Report::print_template

$VISIBLE_FS = ", ";

# The max length for the key of a field, used only for formatting of template displays
# See &Report::print_template

$MAX_FIELD_KEY_LENGTH = 22;             

######################## TEMPLATE NAMES AND LIMITS  ###########################

$TEMPLATE_NAME_EXTENSION = " TEMPLATE";

# TEMPLATE NAMES
# These must match the names which will appear on the request form
# T_META: the meta template also need a name, if only so it
# can be recognised as the meta template.
# IF THIS HASH IS CHANGED: the corresponding values in %TEMPLATE_DATA
# must also be changed.

%TEMPLATE_NAMES = (                                     
        T_OVERORG =>            "OVERVIEW OF ORGANIZATION$TEMPLATE_NAME_EXTENSION",
        T_REQUESTER =>          "REQUESTER$TEMPLATE_NAME_EXTENSION",
        T_USER =>               "USER$TEMPLATE_NAME_EXTENSION",
        T_USAGE =>              "CURRENT ADDRESS SPACE USAGE$TEMPLATE_NAME_EXTENSION",
        T_OVERREQ =>            "REQUEST OVERVIEW$TEMPLATE_NAME_EXTENSION",
        T_ADDRESSPLAN =>        "ADDRESSING PLAN$TEMPLATE_NAME_EXTENSION",
        T_NETWORK =>            "NETWORK$TEMPLATE_NAME_EXTENSION",
        T_PERSON =>             "PERSON$TEMPLATE_NAME_EXTENSION",

        T_META =>               "CROSS-TEMPLATE PROBLEMS"
);

%TEMPLATE_KEYFIELDS = (
        NAME => "REQUESTER/USER TEMPLATE",
        NETNAME => $TEMPLATE_NAMES{T_NETWORK},
        RSIZE => $TEMPLATE_NAMES{T_OVERREQ},
        PERSON => $TEMPLATE_NAMES{T_PERSON},
        ROLE => $TEMPLATE_NAMES{T_PERSON}
);

# 1) The TYPE OF EACH TEMPLATE for the purposes of extraction.
# We extract a field template differently from how we 
# extract a plan template. The types are indicated below.
# 2) MIN AND MAX numbers of each template allowed
#
# Please stick to the format below :)

%TEMPLATE_DATA = (
        T_OVERORG =>            "TEXT 1 1 NO",
        T_REQUESTER =>          "FIELD 1 1 NO",
        T_USER =>               "FIELD 1 1 NO",
        T_USAGE =>              "PLAN 0 1 NO",
        T_OVERREQ =>            "FIELD 1 1 NO",
        T_ADDRESSPLAN =>        "PLAN 1 1 NO",
        T_NETWORK =>            "FIELD 1 99999 YES",
        T_PERSON =>             "FIELD 0 99999 YES",

        T_META =>               "FIELD 1 1 NO"
);

# A hash of possible MISSPELLINGS to check for in template names
# Key: the misspelt template name
# Value: what the spelling really should be
# See &Misc::correct_template_name_misspellings
# Note: the keys are MATCHED with the string on the form, not eq'd.
#
%TEMPLATE_MISSPELLINGS = ( 
        'ADRESSING\s*PLAN' =>             $TEMPLATE_NAMES{T_ADDRESSPLAN},
        'ADDRESING\s*PLAN' =>             $TEMPLATE_NAMES{T_ADDRESSPLAN},
        'OVERVIEW\s*OF\s*ORGANISATION' =>   $TEMPLATE_NAMES{T_OVERORG},
        'CURRENT\s*USAGE' =>              $TEMPLATE_NAMES{T_USAGE},
        'NETWERK' =>                    $TEMPLATE_NAMES{T_NETWORK},
		'DRESS\s*SPACE\s*USEAGE' =>		$TEMPLATE_NAMES{T_USAGE}
);


############################# REGULAR EXPRESSIONS ###########################

# The case sensitivity of the match in which these expressions are used
# is given after each variable

# Regular expressions starting and ending a template definition

$TEMPLATE_START_REG = "#\\[";                                   #INSENSITIVE
$TEMPLATE_END_REG = "\\]#";                                     #INSENSITIVE

# What does the pattern for 'end of templates' look like ?
# Lee 19990312
# Handle extra whitespace

$LAST_TEMPLATE_REG =                                            #INSENSITIVE
        "$TEMPLATE_START_REG\\s*TEMPLATES\\s+END\\s*$TEMPLATE_END_REG";      

# What does a domain name look like ?

$DOMAINNAME_REG = '[a-zA-Z\d]+([\.\-][a-zA-Z\d]+)*';            #SENSITIVE

# What does an AUTO NIC handle look like ?

$AUTONIC_REG =  '^AUTO-[A-Za-z0-9]{1,4}$';                      #INSENSITIVE

# What might a mistaken attempt at an AUTO NIC handle look like ? This is only
# tried AFTER we've failed to find a valid attempt at an AUTO NIC handle

$NEARLY_AUTONIC_REG = 'AUTO';                                   #INSENSITIVE

# What does a standard NIC handle (RIPE or ARIN) look like ?

# Note: this should use the database function. Hopefully the
# new DB software will enable this to be easily possible.
# The expression below is only sufficient for the vast
# majority of cases.

# Changed 19980527 Lee to deal with xx-org
# From : $NIC_REG = '^[A-Za-z]{1,4}[0-9]{1,4}(-ORG|-RIPE|-ARIN){0,1}$';        #INSENSITIVE
# To:

$NIC_REG = '^[a-z]{1,3}(\d{1,4}(-RIPE|-ARIN|$)|\d{0,4}-ORG)$';  # INSENSITIVE

# What should the value held in a netname field look like ? 
# Even though ripe-142 971113 specifies upper case, this
# is a case insensitive match. The reason is that it's
# checked separately for lower case characters, and that
# generates a warning.

$NETNAME_REG = '^[A-Z-0-9]+$';                                  #INSENSITIVE

# What does a standard field (key+data) look like ?
# This should start with '^' because otherwise whereever
# we find the ':' symbol we'll see it as a field separator.

$FIELD_REG = '^\s*(\S+)\s*:(.*)$';                              #INSENSITIVE

# What does a regid with a proper tag look like ? 
# The brackets indicate to the program what to use as regid in the event this
# pattern is matched: DON'T REMOVE!
# We try this first when we're looking in the subject line for a regid, before
# trying BAREREGID_REG below.

$REGID_REG = 'X-NCC-RegID\s*:\s*([a-z]{2}\.[\w-]+)';               #INSENSITIVE

# What does a regid without a tag look like. This is the last-attempted regid match. 
# Brackets indicate what to use as the regid if theres a match: DON'T REMOVE!

$BAREREGID_REG = '(^|\s+)([a-z]{2}\.[\w-]+)';                   #INSENSITIVE

# What does the service level field key in the registry files look like ?

$SERVICEFIELD_REG = 'Service Level:';                           #INSENSITIVE

# What does an OK service level line look like ?

$SERVICEOK_REG = 'NORMAL';                                      #SENSITIVE

# What does an OK status line in the network template look like ?
# I've used '.' because sometimes we get 'ASSIGNED-PA' KLW 971113
# Changed to \s+ 980303. '.' is plainly silly :-)

$STATUS_REG = '(ASSIGNED[-\s]+PA|ASSIGNED[-\s]+PI)';                      #INSENSITIVE

# What might the description line of a reserved subnet in the addressing plan
# look like. If we spot something like this we give the 'reserved' warning.

$RESERVE_REG = '(reserved|spare|unused)';                       #INSENSITIVE

# Before checking the rest of a plan template, we look in the REMAINDER
# field. In this field are stored lines which we're found in the template
# but did not match the format expected of the a line in a plan.
#
# $MISSING_MASK_REG: if we find this in the REMAINDER field, it's likely
# they entered a line without a mask.
# $MISSING_VALUE_REG: if we find this in the REMAINDER field, it's likely
# they entered a line with a missing integer.
#
# If either of these are detected, analysis of rest of plan is abandoned
# because it likely just degenerates into a chaos of error messages
#
# $quad and $num are not exported, they're only for the clarity of the other 2
# Must have double quotes rather than single to substitute $quad and $num
# Must have double back-slashes because we're using double-quotes :)

$num = '\d{1,5}';
$quad = '\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}';

$MISSING_MASK_REG = "^\\s*$quad(\\s+$num){2,}";                 #SENSITIVE
$MISSING_VALUE_REG = "^\\s*$quad\\s+$quad(\\s+$num){3,}";       #SENSITIVE

# Whats an acceptable match for private-considered field in 
# request-overview template ? If this doesn't match they get
# a PRIVATE_ADDRESSES_NOT_CONSIDERED type warning/error.

$PRVCONSID_REG = '^(yes|y)([^A-Za-z]|$)';                       #INSENSITIVE

# What does a positive response look like for pi-req field in
# request overview template ?

$PIREQPOS_REG = '^(yes|y)([^A-Za-z]|$)';                        #INSENSITIVE

# What does a negative response look like for pi-req field in
# request overview template ?

$PIREQNEG_REG = '^(no|n)([^A-Za-z]|$)';                         #INSENSITIVE

# Indicates a line that ends an entry in the problem_texts or email_texts files.

$TEXTEND_REG = '^\s*(END|DONE)\s*$';                            #SENSITIVE

# Indicates a line that should be ignored in $PROBLEMTEXTS_FILE
# or $EMAILTEXTS_FILE

$TEXTS_IGNORE_LINE_REG = '^\s*(#.*|\s*)$';                      #SENSITIVE

# What does keyword which requests a verbose problem report look like ?
# Matched case SENSITIVE to prevent potential mixup with other
# words in subject line.

$LONGACK_REG = '(\s|^)LONGACK(\s|$)';                           #SENSITIVE

# Emails forwarded to us probably have a quote character at the start
# of each line. This regular expression matches what the start of such
# a line looks like. Anything which this expression is removed from the 
# line before any other processing of the line takes place.

$QUOTED_LINE_START_REG = '^[\.\s>\*-]+';                           #SENSITIVE

# Emails sometimes have strange characters at the start/ends of the
# lines. This is to remove them.

$DOSCONVERSION_REG = '((=0D|=20)$)|(^(=0D|=20))';

# When we're extracting a plan template, there are some things which
# we don't want to recognise as a descr field, because it might throw
# the extraction process. This regular expression defines those things.

$NOT_USE_AS_DESCR_REG = '^[\s_]*$';                             #SENSITIVE

###################### EMAIL RELATED ###################################

# What's the email address of hostmaster

$hm_address =           'hostmaster@ripe.net';

# What's the (short) name of the robot ?
# Used: in $RTT_LOG_MSG_HISTORY_TOO_LONG, $FATAL_ERROR_EXIT_TXT and as
# name of owner for ticket owned by the robot.
# Also is the name used for the public distribution file.

$ROBOT_NAME =           'autohm';

# What's the robot's email address in standalone mode ?

$ROBOT_ADDRESS_STANDALONE =        'auto-hm@ripe.net';

# What's the robot's email address in standalone mode ?

$ROBOT_ADDRESS_REAL =   'hostmaster@ripe.net';

# Used in mail headers

$ROBOT_TITLE = 'RIPE NCC Robot Hostmaster';

# What version number of the software is this ?
# See docs/version-notes.txt for details of changes per version

$VERSION_NUMBER = "1.25";

# These two used for avoiding messages bouncing between the robots. 
# See &Misc::remove_robot_addresses

$INADDR_ROBOT_ADDRESS = 'auto-inaddr@ripe.net';
$DB_ROBOT_ADDRESS =     'auto-dbm@ripe.net';
$DIST_ROBOT_ADDRESS =   'hostmaster@ripe.net';

# What's the name of the wait queue for ticket forwarding purposes ?

$WAIT_QUEUE_NAME =      'wait';

# How many columns should the email report be justified to fit
# into ? This affects almost exclusively problem text display.
# See &Misc::ljustify

$EMAIL_REPORT_NO_OF_COLUMNS = 60;

# This text is pasted at the end of the outgoing email header.
# It's for contact information about RIPE.
# IMPORTANT: It muse end with a '\n'.

$EMAILHEADER_CONTACT_FIELDS_TXT = "X-Organization: RIPE Network Coordination Centre\nX-Phone: +31 20 535 4444\nX-Fax:   +31 20 535 4445\n";

# Headers for the three sections. Don't include PERL meta-
# characters here: they are used as search patterns to
# avoid including previous robot report sections in 
# the 'ORIGINAL MESSAGE' section.

$SECTION_ONE_HEADER = '# Problem Summary #';
$SECTION_TWO_HEADER = '# Analysis of Extracted Data #';
$SECTION_THREE_HEADER = '# Original Message #';

# as above, for html output

$SECTION_ONE_HEADER_HTML = '<hr><H2>Problem Summary</H2>';
$SECTION_TWO_HEADER_HTML = '<hr><H2>Analysis of Extracted Data</H2>';
$SECTION_THREE_HEADER_HTML = '<hr><H2>Original Message</H2>';

# What to output at the beginning of a fatal error

$FATAL_ERROR_EXIT_TXT = "$ROBOT_NAME: -=- EXITED WITH FATAL ERROR -=-\n";

# What to output on successful completion

$NORMAL_COMPLETION_TXT = "$ROBOT_NAME: -=- COMPLETED WITHOUT ERRORS -=-\n";

# This is output as the error text when the robot thinks that the
# input does not hold a ripe-141 form
# IMPORTANT: The $FATAL_ERROR_EXIT_TXT is still output in this
# circumstance

$NOT_A_REQUEST_ERROR_TXT = "\nFatal Error\n\n-=- NO TEMPLATES WERE EXTRACTED -=-\n";


###################### ADDRESSING PLAN CHECK PARAMETERS ###########################

# These two are applied to overall totals the bottom of the plan. They indicate
# the minimum usage efficieny required of the plan, for the 'immediate usage' 
# total and the 'year 1 usage' total
# e.g. imm. eff. = (total immediate usage * 100) / number of addresses requested

$IMMEDIATE_OVERALL_EFFICIENCY_THRESHOLD = 25;                                   
$YEAR1_OVERALL_EFFICIENCY_THRESHOLD = 50;

# Tolerance levels for the above two efficiencies.  If it's within
# this % of the threshold given above, it passes.

$OVERALL_EFFICIENCY_TOLERANCE = 5;                                      

# This is applied per subnet. At least *one* of the three values on each subnet
# (immediate, year1, year2) must achieve this percentage usage (in comparison with
# the subnet size).

$SUBNET_EFFICIENCY_THRESHOLD = 50;                                      

# We add up the total holes in the addressing plan. If this is > 
# $HOLE_WARN_THRESHOLD percent of the actual addresses used then they
# get a warning / error

$HOLE_WARN_THRESHOLD = 10;

# If there are MORE lines in an addressing or usage plan than this,
# it's not processed for errors.

$PLANLINES_IGNORE_THRESHOLD = 50;

####################### MISCELLANEOUS ##########################

%REPORT_TYPE = (
        HTML => 0,
        EMAIL => 1
);

# The 'WARN' entry is to guard against programmer error

%PROBLEM_TYPE = (
        ERROR =>   0,
        WARNING => 1,
        WARN =>    1,
        INFORM =>  2
);

# If there are MORE than $WARNING_REJECT_THRESHOLD warnings throughout
# the whole request then it is rejected

$WARNING_REJECT_THRESHOLD = 3;

# Maximum numbers of warns and errors to display in a report. If
# this is exceeded, the excess are not reported, and an INFORM
# is added.

$MAX_NO_WARNS_IN_TEMPLATE_THRESHOLD = 7;
$MAX_NO_ERRORS_IN_TEMPLATE_THRESHOLD = 7;

# flock masks [file locking]

$LOCK_EX = 2;                           # obtain exlusive lock
$LOCK_UN = 8;                           # release lock

# Text Variables
# If the keys (on the left) are found in $PROBLEMTEXT_FILE
# they are replaced by the associated value (on the right).
# See: &ReportAux::substitute_variables_in_text

%TEXT_VARIABLES = (
        "policy-doc"    =>      "ripe-185",
        "request-form" =>       "ripe-141",
        "request-notes" =>      "ripe-142",
        "ticket-doc" =>         "ripe-183",
        "website" =>            "http://www.ripe.net",
        "ftpsite" =>            "ftp://ftp.ripe.net",
        "arinwhois" =>          "http://whois.arin.net/whois/arinwhois.html"                   
);

# One of the first things the program does is check for files
# in the $TMP_DIR which are older than $TMP_FILE_MAX_AGE
# (in days). Any which are, are deleted.

$TMP_FILE_MAX_AGE = 100;                

# This string is added to the end of temporary files while a request 
# is being processed. Must guarantee another process will not overwrite
# sometime in the future.
# $$    = PID 
# $^T   = program start time in seconds since the epoch.

$UNIQUE_AFFIX = "$$-$^T";       

# These codes will be accepted in addition to the ISO 3166 codes.
# They are needed because we accept some codes in 'country' type
# fields on the form which are not ISO 3166. These fields are (971110)
# 'country' in the requester template
# 'country' in the user template
# 'country-net' in the request overview template
# See &Misc::iscountry

@SPECIAL_COUNTRIES = (
        'EU', 'UK'
);

####################### WHOIS RELATED ###############################

# Where's the local whois client ?

$WHOIS_COM = "/usr/local/bin/whois";

# Retry period (seconds) in event of failure ?

$WHOIS_RETRY_PERIOD = 600;

# Number of times to retry in event of failure ?

$WHOIS_RETRY_TIMES = 9;

# Which option turns of recursive person lookups ?

$WHOIS_RECURSEOFF_OPT = '-r';

# Which option selects to lookup only a particular type of object ?

$WHOIS_OBJECTSELECT_OPT = '-T';

# What does 'whois' output if nothing found ?

$WHOIS_NOTFOUND_REG = 'No\s+entries\s+found';   #INSENSITIVE

# How to tell 'whois' to look in ARIN DB ?

$ARINDB_USE_OPT = '-h whois.arin.net';

# What do the handles of contact people end with in the ARIN DB ?
# Please also change $NIC_REG above correspondingly if you change
# this.

$ARINDB_CONTACT_HANDLE_SUFFIX = '-ARIN';

# Options for narrowing down NIC handle lookup.

$ARINDB_SEARCH_OPT = 'HA';

# Retry period (seconds) in event of failure ?

$ARINDB_RETRY_PERIOD = 600;

# Number of times to retry in event of failure ?

$ARINDB_RETRY_TIMES = 9;

# What does ARIN DB output if nothing found ?

$ARINDB_NOTFOUND_REG = 'No match for';           #INSENSITIVE    

# What does ARIN DB output if key matched ?

$ARINDB_FOUND_REG = 'Record last updated';       #INSENSITIVE

############################ SENDMAIL ###############################

$SENDMAIL_COM = '/usr/sbin/sendmail';

# What options should we use to 'send' to send mail to customers
# -t = scan mail for recipients
#-f = who it's seen as coming from. This is also where bounces will go.
# We need to specify the flags to use depending on the mode of operation (0-3)
# For mode 1 no flag are really necessary, since output is to STDOUT.

# Changed Lee 19981208
# Discovered that sendmail interprets '.' as end-of-message.
# Turned this off with '-i'

@SENDMAIL_FLAGS = (
             '-i -fhostmaster@ripe.net lee@ripe.net',
             '-i lee@ripe.net',
             '-i -fhostmaster@ripe.net -t',
             '-i -fhostmaster@ripe.net -t'
);

############################# DIRECTORY AND FILE LOCATIONS ###########################

# Where's the robot installed FROM ? i.e. where's it's home dir.

$ROBOT_HOME_DIR = '/ncc/softies/projects/ip-req-robot';

# Where's the robot installed TO at RIPE NCC

$ROBOT_INSTALL_DIR = '/ncc/softies/projects/ip-req-robot';

#$ROBOT_INSTALL_DIR =    '/home/hostmaster/ip-req-robot';

# Where's the public install dir ?

$PUBLIC_INSTALL_DIR = '/home/hostmaster/dist-ip-req-robot';

# Where's the zipped distribution put ?

$PUBLIC_DISTRIBUTION_DIR =    '/ncc/ftp-rw/tools/';

# When the public files are installed, all text
# between these two regular expressions is cut out

$PUBLIC_CUT_REG = '^#PUBLIC-CUT$';
$PUBLIC_CUT_END_REG = '^#PUBLIC-CUT-END$';

# Which files to include in the public distribution

@PUBLIC_DISTRIBUTION_FILES = (

           'docs/readme.pub',

           'bin/auto-hm.pl',
           'bin/web141.pl.cgi',

           'lib/Check.pm',
           'lib/EmailReport.pm',
           'lib/ExternalMisc.pm',
           'lib/Extract.pm',
           'lib/Misc.pm',
           'lib/RTT.pm',
           'lib/ReportAux.pm',
           'lib/RobotConfig.pm',
           'lib/TemplateAux.pm',
           'lib/TemplateAux.pm',
           'lib/HtmlReport.pm',
           'lib/Whois.pm',

           'log/fromcust/README',
           'log/tocust/README',

           'tmp/README',

           'texts/email_texts',
           'texts/web_texts',
           'texts/problem_texts'
    );

# Where are all the temporary files created ?  Both incoming from cust + outgoing

$TMP_DIR =              "$ROBOT_INSTALL_DIR/tmp";       

# All mails received from the customer are added to a log file in this dir.
# A new logfile is created each day on the first write.

$log_dir = "$ROBOT_INSTALL_DIR/log";

$FROMCUST_LOG_DIR =     "$log_dir/fromcust";    

# All mails sent to customer by robot are added to a log file in this
# dir. A new logfile is created each day, on the first write.

$TOCUST_LOG_DIR =       "$log_dir/tocust";      

# File which holds all the texts associated with the problem codes
# which Report.pm attaches to each template.

$text_dir = "$ROBOT_INSTALL_DIR/texts";

$PROBLEMTEXT_FILE = "$text_dir/problem_texts";

# File which holds texts which are used at various times in email reports
# template.

$EMAILTEXT_FILE = "$text_dir/email_texts"; 

# MGTM File which holds texts which are used at various times in web reports
# template.

$WEBTEXT_FILE = "$text_dir/web_texts"; 

# Program writes STDIN here first. This file is passed over twice.
# 1) Extract.pm: Extract data.
# 2) Report.pm: Includes this file in the report as the original message.

$FROMCUST_MAIL_FILE = "$TMP_DIR/mailfromcust"; 

# During processing of a request, this string is used as the base
# for a unique filename. The filename is used to store any message
# intended for the customer, prior to it being posted. It's deleted
# after posting.

$TOCUST_MAIL_FILE = "$TMP_DIR/mailforcust";     

# During processing, diagnostic messages are output to this file
# so that if there's a problem it's easy to see what's been done.
# The contents of this file are attached to a problem report
# by &Misc::fatal.

$DIAGNOSTIC_FILE = "$TMP_DIR/diagnostic";

# If we have a fatal error, then in some modes the correct action
# is to write as much debug info as possible to this file.

$FATAL_FILE = "$TMP_DIR/fatal";

# Where's the local copy of the ISO 3166 country code file ?

# MGTM infoserv can see this
$CCODE_FILE = "/home/hostmaster/etc/iso3166-countrycodes";


######################## RTT ################################

# Where's the RTT executable ?

$RTT_COM = "/usr/local/bin/rtt";

# What's a ticket number prefixed by ?

$RTT_TICKET_NUMBER_PREFIX = 'NCC#';

# What does an rtt ticket number look like ? 
# This is not the strict syntax, it's what a customer might put.
# We use it to try and find the ticket number in a message.

$TICKNO_REG = "$RTT_TICKET_NUMBER_PREFIX\\d+";          #INSENSITIVE

# What does a 'ticket does not exist' message look like ?

$RTT_NOT_EXIST_REG = 'Error\s*:.*not exist';            #INSENSITIVE

# What does a 'badly formed tickno' message look like ?

$RTT_MALFORMEDTICKNO_REG = "Error\s*:.*format";         #INSENSITIVE

%RTT_FLAGS = (
             'new ticket' =>            '-N',
             'add to ticket' =>         '-F',
             'show message' =>          '-m',
             'scan tickets' =>          '-S',
             'add to log' =>            '-l',
             'show ticket details' =>   '-s',
             'change ticket' =>         '-C'
);

%RTT_OPTS = (
             'owner' =>                 'owner=',
             'regid' =>                 'regid=',
             'status' =>                'status=',
             'category' =>              'category=',
             'origin' =>                'origin=',
             'tickno' =>                'ticnum=',
             'file' =>                  'file='
);

# What does the history field look like?
# Brackets tell the program where the value to use is: DON'T REMOVE.

$RTT_HISTORY_REG = 'history:\s*(\S+)';                          #INSENSITIVE

# What does the regid field look like ?
# Brackets tell the program where the value to use is: DON'T REMOVE.

$RTT_REGID_REG = 'regid:\s*(\S+)';                              #INSENSITIVE

# What does RTT output when there's an error ?
# Changed Lee 19981208
# Mal will change error messages to match this.

$RTT_ERROR_OUTPUT_REG = '^\s*rtt:.*Error:';                    #SENSITIVE

# What does the response containing the new ticket number look like ?

$RTT_NEW_TICKET_CREATED_REG = 'rtt:\sOK:\sTicket\s(NCC#\d+)\b';      #INSENSITIVE 

# What does the response from rtt -s look like if a ticket exists ?  #INSENSITIVE

$RTT_TICKEXISTS_REG = '^\s*Ticket:\s*NCC#\d+';

# Some initial values when creating a new ticket

$RTT_NEW_TICKET_STATUS = 'OPEN-NCC';
$RTT_NEW_TICKET_ORIGIN_EMAIL = 'automail';
$RTT_NEW_TICKET_ORIGIN_WEB = 'autoweb';

# We can't say at this point whether category is PI or PA because there may be 
# conflicting information in the message.

$RTT_NEW_TICKET_CATEGORY = 'notset';

# What do we put in the category field of a ticket on distribution ?

$RTT_CATEGORY_PI_STRING = 'PIRequest';

$RTT_CATEGORY_PA_STRING = 'PARequest';

# At what point do we decide that the request is going nowhere or that
# something funny is going on ?
# This check is made: AFTER adding the current customer message to the ticket,
# so take this into account when setting it's value.
# If the current customer message is OK, it's dealt with as normal even if the
# threshold has been reached.

$RTT_MAX_NO_MESSAGES_ON_TICKET_THRESHOLD = 10;

# If there are too many messages on a ticket, the robot stops dealing with
# it (see also $RTT_MAX_NO_MESSAGES_ON_TICKET_THRESHOLD). A log message is
# added to the ticket. This is it :)

$RTT_LOG_MSG_HISTORY_TOO_LONG = "$ROBOT_NAME gave up: history too long.";

##################### MISC PROGRAM LOCATIONS & OPTIONS ##################

# MGTM
# which problem types should we NOT show if running with REPORT_TYPE HTML ?
%DONT_REPORT_THESE_FOR_WEB = 
	(
	'SUBNET_USAGE_INEFFICIENT' 		=> '',
	'PERIOD_USAGE_INEFFICIENT' 		=> '',
	'POSSIBLE_RESERVED_SUBNETS' 		=> '',
	);

$REG_COM =      '/usr/local/bin/reg -A';        # Where's the 'reg' program and what's the
                                                # option to get all the data out ?

                                                # Where's the 'date' program, and what
                                                # flags are necessary to make it's
                                                # output suitable for inclusion as an
                                                # email 'Date:' field ?
$DATE_COM = '/bin/date -u +\'%a, %d %h %Y %T +0000\'';

$HOSTNAME_COM = '/bin/hostname';                # Command to get the local hostname

#Where's the text version of the robot ?

$TEXT_AUTO_HM_COM = "$ROBOT_INSTALL_DIR/bin/auto-hm.pl";

# Install Information

# Which subdirectories to create on install ?
@INSTALL_CREATE_DIRS = (
	'bin', 'log', 'log/fromcust', 'log/tocust', 'tmp', 'texts', 'lib'
);

# Which subdirectories to clean on install ?
@INSTALL_CLEAN_DIRS = (
	'bin', 'texts', 'lib'
);

# Which subdirectories to copy accross on install ?
@INSTALL_COPY_DIRS = (
	'bin', 'texts', 'lib'
);

# Which executables are involved ?
# For each of these, the install
# program replaces the first occurence
# of $ROBOT_HOME_DIR with $ROBOT_INSTALL_DIR
@INSTALL_EXECUTABLES = (
	"$TEXT_AUTO_HM_COM"
);

1;

