// pinturas.inc
// pinturas, pinceles, paletas y otros objetos relacionados con la pintura | paints, brushes, palettes and some other objects
// www.luisvaloyes.uni.cc

// frasco de pintura | paint bottle
#declare frasco001 = union {
lathe {linear_spline 10, <0,0>,<0.25,0>,<0.25,0.375>,<0.125,0.5>,<0.125,0.625>,
<0.12,0.625>,<0.12,0.495>,<0.245,0.37>,<0.245,0.005>,<0,0.005>
pigment {rgbf <.7,.5,.3,.8>} finish {metallic brilliance .2 reflection .1 specular .5}}
lathe {linear_spline 4, <0,0.006>,<0.244,0.006>,<0.244,0.31>,<0,0.31> pigment {rgb <1,0,0>}}
lathe {linear_spline 5, <0.126,0.525>,<0.13,0.55>,<0.13,0.65>,<0.12,0.675>,<0,0.675> pigment {rgb <1,1,1>}}
lathe {linear_spline 2, <0.251,0.06>,<0.251,0.32>
pigment {image_map {gif "vinilo01.gif" map_type 1 interpolate 0} translate <0,0.22,0> scale <1,0.75,1>}}}

// otro frasco de pintura sin tapa | another paint bottle
#declare frasco002 = union {
union { torus {.2,.0025 translate <0,.4725,0>} torus {.2,.0025 translate <0,.485,0>}
lathe {linear_spline 10, <0,0>, <.2,0>, <.2,.45>, <.225,.45>, <.225,.46>, <.2,.46>, <.2,.5>, <.18,.5>, <.18,.02>, <0,.02>}
pigment {rgbf <.7,.5,.3,.8>} finish {metallic brilliance .2 reflection .1 specular .5}}
lathe {linear_spline 4, <0,.21>, <.179,.21>, <.179,.39>, <0,.39> pigment {rgb <.2,.9,.4>}}
lathe {linear_spline 2, <0.201,0.09>,<0.201,0.35>
pigment {image_map {gif "tempera01.gif" map_type 1 interpolate 0} translate <0,0.2,0>}}}

// tarro grande de pintura | paint can
#declare tarro01 = union {
union {
torus {.6,.0125 translate <0,1.4,0>} torus {.4,.0125 translate <0,1.4,0>} torus {.2,.0125 translate <0,1.4,0>}
lathe {linear_spline 12, <0,.1>, <.725,.1>, <.725,0>, <.75,0>, <.75,.1>, <.7,.125>, 
<.7,1.375>, <.75,1.4>, <.75,1.5>, <.725,1.5>, <.725,1.4>, <0,1.4>}
pigment {rgb <.8,.8,.8>} finish {metallic reflection .125 specular .6}}
lathe {linear_spline 2, <.7001,.15>, <.7001,1.325>
pigment {image_map {gif "pintulata.gif" map_type 1 interpolate 0} translate <0,0.55,0> scale <1,1.3,1>}}}

// pincel | brush
#declare pincel01 = union { union {sphere {<0,0,0> 1 scale <.05,.25,.05> translate <0,.25,0>} 
cone {<0,.25,0> 0.05 <0,1.75,0> 0.03}
pigment {crackle color_map {[0.0 rgb <.7,.5,.3>][0.4 rgb <.65,.4,.2>][0.7 rgb <.5,.2,0>][0.85 rgb <.8,.65,.5>]} 
turbulence .2 scale <.3,.0075,.0075>} finish {phong .125 phong_size 1}}
cylinder {<0,0,0>,<0,1,0> 1 scale <.031,0.1,.031> pigment {rgb <.7,.7,.7>} finish {metallic specular .6} translate <0,1.75,0>}
sphere {<0,0,0> 1 scale <.035,.18,.035> translate <0,1.925,0> pigment {rgb <.9,.7,.5>} normal {granite 2 scale <.05,5,.05>}}}

// espatula | spatula
#declare espatula = union { superellipsoid {<0.2,0.8> scale <.125,.5,.125> translate<0,.5,0>
pigment {crackle color_map {[0.0 rgb <.7,.5,.3>][0.4 rgb <.65,.4,.2>][0.7 rgb <.5,.2,0>][0.85 rgb <.8,.65,.5>]} 
turbulence .2 scale <.3,.0075,.0075>} finish {phong .125 phong_size 1}}
union { cone {<0,0.9,0> .125 <0,2,0> .25 scale <1,1,0.01>} sphere {<0,0,0> 1 scale <.05,.05,.025> translate <0,0.9,.075>}
sphere {<0,0,0> 1 scale <.05,.05,.025> translate <0,0.9,-.075>}
pigment {rgb <.7,.7,.7>} finish {metallic specular .6 reflection .05 phong .1 phong_size .2}}}

// paleta | palette
#declare paleta = union { prism { quadratic_spline 0, .05, 17,
<0,.4>, <0,0>, <.8,.2>, <1.2,1.4>, <.8,2>, <.4,1.8>, <.2,2.4>, <-.4,2.8>, <-1.2,2.2>, <-1,.8>, <0,0>, // borde exterior
<.3,1.3>, <.2,1.2>, <.4,1.4>, <.2,1.6>, <0,1.4>, <.2,1.2> // agujero
pigment {crackle color_map {[0.0 rgb <.7,.5,.3>][0.4 rgb <.65,.4,.2>][0.7 rgb <.5,.2,0>][0.85 rgb <.8,.65,.5>]} 
turbulence .2 scale <1,.075,.075>} finish {phong .125 phong_size 1}}
sphere {<0,0,0> 1 scale <.16,.0125,.17> rotate <0,20,0> translate <-.7,0.05,1.8> pigment {rgb <1,1,0>}}
sphere {<0,0,0> 1 scale <.12,.0125,.12> rotate <0,40,0> translate <.4,0.05,.8> pigment {rgb <1,0,0>}}
sphere {<0,0,0> 1 scale <.17,.0125,.19> rotate <0,10,0> translate <-.3,0.05,1> pigment {rgb <0,1,0>}}
sphere {<0,0,0> 1 scale <.12,.0125,.16> rotate <0,-30,0> translate <-.3,0.05,2> pigment {rgb <0,0,1>}}}
