// objetosvarios.inc
// diversos objetos secundarios usados en la escena | some secundary objects used in the scene
// www.luisvaloyes.uni.cc

//el reloj de pared | the wall clock
#declare reloj01 = union {
//la caja del reloj
union { cylinder {<0,0,0><0,1,0>,1 scale <1.5,0.3,1.5>}
torus { 1.375,0.125 scale <1,2,1> translate <0,0.3,0>} pigment {rgb <1,0,0>} finish {ambient .45 phong .25 phong_size .2}}
//el tablero
disc {<0,0,0> y 1.35 translate <0,0.3001,0> pigment {rgb 1} finish {ambient .6}}
//el cristal
disc {<0,0,0> y 1.375 translate <0,0.4,0> pigment {rgbf <1,1,1,.9> } finish {metallic reflection .125 specular .2 ambient .7}}
//los numeros
union { box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <0.05,0.05,0.2> translate <0.045,0.3,-1> rotate <0,0,0>}
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <0.05,0.05,0.2> translate <-0.045,0.3,-1> rotate <0,0,0>}
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <0.025,0.05,0.175> translate <0,0.3,-1> rotate <0,90,0>}
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <0.025,0.05,0.175> translate <0,0.3,-1> rotate <0,180,0>}
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <0.025,0.05,0.175> translate <0,0.3,-1> rotate <0,270,0>}
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <0.02,0.025,0.1> translate <0,0.3,-1> rotate <0,30,0>}
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <0.02,0.025,0.1> translate <0,0.3,-1> rotate <0,60,0>}
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <0.02,0.025,0.1> translate <0,0.3,-1> rotate <0,120,0>}
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <0.02,0.025,0.1> translate <0,0.3,-1> rotate <0,150,0>}
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <0.02,0.025,0.1> translate <0,0.3,-1> rotate <0,210,0>}
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <0.02,0.025,0.1> translate <0,0.3,-1> rotate <0,240,0>}
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <0.02,0.025,0.1> translate <0,0.3,-1> rotate <0,300,0>}
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <0.02,0.025,0.1> translate <0,0.3,-1> rotate <0,330,0>}
pigment {rgb <0,0,0>}}
//el eje de las manecillas
union {
cylinder {<0,0,0><0,1,0>, 1 scale <0.075,0.005,0.075> translate <0,0.3,0> }
cylinder {<0,0,0><0,1,0>, 1 scale <0.005,0.075,0.005> translate <0,0.3,0> }
pigment {rgb <.9,.7,.5>} finish {metallic phong .1 phong_size .1}}
//las manecillas
union {
box {<-0.5,0,-0.5><0.5,1,0.5> scale <0.04,0.005,0.7> translate <0,0.32,-0.34> rotate <0,30,0>} //horario
box {<-0.5,0,-0.5><0.5,1,0.5> scale <0.025,0.005,1> translate <0,0.34,-0.49> rotate <0,140,0>} //minutero
box {<-0.5,0,-0.5><0.5,1,0.5> scale <0.01,0.005,1.1> translate <0,0.36,-0.54> rotate <0,250,0> pigment {rgb <1,0,0>}} //segundero
pigment {rgb <0,0,0>}}
rotate <90,0,0>}

// el aviso de advertencia | the warning sign
#declare aviso001 = union {box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <5,3.75,.05>
pigment {image_map {gif "warning.gif" map_type 0 interpolate 0} scale <5,3.75,1> translate <2.5,1.875,0>}}
union {sphere {<0,0,0> 1 scale <.1,.1,.05> translate <2.2,1,-.025>} 
sphere {<0,0,0> 1 scale <.1,.1,.05> translate <-2.2,1,-.025>} pigment {rgb <.8,.8,.8>} finish {metallic specular .6}}}

//la canasta de la basura | the garbage basket
#declare caneca = union {union {
cylinder { <0,0,0>,<0,1,0>,1.0 scale <1,0.1,1>} torus { 1.15, 0.05 translate <0,2.5,0> }
pigment {rgb <1,0,0>} finish {phong .2 phong_size .2}}
cone { <0,0.1,0>,  0.95, <0,2.5,0>, 1.15 open
texture {pigment {gradient x color_map {[0.0 rgbf <1,1,1,1>][0.1 rgbf <1,0,0,0>][0.3 rgbf <1,1,1,1>][0.4 rgbf <1,1,1,1>]}}
scale .125 rotate <0,0,45>}
texture {pigment {gradient z color_map {[0.0 rgbf <1,1,1,1>][0.1 rgbf <1,0,0,0>][0.3 rgbf <1,1,1,1>][0.4 rgbf <1,1,1,1>]}}
scale .125 rotate <45,0,0>}}
//la siguiente es la basura
cone { <0,0.11,0>,  0.94, <0,1,0>, 1 pigment {rgb <1,1,1>} finish {ambient .4} normal {crackle 50 scale .5}}}

// un lapiz | a pencil
#declare lapiz01 = union {
cone {<0,0,0> 0 <0,.05,0> 0.0125 pigment {rgb <0,0,0>} finish {phong .2 phong_size .2}}
union { cone {<0,.05,0> 0.0125 <0,.15,0> 0.049 } cylinder {<0,.15,0><0,.25,0> 0.049}
pigment {crackle color_map {[0.0 rgb <.7,.5,.3>][0.4 rgb <.65,.4,.2>][0.7 rgb <.5,.2,0>][0.85 rgb <.8,.65,.5>]} 
turbulence .2 scale <3,.075,0.075>}}
difference { cylinder {<0,.15,0> <0,1.25,0> 0.05} 
union {sphere {<0,0,0> 1 scale <.015,.02,1> rotate <0,0,0>} sphere {<0,0,0> 1 scale <.015,.02,1> rotate <0,90,0>}
sphere {<0,0,0> 1 scale <.015,.02,1> rotate <0,45,0>} sphere {<0,0,0> 1 scale <.015,.02,1> rotate <0,-45,0>}
translate <0,.15,0>}}
cylinder {<0,1.25,0><0,1.4,0> 0.052 pigment {rgb <.7,.7,.7>} finish {metallic reflection .075 specular .7}}
cylinder {<0,1.31,0> <0,1.34,0> 0.0521 pigment {rgb <1,0,0>}}
cylinder {<0,1.4,0><0,1.47,0> 0.05 pigment {rgb <1,.6,.6>}}
rotate <-90,0,0> translate <0,0.052,0>}

// afiche | poster
#declare afiche01 = union {
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <3.6,5.12,0.01> 
pigment {image_map {gif "afiche01.gif" map_type 0 interpolate 0} scale <3.6,5.12,1> rotate <0,180,0> translate <1.8,2.56,0>}
finish {ambient .4}}
union {box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <.8,.15,.02> rotate <0,0,-45> translate <1.7,2.46,0>}
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <.8,.15,.02> rotate <0,0,-45> translate <-1.7,-2.46,0>}
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <.8,.15,.02> rotate <0,0,45> translate <-1.7,2.46,0>}
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <.8,.15,.02> rotate <0,0,45> translate <1.7,-2.46,0>}
pigment {rgbf <.9,.8,.3,.6>}}}

// otro afiche | another poster
#declare afiche02 = union {
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <3.6,5.12,0.01> 
pigment {image_map {gif "afiche02.gif" map_type 0 interpolate 0} scale <3.6,5.12,1> rotate <0,180,0> translate <1.8,2.56,0>}
finish {ambient .4}}
union {box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <.8,.15,.02> rotate <0,0,-45> translate <1.7,2.46,0>}
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <.8,.15,.02> rotate <0,0,-45> translate <-1.7,-2.46,0>}
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <.8,.15,.02> rotate <0,0,45> translate <-1.7,2.46,0>}
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <.8,.15,.02> rotate <0,0,45> translate <1.7,-2.46,0>}
pigment {rgbf <.7,.7,.4,.6>}}}

// y otro afiche | and another poster
#declare afiche03 = union {
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <3.6,5.12,0.01> 
pigment {image_map {gif "afiche03.gif" map_type 0 interpolate 0} scale <3.6,5.12,1> rotate <0,180,0> translate <1.8,2.56,0>}
finish {ambient .4}}
union {box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <.8,.15,.02> rotate <0,0,-45> translate <1.7,2.46,0>}
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <.8,.15,.02> rotate <0,0,-45> translate <-1.7,-2.46,0>}
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <.8,.15,.02> rotate <0,0,45> translate <-1.7,2.46,0>}
box {<-0.5,-0.5,-0.5><0.5,0.5,0.5> scale <.8,.15,.02> rotate <0,0,45> translate <1.7,-2.46,0>}
pigment {rgbf <.8,.8,.2,.6>}}}

// rejilla de ventilacin
#declare rejilla = height_field {tga "rejilla.tga" scale <10,.2,10> translate <-5,0,-5> rotate <180,0,0> 
pigment {image_map {gif "rejilla.gif" map_type 0 interpolate 0} scale 10 rotate <-90,0,0 > translate <-5,0,-5>}
finish {metallic reflection .05 specular 1 ambient .9 diffuse .2}}