#include "rad_def.inc"
#include "colors.inc"
#include "skies.inc"
#include "stones1.inc"
#include "textures.inc"

#default { pigment { color rgb .8 } finish{ambient 0}}
#background { color rgb .5 }        
global_settings {
 assumed_gamma 2.2               
 ambient_light 0.001                           
 radiosity { Rad_Settings(Radiosity_OutdoorLQ, true, true) brightness .1 save_file "radiosity.dat" }
}

#local Sky=1;
#local Planets=1;
#local Ground=1;
#local Ships=1;
#local Astronaut=1;
#local Atmosphere=1;
    
#local ALFA=25;
camera {
 location  <100.0, 60.0, -100.0>*1
 look_at   <-30.0, 30.0,  0.0>
 right     x*image_width/image_height
 rotate y*ALFA  
}

#if (Ground)                        
//******************************************************************************//
// podoe // ground
//******************************************************************************//

 light_source {
  <-10000,10000,17000>*.05
  color rgb <0.35, 0.75, 0.75>*.845
 }

 #declare B = function {
  pigment {
   bozo
   turbulence 0.5
   omega .6   
   lambda 2
   frequency 1 
   pigment_map {
    [0 rgb 0]
    [1 rgb 1]
   }
   scale 50 
  }
 }                                  
 #declare F=function {
  pigment {
   granite
   turbulence 0.1
   color_map {
    [0 rgb 0][1 rgb 1]
   }
   scale 5
  }
 }  
 #declare C1 = function {
  pigment {
   cells
   turbulence 0.5
   omega .9   
   lambda 2   
   frequency 2 
   pigment_map {
    [0 rgb 0]
    [1 rgb 1]
   }    
   scale 500
  } 
 }
 isosurface {
  function { y-50*B(x,y,z).red*C1(x,y,z).red+.2*F(x,y,z).red }
  max_gradient 2
  accuracy .005
  contained_by { box { <-100, 0, -100>, <100, 50, 100> } }
  texture {Sandalwood scale 50 pigment { transmit .5}}
  texture { T_Grnt5a scale 100 }
  rotate y*ALFA 
 }
#end

#if (Planets)        
//******************************************************************************//
// planety // planets //                                                        
//******************************************************************************//
light_group {
 sphere {
  <30,250,20000>, 5000 
  pigment {
   bozo
   turbulence 0.5
   omega .9   
   lambda 2   
   frequency 1 
   pigment_map {
    [0 rgb -2]
    [1 rgb 2]
   }    
   rotate y*20    
   scale 10000
  }
 }
 sphere { <-6000,4850,19000>, 850 pigment { color rgb 2 } }
 sphere { <-12000,400,17000>, 850 pigment { color rgb 2 }}
 light_source {
  <-1000000,1000000,17000>
  color rgb <1,1,1>*3.4
 }
}
#end         

#if (Sky)         
//******************************************************************************//
// niebo // sky //
//******************************************************************************//

light_group {
 light_source {
  <0,0,6000>
  color rgb <1,1,1>*1.7
 }
 sphere{0,10001 double_illuminate pigment { color rgbf <.4,.5,.5,.05>*1.4 } hollow }
 object{O_Cloud1
  pigment {
    bozo
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0, 0.1   color red 0.85 green 0.85 blue 0.85
                    color red 0.75 green 0.35 blue 0.75]
        [0.1, 0.5   color red 0.35 green 0.75 blue 0.75
                    color Clear]
        [0.5, 1.001 color Clear
                    color Clear]
   }
   scale <6, 1, 6>
  }
  hollow
 }
 rotate -x*15
}
#end

#if (Ships)
//******************************************************************************//
// statki kosmiczne // space ships //
//******************************************************************************//

 #declare ship = union {
 cone {
  -y*500,0,y*50,1.5 
  pigment {rgbt 1}
  hollow
  interior {
   media {
    emission <.4,.5,.5>*1.2
    density { 
     gradient y 
     color_map {
      [0 rgb 0]
      [1 rgb .3]
     }
     scale y*600
     translate -y*550
     turbulence .3
    } 
   }
  }
  finish { ambient 1 }
 }  
 sphere {
  0,5           
  pigment{rgbt 1}  
  hollow 
  interior {
   media {
    emission <.45,.55,.5>*1.5
    density { spherical color_map { [0 rgb 0][1 rgb .049] } turbulence .1 /*omega .9*/ frequency 3 octaves 5 scale 6 }
    intervals 1
    samples 10
    method 3
    confidence .999999
    variance 1/10000000
   }
  }
  no_shadow
  translate y*50 
 }  
 union {
  cone {0,1, y,0  scale <2,20,2>}
  cone {0,1,-y,.8  scale <2,10,2>}
  box {-1,1 scale <4,2,.001> translate -y*9}
  box {-1,1 scale <4,2,.001> translate -y*9 rotate y*90}
  translate y*64
 }
 }

 object { ship scale 6 rotate z*85 translate <0,200,5000> rotate -y*20 }
 object { ship scale 6 rotate z*85 translate <0,220,5000> rotate -y*10 }
 object { ship scale 6 rotate z*85 translate <0,100,5000> rotate -y*15 }
#end 

#if(Astronaut)  
//******************************************************************************//
// kosmonauta // astronaut //
//******************************************************************************//

 union {
  #include "astronaut.inc"
  rotate -y*40
  scale 3
  translate <-90,27,30>
 }
#end

#if(Atmosphere)
//******************************************************************************//
// atmosfera // atmosphere //
//******************************************************************************//

 cylinder {
  0,y,1 scale 100 translate <0,-32,0> 
  pigment{rgbt 1}  
  hollow 
  interior {
   media {
    scattering {1, rgb .013} 
    absorption <0.35, 0.75, 0.75>*.006              
    density { gradient -y color_map {[0 rgb 0][1 rgb 1]}scale y*50 translate y*20 turbulence .022 } 
    intervals 1
    samples 10
    method 3
    confidence .999999
    variance 1/10000000
   }
  }
  no_shadow 
  rotate -x*10 rotate z*1
 }
#end 

