// Persistence of Vision Ray Tracer Scene Description File
// File: Isolation.pov
// Vers: 3.5
// Desc: IRTC entry, topic: Isolation
// Date: 8/27/2002
// Auth: Copyright (C) Patrick A. Cox 2002

#include "shapes.inc"
#include "colors.inc"
#include "metals.inc"
#include "BlockWall.inc"
#include "woods.inc"

#declare WallTex = material {
		texture {
			pigment {color LightGray }
			normal {
        		    granite .2 
        		    scale <0.25,0.25,0.25>
        		  }
		}
}

#declare WallTexStain = material {
		texture {
			pigment {color LightGray }
			normal {
        		    granite .2 
        		    scale <0.25,0.25,0.25>
        		  }
		}
		// stain
		texture {
		        pigment {
		                mandel 100
                                color_map {
                                  [ 0.0  rgbt<.5,.5,.5,1>]
                                  [ 0.7  color DarkGreen]
                                  [ 1.0  rgbt<.5,.5,.5,1>]
                                } // color_map
                                scale <20,20,20>
                                rotate <0,0,90>
                                translate <1.8,-8.5,0>
		        }
		                     
		}
		
}

#declare MortarTex = material {
		texture {
			normal {
			    granite .2 
			    scale <0.05,0.05,0.05>
			  }

			pigment {color Gray40 }
		}
		
}

light_source {
  0*x                 // light's position (translated below)
  color rgb 1       // light's color
  area_light
  <0, 0, 1>,<0, 1, 0>,
  20, 20
  circular
  orient
  translate <19.9, 6, -9>   // <x y z> position of light
}


// create a regular point light source (outside the cell), looks like the moon...
light_source {
  <30,80,1500>                 // light's position (translated below)
  color rgb <1,1,1>    // light's color
  looks_like {
  	disc {
  		<0,0,0>,<0,0,-1>,100
  		texture {
  			finish {ambient <1.3,1.3,1.35> }
  			pigment {
  				image_map {
					  tiff "PIA00405_1k1k.tiff"
					  map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
					  interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
					  once
					} // image_map
  			}
  			translate <-.5,-.5,0>
  			scale <50,50,1>
  			
  		}
  	no_shadow
  		
  	}
  }
  
}

// radiosity (global illumination) settings
global_settings {
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.04           // end pretrace at this size
    count 150                      // higher -> higher quality (1..1600) [35]
    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1                // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    normal on                   // take surface normals into account [off]
    media on                    // take media into account [off]
    //save_file "file_name"       // save radiosity data
    //load_file "Isolation.rca"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
}

// atmosphere in cell
box { <-1,-1,-16>,<21,8,1>
	pigment { color rgbt<1,1,1,1> }
	interior {
		media {
		  intervals 100
		  scattering { 2, rgb 0.0025 }
		  samples 3, 10
		}
	}
	hollow
}


// perspective (default) camera
camera {
  location  <8, 5.0, -13.5>
  look_at   <8, 3.5, 0.0>
  right     x*image_width/image_height
}

// Front wall with window (much faster than a CSG difference cutting the window out of one BlockWall macro)
object{ BlockWall(13,3,2,1,1,0.08,false,false) material {WallTexStain}}
object{ BlockWall(13,1,2,1,1,0.08,false,false) material {WallTex} translate <0,6,0>}
object{ BlockWall(8,3,2,1,1,0.08,false,true) material {WallTex} translate <-1,3,0>}
object{ BlockWall(3,3,2,1,1,0.08,true,false) material {WallTex} translate <11,3,0>}
difference {
	box {<0.025,0.025,0.025>,<13.975,6.975,0.975> material {MortarTex}}
	box { <7.001,3.001,-2>,<10.999,5.999,2> material {MortarTex}}
}

object { BlockWall(5,7,2,1,1,0.08,true,true) translate <14,0,0> material {WallTex}}
box { <0.025,0.025,0.025>,<5.975,6.975,0.975> translate <14,0,0> material {MortarTex}}

object {BlockWall(15,7,2,1,1,0.08,true,false) rotate <0,270,0> translate <0,0,-15> material {WallTex}}
box { <0.025,0.025,0.025>,<15.975,6.975,0.975> rotate <0,270,0> translate <0,0,-15> material {MortarTex}}

object { BlockWall(3,7,2,1,1,0.08,false,true) rotate <0,90,0> translate <13,0,0> material {WallTex}}
object { Round_Box_Union(<0.025,0.025,0.025>,<3.975,6.975,0.975>,0.08) rotate <0,90,0> translate <13,0,0> material {MortarTex}}	

// bars for window
union {
	box { <6,3.95,0.35>,<12,4.05,0.65> }
	box { <6,4.95,0.35>,<12,5.05,0.65> }
	cylinder { <7.66,2,0.5>,<7.66,7,0.5>,.05}
	cylinder { <8.33,2,0.5>,<8.33,7,0.5>,.05}
	cylinder { <9,2,0.5>,<9,7,0.5>,.05}
	cylinder { <9.66,2,0.5>,<9.66,7,0.5>,.05}
	cylinder { <10.33,2,0.5>,<10.33,7,0.5>,.05}
	texture {T_Chrome_1A}
}

// bars for "door"
union {
	box { <13.35,0.95,-2>,<13.65,1.05,-14> }
	box { <13.35,1.95,-2>,<13.65,2.05,-14> }
	box { <13.35,2.95,-2>,<13.65,3.05,-14> }
	box { <13.35,3.95,-2>,<13.65,4.05,-14> }
	box { <13.35,4.95,-2>,<13.65,5.05,-14> }
	box { <13.35,5.95,-2>,<13.65,6.05,-14> }
	cylinder { <13.5,-1,-4.33>,<13.5,8,-4.33>,.05}
	cylinder { <13.5,-1,-5.00>,<13.5,8,-5.00>,.05}
	cylinder { <13.5,-1,-5.66>,<13.5,8,-5.66>,.05}
	cylinder { <13.5,-1,-6.33>,<13.5,8,-6.33>,.05}
	cylinder { <13.5,-1,-7.00>,<13.5,8,-7.00>,.05}
	cylinder { <13.5,-1,-7.66>,<13.5,8,-7.66>,.05}
	cylinder { <13.5,-1,-8.33>,<13.5,8,-8.33>,.05}
	cylinder { <13.5,-1,-9.00>,<13.5,8,-9.00>,.05}
	texture {T_Chrome_1A}
}

#declare Mould = difference {
                        plane { y, 0}
                        difference {
                                sphere {0,.5 scale <1,.5,1>}
                                plane { y,-.15 }
                                }
                                
                        }

union {
	// Plate/bowl
	intersection {        
	        difference {
	                object{ Mould }
	                object{ Mould translate <0,-.01,0>}
	               }
	        cylinder { <0,-50,0>,<0,50,0>,.55 }
	        texture {T_Chrome_5A normal {dents .5} scale <.1,.1,.1>}
	}
	 
	// Spoon 
	union {
	        difference {
	                sphere {0,.5 scale <.8,.3,.65>}
	                sphere {0,.5 scale <.8,.3,.65> translate <0,.01,0>}
	        }
	        cylinder {<.35,0,0>,<2,0,0>,.1 scale <1,0.3,1>}
	        texture {T_Chrome_5A normal {dents .05} scale <.1,.1,.1>}
	        scale <.25,.25,.25>
	        rotate <0,0,16>
	        translate <.1,-.1,0>
	}
	
	#declare S=seed(521);
	#declare i=0;
	blob {  
	        #while (i<200)
	                component rand(S),rand(S)*0.1,<(0.5-rand(S))*.5,0,(0.5-rand(S))*.5>
	                #declare i = i + 1;
	        #end
	        
	        texture { 
	                pigment {color rgb<1,1,0.9>}
	                normal { crackle 1 scale <0.2, 0.2, 0.2>}
	                finish { specular .3 roughness .5}
	                scale <.05,.05,.05>
	        }
	        scale <1,.5,1>
	        translate <0,-.15,0>
	}
rotate <0,-45,0>	
translate <4.5,0.169,-4.5>
}

// floor
box { <-1,-1,-14>,<20,0,1>
	texture {normal { bumps 0.1 } pigment {color LightGray} scale <5,5,5>}
	// stains
	texture {
	        pigment {
	                bozo
	                turbulence 0.2
                        color_map {
                          [ 0.0  rgbt<1,1,1,1>]
                          [ 0.69  rgbt<.5,.5,.5,1>]
                          [ 0.7  color Gray40]
                          [ 0.76  rgbt<.5,.5,.5,1>]
                          [ 1.0  rgbt<1,1,1,1>]
                        } // color_map
                        scale <5,5,4>
                        translate <-6.7,0,1.5>
	        }
	                     
	}
}

// ceiling
box { <-1,7,-14>,<20,8,1> texture {normal { bumps 0.1 } pigment {color LightGray} scale <5,5,5>}}

// right wall
box { <20,-1,1>,<21,8,-14> texture {pigment {color LightGray}}}
// rear wall
box { <-1,-1,-15>,<21,8,-14> texture {pigment {color LightGray}}}

// ocean
plane { y,-30
	normal {bumps .1 turbulence .5
        scale .8
	} 
	pigment {color rgb<0.2,0.2,0.3>*2}
	finish {
		reflection {
			0.0, 1.0
          		fresnel on
          		}
 		specular .4
 		roughness 0.03
 		}

}

// stool
#declare LEG = union {
	cylinder {<0,0,0>,<0,-1,0>,0.1}
	sphere {<0,-1,0>,0.1}
}

union {
	
	difference {
		sphere {0,0.75 scale <1,0.5,1>}
		plane {y,-0.125 }
		plane {-y,-0.125 }
	}
	object {LEG texture {T_Wood7 rotate <86,0,0> translate <.15,0,-.2> } rotate <0,0,30> translate <.2,0,0>}
	object {LEG texture {T_Wood7 rotate <86,0,0> translate <.15,0,-.2> } rotate <0,0,30> translate <.2,0,0> rotate <0,120,0>}
	object {LEG texture {T_Wood7 rotate <86,0,0> translate <.15,0,-.2> } rotate <0,0,30> translate <.2,0,0> rotate <0,240,0>}
	texture {T_Wood7 rotate <86,0,0> translate <.15,0,-.2> }
	translate <2.5,1,-3>
}

// calendar
bicubic_patch {
  type 1
   flatness 0.1
   u_steps 3
   v_steps 3
  <0, 1.00, -0.10> <0.33, 1.00, 0> <0.66, 1.00, 0> <1, 1.00, -0.12>
  <0, 0.66,  0.00> <0.33, 0.66, 0> <0.66, 0.66, 0> <1, 0.66,  0.00>
  <0, 0.33,  0.00> <0.33, 0.33, 0> <0.66, 0.33, 0> <1, 0.33,  0.00>
  <0, 0.00, -0.05> <0.33, 0.00, 0> <0.66, 0.00, 0> <1, 0.00, -0.06>
  texture {
  	pigment {
	image_map {
	  png "July24.png"
	  map_type 0        // 0=planar
	  interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
	  once
	} // image_map
	}
  }
  scale <1.5,1.5,1>
  translate <3,3,-0.01>
}