// Fichero de POVRAY 3 por:
// POVRAY 3 file by:
//  Guillermo S. Romero

// E-mail:     famrom@ran.es
// Snail-mail: P.O.Box 35099-28080 Madrid (Espaa)

// Este fichero contiene:
//  Una habitacion.
//--
// This file contains:
//  A room.

// ** IMPORTANT ** Wrong use can cause errors, I decline ALL responsability.
// INCLUDE FLAGS
//  ## No flags used ##
// For multiple "include"s of this file use multiple flags, think about this
//  condition as arguments required by functions.


#declare Walls =
    union {
        difference { // Front
            box { <-3.5, 0, 3>, <1, WallHeight, 3.5> }
            box { <-2.5, WindowBase, 2.99>, <0, WindowBase + WindowHeight, 3.51> }
        }
        difference { // Corridor
            box { <.5, 0, 3>, <1, WallHeight, 9> }
            box { <.49, WindowBase, 4>, <1.01, WindowBase + WindowHeight, 8.5> }
        }
        difference {
            box { <-3.5, 0, -7>, <-3, WallHeight, 3> }
            box { <-3.51, WindowBase, -6.5>, <-2.99, WindowBase + WindowHeight, 2.5> }
        }
//        box { <-3.1, 0, -7>, <-3, WallHeight, 3> } // Left
        box { <3, 0, -7>, <3.1, WallHeight, 9> } // Right
        box { <-3.5, 0, -7.5>, <3, WallHeight, -7> } // Back
        box { <1, 0, 9>, <3, WallHeight, 9.1> } // Door (end)
        box { <1, 0, 3>, <1.5, WallHeight, 3.1> } // Door (left)
        box { <2.5, 0, 3>, <3, WallHeight, 3.1> } // Door (right)
        difference { // Door (top)
            box { <1.5, 1.5, 3>, <2.5, WallHeight, 3.1> }
            cylinder { <2, 1.5, 2.99>, <2, 1.5, 3.11>, .5 }
        }
        texture { T_Wall }
    }

#declare Baseboard =
    union {
        box { <-3.11, 0, -7>, <-2.99, BaseHeight, 3> } // Left
        box { <2.99, 0, -7>, <3.11, BaseHeight, 9> } // Right
        box { <-3, 0, -7.11>, <3, BaseHeight, -4.99> } // Back
        box { <1, 0, 8.99>, <3, BaseHeight, 9.11> } // Door (end)
        box { <-3, 0, 2.99>, <1.51, BaseHeight, 3.11> } // Door & wall
        box { <2.49, 0, 2.99>, <3, BaseHeight, 3.11> } // Door
        box { <.89, 0, 3>, <1.01, BaseHeight, 9> } // Corridor
        texture { T_Baseboard }
    }

#declare Door =
    union {
        box { <1.5, 0, 8.98>, <2.5, DoorHeight, 9.12> }
        box { <1.4, DoorHeight, 8.96>, <2.6, DoorHeight+.1, 9.14> } // Frame (top)
        box { <1.4, 0, 8.96>, <1.5, DoorHeight, 9.14> } // Frame (right)
        box { <2.5, 0, 8.96>, <2.6, DoorHeight, 9.14> } // Frame (left)
        sphere {
            <2.4, DoorHeight / 2, 8.98 - .025>, .025
            texture { T_Chrome_4A }
        }
        texture { T_Door }
    }

#declare Floor =
    union {
        box { <-3, -.1, -7>, <3, 0, 3> } // Hall
        box { <1, -.1, 2>, <3, 0, 9> } // Corridor
        texture { T_Floor }
    }

#declare Ceiling =
    union {
        box { <-3, WallHeight-.01, -7>, <3, WallHeight+.1, 3> } // Hall
        box { <1, WallHeight-.01, 2>, <3, WallHeight+.1, 9> } // Corridor
        texture { T_Wall }
    }

#declare WindowY = WindowHeight
#declare ThreeWindows =
    union {
        #declare WindowX = 2.5
        #include "window.inc"
        object { // Front
            Window
            translate <-2.5, WindowBase, 3.25>
        }
        #declare WindowX = 4.5
        #include "window.inc"
        object { // Corridor
            Window
            rotate -90 * y
            translate <.75, WindowBase, 4>
        }
        #declare WindowX = 9
        #include "window.inc"
        object { // Left
            Window
            rotate 90 * y
            translate <-3.25, WindowBase, 2.5>
        }
    }


// (C) Guillermo Sanz Romero
// Todos los derechos reservados.
// Si deseas utilizar la totalidad o parte de este fichero puedes hacerlo
//  mientras no sea con fines lucrativos.
// En caso de usarlo para publicidad, recopilaciones de software, inclusin
//  en revistas o alguna otra actividad que suponga una transaccin
//  remunerada (con cualquier tipo de bien, por lo que los trueques y los
//  premios de los concursos tambin quedan incluidos), debes ponerte en
//  contacto utilizando las direcciones de la cabezera para poder acordar las
//  condiciones que te permitan hacer dicho uso de los datos contenidos en
//  este fichero o los generados a partir de l, tanto descripciones de
//  imagenes como las imagenes en si, en cualquier formato y/o medio de
//  almacenamiento.
//--
// All rights reserved.
// If you want to use this file in is enterity or only parts of it you can do
//  it while it is a non-profitable purpose.
// In case of using it for advertisment, software recopilations, bunddling it
//  with magazines or another profitable transaction (any sort of profit, so
//  exchange and prizes won in contests are included), you must get in touch
//  with me through the addresses given above to reach an agreement about the
//  conditions to use the data here contained (this file) or build from it,
//  both new image descriptions and images, whatever the format and/or the
//  storage way.

// No dudes en escribirme si tienes alguna pregunta, tanto sobre la clusula
//  arriba expuesta como sobre el fichero de datos que describe las imgenes
//  y las imgenes en si.
// P.D.: los precios son razonables y el dinero esta destinado bsicamente
//  a mejorar mi ordenador y poder seguir creando ms imagenes.
//--
// Do not doubt to write me if you has any question, about the clausule 
//  written above or the descriptions and the images.
// P.S.: prices are reasonable and money is basically to improve my computer
//  so I can keep making more pictures.

// NOTA IMPORTANTE
//  Este es un extracto de la licencia completa (LICENSE.GSR), lee dicho
//  fichero para conocer todas las condiciones y clusulas.
//--
// IMPORTANT NOTE
//  This is an extract of the complete license (LICENSE.GSR), read that file
//  to know all the conditions and clausules.
