// Fichero de POVRAY 3 por:
// POVRAY 3 file by:
//  Guillermo S. Romero

// E-mail:     famrom@ran.es
// Snail-mail: P.O.Box 35099-28080 Madrid (Espaa)

// Este fichero contiene:
//  Un caballete.
//--
// This file contains:
// An easel.

// ** IMPORTANT ** Wrong use can cause errors, I decline ALL responsability.
// INCLUDE FLAGS
//  ## No flags used ##
// For multiple "include"s of this file use multiple flags, think about this
//  condition as arguments required by functions.


#declare Picture_A =
    union {
        box {
            <0, 0, -.02>, <1, 1, -.019>
            scale <Pic_A_X, Pic_A_Y, 1>
            texture {
                pigment {
                    image_map {
                        png Pic_A_png
                    }
                    scale <Pic_A_X, Pic_A_Y, 1>
                }
                finish { F_Pic_A }
                normal { N_Pic_A }
            }
            rotate x * 5
            translate <.05 - (Pic_A_X / 2), Pic_A_B, -.08>
        }
        box {
            <0, 0, -.019>, <1, 1, 0>
            scale <Pic_A_X, Pic_A_Y, 1>
            texture {
                pigment { Gray95 }
                finish { Dull }
                normal { bumps .01 scale .001 }
            }
            rotate x * 5
            translate <.05 - (Pic_A_X / 2), Pic_A_B, -.08>
        }
    }

#declare HalfEasel_A =
    union {
        cylinder { <0, .05, 0>, <.6, .05, 0>, .05 } // Center
        cylinder { <.45, .05, -.35>, <.45, .05, .25>, .05 } // Leg
        union {
            sphere { <.6, .05, 0>, .05 } // Side
            sphere { <.45, .05, -.35>, .05 } // Front
            sphere { <.45, .05, .25>, .05 } // Back
            texture {
                pigment { Gray10 }
                finish { phong .25    phong_size 5 }
            }
        }
        union {
            cylinder { <.45, .05, 0>, <.45, 1.6, 0>, .05 } // Leg
            cylinder { <0, 1.45, 0>, <.5, 1.45, 0>, .05 } // Center
            sphere { <.45, 1.6, 0>, .05 } // Top
            sphere { <.5, 1.45, 0>, .05 } // Side
            scale <1, 1, .5>
        }
    }

#declare Easel_A =
    union {
        object { HalfEasel_A }
        object { HalfEasel_A    scale <-1, 1, 1> }
        cylinder { <0, .05, 0>, <0, 1.7, 0>, 0.025 } // Center
        sphere { <0, 1.7, 0>, .025 } // Top
        box { <-.55, Pic_A_B, 0>, <.55, Pic_A_B + .02, -.1> }
        box { <-.55, Pic_A_B, -.1>, <.55, Pic_A_B + .04, -.11> }
        object { Picture_A }
        texture {
            pigment { PaleGreen }
            normal { bumps .1 scale .001 }
            finish {
                specular .75    roughness .001
                metallic .3    brilliance 1.6
                reflection .1
            }
        }
    }


// (C) Guillermo Sanz Romero
// Todos los derechos reservados.
// Si deseas utilizar la totalidad o parte de este fichero puedes hacerlo
//  mientras no sea con fines lucrativos.
// En caso de usarlo para publicidad, recopilaciones de software, inclusin
//  en revistas o alguna otra actividad que suponga una transaccin
//  remunerada (con cualquier tipo de bien, por lo que los trueques y los
//  premios de los concursos tambin quedan incluidos), debes ponerte en
//  contacto utilizando las direcciones de la cabezera para poder acordar las
//  condiciones que te permitan hacer dicho uso de los datos contenidos en
//  este fichero o los generados a partir de l, tanto descripciones de
//  imagenes como las imagenes en si, en cualquier formato y/o medio de
//  almacenamiento.
//--
// All rights reserved.
// If you want to use this file in is enterity or only parts of it you can do
//  it while it is a non-profitable purpose.
// In case of using it for advertisment, software recopilations, bunddling it
//  with magazines or another profitable transaction (any sort of profit, so
//  exchange and prizes won in contests are included), you must get in touch
//  with me through the addresses given above to reach an agreement about the
//  conditions to use the data here contained (this file) or build from it,
//  both new image descriptions and images, whatever the format and/or the
//  storage way.

// No dudes en escribirme si tienes alguna pregunta, tanto sobre la clusula
//  arriba expuesta como sobre el fichero de datos que describe las imgenes
//  y las imgenes en si.
// P.D.: los precios son razonables y el dinero esta destinado bsicamente
//  a mejorar mi ordenador y poder seguir creando ms imagenes.
//--
// Do not doubt to write me if you has any question, about the clausule 
//  written above or the descriptions and the images.
// P.S.: prices are reasonable and money is basically to improve my computer
//  so I can keep making more pictures.

// NOTA IMPORTANTE
//  Este es un extracto de la licencia completa (LICENSE.GSR), lee dicho
//  fichero para conocer todas las condiciones y clusulas.
//--
// IMPORTANT NOTE
//  This is an extract of the complete license (LICENSE.GSR), read that file
//  to know all the conditions and clausules.
