
/* Create a helix (actually, a cylinder bent along a helical path) */

/*
** The helix will start at <HelixMajorRadius, 0, 0> and extend along
** the positive Z axis with a left-handed screw. The helix is approximated
** by half-torii. This looks reasonable as long as HelixPitch remains
** small compared to HelixMajorRadius.
*/

/* Define the properties of the helix in the calling file */
/*
#declare HelixMajorRadius = 1
#declare HelixWireRadius = 0.15
#declare HelixPitch = 0.4
#declare HelixTurns = 6
*/

/* Error checking */
#ifndef (HelixMajorRadius)
#error "HelixMajorRadius not defined\n"
#end
#ifndef (HelixWireRadius)
#error "HelixWireRadius not defined\n"
#end
#ifndef (HelixPitch)
#error "HelixPitch not defined\n"
#end
#ifndef (HelixTurns)
#error "HelixTurns not defined\n"
#end

/* Computed values */
#declare HelixRatio = HelixPitch / (4 * HelixMajorRadius)
#declare ScaleRatio = sqrt(1 + HelixRatio * HelixRatio)
#declare HelixTwistAngle = degrees(atan2(HelixRatio,1))
#declare HelixTotalRadius = HelixMajorRadius + HelixWireRadius

#declare HelixTurnsInteger = floor(HelixTurns)
#declare HelixTurnsHalf = floor(2 * (HelixTurns - HelixTurnsInteger))
#declare HelixTurnsFractional = HelixTurns - HelixTurnsInteger - HelixTurnsHalf / 2

#declare HelixStartPoint = HelixMajorRadius * x
#declare HelixStartVector = -y
#declare HelixEndPoint = <HelixMajorRadius * cos(HelixTurns * 2 * pi),
               HelixMajorRadius * sin(HelixTurns * 2 * pi),
               (HelixTurnsInteger + 0.5*HelixTurnsHalf + 0.25 * (1 - cos(HelixTurnsFractional * 2 * pi))) * HelixPitch>
#declare HelixEndVector = <-sin(HelixTurns * 2 * pi), cos(HelixTurns * 2 * pi), 0>

#declare TorusMajorRadius = HelixMajorRadius * ScaleRatio
#declare TorusMinorRadius = HelixWireRadius
#declare TorusFraction = 0.5
#include "torus2.inc"

#declare HelixHalfTurn = object {
   HalfTorus    // Using this instead of the more general FractionTorus speeds up rendering
   scale <1, 1/ScaleRatio, 1>
   rotate HelixTwistAngle*y
   translate HelixPitch*z/4
}

#declare HelixFractionalTurn = intersection {
   object {HelixHalfTurn}
   box {
       <-HelixTotalRadius, -HelixTotalRadius, -HelixWireRadius>,
       <HelixTotalRadius, 0, 0.5 * HelixPitch + HelixWireRadius>
       rotate HelixTurnsFractional * 360 * z
   }
}

#declare HelixFullTurn = union {
   object {HelixHalfTurn}
   object {
      HelixHalfTurn
      rotate 180*z
      translate 0.5*HelixPitch*z
   }
}

#declare HelixIndex = 0
#declare HelixOffset = <0, 0, 0>

#declare Helix = union {
// Place whole turns first
#while (HelixIndex < HelixTurnsInteger)
   object {
      HelixFullTurn
      translate HelixOffset
   }
#declare HelixIndex = HelixIndex + 1
#declare HelixOffset = HelixOffset + HelixPitch * z
#end

#declare HelixRotateAngle = 0

// Place a half turn if needed
#if (HelixTurnsHalf)
   object {
      HelixHalfTurn
      translate HelixOffset
   }
#declare HelixOffset = HelixOffset + 0.5 * HelixPitch * z
#declare HelixRotateAngle = 180
#end

#if (HelixTurnsFractional > 0.001)
   object {
      HelixFractionalTurn
      rotate HelixRotateAngle * z
      translate HelixOffset
   }
#end   
}
