
camera
{
  location  <30.0 , 24.0 , 24.0>
  look_at   <0.0 , 1.5 , 0.0>
  angle 25
  focal_point <0.0, 1.5, 0.0>
  aperture 0.4
  blur_samples 4
}


light_source
{
  <600.0, 800.0, -300.0>
  color rgb<0.5, 0.5, 0.5>
  area_light 30 * x, 30 * z, 2, 2
  jitter
  adaptive 1
}

light_source
{
  <200.0, 800.0, 300.0>
  color rgb<0.5, 0.5, 0.5>
  area_light 30 * x, 30 * z, 2, 2
  jitter
  adaptive 1
}

background {
   rgb<1, 1, 1>
}

// The table top on which the whole demonstration takes place
plane {
   y, 0
   pigment {
      marble
      scale 2
      rotate 90 * y
      turbulence 1.5
      color_map {
         [0.0 rgb<0.15, 0.15, 0.21>]
         [1.0 rgb<0.20, 0.20, 0.26>]
      }
   }
   finish {
      diffuse 0.6
      ambient 0.4
      reflection 0.1
   }
}

#declare MouseTrapState = 0.3 + 0.2 * clock
union {
   object {
      #include "moustrap.inc"
      MouseTrap
   }
   object {
      #include "pingpong.inc"
      PingPongBall
      transform BallRandomize
      translate <3.45, 4.3, 1.95> + clock * <0.2, 1.7, 0.7>
   }
   object {
      #include "pingpong.inc"
      PingPongBall
      transform BallRandomize
      translate <0.2, 3.27, 4.5> + clock * <-0.4, 0.9, 0.7>
   }
   translate <-2.3, 0.0, -4.95>
}

object {
   #include "pingpong.inc"
   PingPongBall
   rotate -93 * y
   rotate degrees(0.5 / BallRadius) * x
   translate <-0.1, BallRadius, 6.8> + clock * <0.0, 0.0, 0.5>
}

#declare MouseTrapState = 0
union {
   object {
      #include "moustrap.inc"
      MouseTrap
   }
   object {
      #include "pingpong.inc"
      PingPongBall
      transform BallRandomize
      transform BallOffset2A
   }
   object {
      #include "pingpong.inc"
      PingPongBall
      transform BallRandomize
      transform BallOffset2B
   }
   rotate -8 * y
   translate <6, 0.0, -4.95>
}

#declare MouseTrapState = 0
object {
   #include "moustrap.inc"
   MouseTrap
   transform FlipOver
   rotate 209 * y
   translate <-6.5, 0.0, -4.95>
}

#declare MouseTrapState = 0.9 + 0.2 * clock
object {
   #include "moustrap.inc"
   MouseTrap
   rotate -(6 + 6 * clock) * x
   rotate (3 + 3.5 * clock) * z
   translate <-2.3, 0.0, -22>
}

object {
   #include "pingpong.inc"
   PingPongBall
   transform BallRandomize
   rotate 20 * y
   rotate 30 * clock * x
   rotate -20 * y
   translate <2.0 + 0.2 * clock, BallRadius + abs(1.3 - 2 * clock), -9 + 0.3 * clock>
}

#declare MouseTrapState = 1
object {
   #include "moustrap.inc"
   MouseTrap
   rotate 27 * y
   translate <3.1, 0.0, 10>
}

#declare MouseTrapState = 0
union {
   object {
      #include "moustrap.inc"
      MouseTrap
   }
   object {
      #include "pingpong.inc"
      PingPongBall
      transform BallRandomize
      transform BallOffset1A
   }
   object {
      #include "pingpong.inc"
      PingPongBall
      transform BallRandomize
      transform BallOffset1B
   }
   rotate 5 * y
   translate <-16, 0.0, -4.2>
}

#declare MouseTrapState = 1
object {
   #include "moustrap.inc"
   MouseTrap
   rotate 2 * y
   translate <-23, 0.0, -5.1>
}

#declare MouseTrapState = 0
union {
   object {
      #include "moustrap.inc"
      MouseTrap
   }
   object {
      #include "pingpong.inc"
      PingPongBall
      transform BallRandomize
      transform BallOffset2A
   }
   object {
      #include "pingpong.inc"
      PingPongBall
      transform BallRandomize
      transform BallOffset2B
   }
   rotate -5 * y
   translate <-2.7, 0.0, 10.2>
}

#declare MouseTrapState = 0
union {
   object {
      #include "moustrap.inc"
      MouseTrap
   }
   object {
      #include "pingpong.inc"
      PingPongBall
      transform BallRandomize
      transform BallOffset2A
   }
   object {
      #include "pingpong.inc"
      PingPongBall
      transform BallRandomize
      transform BallOffset2B
   }
   rotate -5 * y
   translate <-8.7, 0.0, -19.2>
}

#declare MouseTrapState = 0
union {
   object {
      #include "moustrap.inc"
      MouseTrap
   }
   object {
      #include "pingpong.inc"
      PingPongBall
      transform BallRandomize
      transform BallOffset1A
   }
   object {
      #include "pingpong.inc"
      PingPongBall
      transform BallRandomize
      transform BallOffset1B
   }
   rotate 6 * y
   translate <-16.7, 0.0, -20.3>
}

#declare MouseTrapState = 1
object {
   #include "moustrap.inc"
   MouseTrap
   transform FlipOver
   rotate 70 * y
   translate <-18.1, 0.0, -8.1>
}

object {
   #include "pingpong.inc"
   PingPongBall
   transform BallRandomize
   translate <13.8, 0.0, -0.75>
}
