untrusted comment: signature from openbsd 6.2 base secret key
RWRVWzAMgtyg7ouX7RMMtezOF8nL2ZUE/h6FSwnmCXrpdEE2mMA+lGP3OVHVZm1z5k0YAUGMN5Ro5VeEKTqF/OxcZva9D7FpRww=

OpenBSD 6.2 errata 015, June 13, 2018:

DSA and ECDSA signature generation can potentially leak secret information
to a timing side-channel attack.

Apply by doing:
    signify -Vep /etc/signify/openbsd-62-base.pub -x 015_libcryto.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libcrypto:
	cd /usr/src/lib/libcrypto
	make obj
	make
	make install

Index: lib/libcrypto/dsa/dsa_ossl.c
===================================================================
RCS file: /cvs/src/lib/libcrypto/dsa/dsa_ossl.c,v
diff -u -p -r1.30 -r1.30.6.1
--- lib/libcrypto/dsa/dsa_ossl.c	29 Jan 2017 17:49:22 -0000	1.30
+++ lib/libcrypto/dsa/dsa_ossl.c	13 Jun 2018 15:07:19 -0000	1.30.6.1
@@ -142,11 +142,8 @@ redo:
 	/* Compute  s = inv(k) (m + xr) mod q */
 	if (!BN_mod_mul(&xr, dsa->priv_key, r, dsa->q, ctx))	/* s = xr */
 		goto err;
-	if (!BN_add(s, &xr, &m))				/* s = m + xr */
+	if (!BN_mod_add(s, &xr, &m, dsa->q, ctx))		/* s = m + xr */
 		goto err;
-	if (BN_cmp(s, dsa->q) > 0)
-		if (!BN_sub(s, s, dsa->q))
-			goto err;
 	if (!BN_mod_mul(s, s, kinv, dsa->q, ctx))
 		goto err;
 
Index: lib/libcrypto/ecdsa/ecs_ossl.c
===================================================================
RCS file: /cvs/src/lib/libcrypto/ecdsa/ecs_ossl.c,v
diff -u -p -r1.9 -r1.9.6.1
--- lib/libcrypto/ecdsa/ecs_ossl.c	29 Jan 2017 17:49:23 -0000	1.9
+++ lib/libcrypto/ecdsa/ecs_ossl.c	13 Jun 2018 15:07:19 -0000	1.9.6.1
@@ -273,7 +273,7 @@ ecdsa_do_sign(const unsigned char *dgst,
 			ECDSAerror(ERR_R_BN_LIB);
 			goto err;
 		}
-		if (!BN_mod_add_quick(s, tmp, m, order)) {
+		if (!BN_mod_add(s, tmp, m, order, ctx)) {
 			ECDSAerror(ERR_R_BN_LIB);
 			goto err;
 		}
