<?php
/**
 * NotificationRulesService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * NotificationRulesService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class NotificationRulesService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation createNotificationRule
     *
     * Add a notification rule
     *
     * @param  \InfluxDB2\Model\NotificationRule $notification_rule Notification rule to create (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\NotificationRule|\InfluxDB2\Model\Error
     */
    public function createNotificationRule($notification_rule)
    {
        list($response) = $this->createNotificationRuleWithHttpInfo($notification_rule);
        return $response;
    }

    /**
     * Operation createNotificationRuleWithHttpInfo
     *
     * Add a notification rule
     *
     * @param  \InfluxDB2\Model\NotificationRule $notification_rule Notification rule to create (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\NotificationRule|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createNotificationRuleWithHttpInfo($notification_rule)
    {
        $request = $this->createNotificationRuleRequest($notification_rule);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\NotificationRule';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'createNotificationRule'
     *
     * @param  \InfluxDB2\Model\NotificationRule $notification_rule Notification rule to create (required)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function createNotificationRuleRequest($notification_rule)
    {
        // verify the required parameter 'notification_rule' is set
        if ($notification_rule === null || (is_array($notification_rule) && count($notification_rule) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $notification_rule when calling createNotificationRule'
            );
        }

        $resourcePath = '/api/v2/notificationRules';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;
        if (isset($notification_rule)) {
            $_tempBody = $notification_rule;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteNotificationRulesID
     *
     * Delete a notification rule
     *
     * @param  string $rule_id The notification rule ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteNotificationRulesID($rule_id, $zap_trace_span = null)
    {
        $this->deleteNotificationRulesIDWithHttpInfo($rule_id, $zap_trace_span);
    }

    /**
     * Operation deleteNotificationRulesIDWithHttpInfo
     *
     * Delete a notification rule
     *
     * @param  string $rule_id The notification rule ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteNotificationRulesIDWithHttpInfo($rule_id, $zap_trace_span = null)
    {
        $request = $this->deleteNotificationRulesIDRequest($rule_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteNotificationRulesID'
     *
     * @param  string $rule_id The notification rule ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteNotificationRulesIDRequest($rule_id, $zap_trace_span = null)
    {
        // verify the required parameter 'rule_id' is set
        if ($rule_id === null || (is_array($rule_id) && count($rule_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $rule_id when calling deleteNotificationRulesID'
            );
        }

        $resourcePath = '/api/v2/notificationRules/{ruleID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($rule_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ruleID' . '}',
                ObjectSerializer::toPathValue($rule_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteNotificationRulesIDLabelsID
     *
     * Delete label from a notification rule
     *
     * @param  string $rule_id The notification rule ID. (required)
     * @param  string $label_id The ID of the label to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteNotificationRulesIDLabelsID($rule_id, $label_id, $zap_trace_span = null)
    {
        $this->deleteNotificationRulesIDLabelsIDWithHttpInfo($rule_id, $label_id, $zap_trace_span);
    }

    /**
     * Operation deleteNotificationRulesIDLabelsIDWithHttpInfo
     *
     * Delete label from a notification rule
     *
     * @param  string $rule_id The notification rule ID. (required)
     * @param  string $label_id The ID of the label to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteNotificationRulesIDLabelsIDWithHttpInfo($rule_id, $label_id, $zap_trace_span = null)
    {
        $request = $this->deleteNotificationRulesIDLabelsIDRequest($rule_id, $label_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteNotificationRulesIDLabelsID'
     *
     * @param  string $rule_id The notification rule ID. (required)
     * @param  string $label_id The ID of the label to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteNotificationRulesIDLabelsIDRequest($rule_id, $label_id, $zap_trace_span = null)
    {
        // verify the required parameter 'rule_id' is set
        if ($rule_id === null || (is_array($rule_id) && count($rule_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $rule_id when calling deleteNotificationRulesIDLabelsID'
            );
        }
        // verify the required parameter 'label_id' is set
        if ($label_id === null || (is_array($label_id) && count($label_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $label_id when calling deleteNotificationRulesIDLabelsID'
            );
        }

        $resourcePath = '/api/v2/notificationRules/{ruleID}/labels/{labelID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($rule_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ruleID' . '}',
                ObjectSerializer::toPathValue($rule_id),
                $resourcePath
            );
        }
        // path params
        if ($label_id !== null) {
            $resourcePath = str_replace(
                '{' . 'labelID' . '}',
                ObjectSerializer::toPathValue($label_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getNotificationRules
     *
     * List all notification rules
     *
     * @param  string $org_id Only show notification rules that belong to a specific organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     * @param  string $check_id Only show notifications that belong to the specific check ID. (optional)
     * @param  string $tag Only return notification rules that &quot;would match&quot; statuses which contain the tag key value pairs provided. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\NotificationRules|\InfluxDB2\Model\Error
     */
    public function getNotificationRules($org_id, $zap_trace_span = null, $offset = null, $limit = 20, $check_id = null, $tag = null)
    {
        list($response) = $this->getNotificationRulesWithHttpInfo($org_id, $zap_trace_span, $offset, $limit, $check_id, $tag);
        return $response;
    }

    /**
     * Operation getNotificationRulesWithHttpInfo
     *
     * List all notification rules
     *
     * @param  string $org_id Only show notification rules that belong to a specific organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     * @param  string $check_id Only show notifications that belong to the specific check ID. (optional)
     * @param  string $tag Only return notification rules that &quot;would match&quot; statuses which contain the tag key value pairs provided. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\NotificationRules|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getNotificationRulesWithHttpInfo($org_id, $zap_trace_span = null, $offset = null, $limit = 20, $check_id = null, $tag = null)
    {
        $request = $this->getNotificationRulesRequest($org_id, $zap_trace_span, $offset, $limit, $check_id, $tag);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\NotificationRules';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getNotificationRules'
     *
     * @param  string $org_id Only show notification rules that belong to a specific organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     * @param  string $check_id Only show notifications that belong to the specific check ID. (optional)
     * @param  string $tag Only return notification rules that &quot;would match&quot; statuses which contain the tag key value pairs provided. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getNotificationRulesRequest($org_id, $zap_trace_span = null, $offset = null, $limit = 20, $check_id = null, $tag = null)
    {
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getNotificationRules'
            );
        }
        if ($offset !== null && $offset < 0) {
            throw new \InvalidArgumentException('invalid value for "$offset" when calling NotificationRulesService.getNotificationRules, must be bigger than or equal to 0.');
        }

        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling NotificationRulesService.getNotificationRules, must be smaller than or equal to 100.');
        }
        if ($limit !== null && $limit < 1) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling NotificationRulesService.getNotificationRules, must be bigger than or equal to 1.');
        }

        if ($tag !== null && !preg_match("/^[a-zA-Z0-9_]+:[a-zA-Z0-9_]+$/", $tag)) {
            throw new \InvalidArgumentException("invalid value for \"tag\" when calling NotificationRulesService.getNotificationRules, must conform to the pattern /^[a-zA-Z0-9_]+:[a-zA-Z0-9_]+$/.");
        }


        $resourcePath = '/api/v2/notificationRules';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($offset !== null) {
            $queryParams['offset'] = ObjectSerializer::toQueryValue($offset);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }
        // query params
        if ($check_id !== null) {
            $queryParams['checkID'] = ObjectSerializer::toQueryValue($check_id);
        }
        // query params
        if ($tag !== null) {
            $queryParams['tag'] = ObjectSerializer::toQueryValue($tag);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getNotificationRulesID
     *
     * Retrieve a notification rule
     *
     * @param  string $rule_id The notification rule ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\NotificationRule|\InfluxDB2\Model\Error
     */
    public function getNotificationRulesID($rule_id, $zap_trace_span = null)
    {
        list($response) = $this->getNotificationRulesIDWithHttpInfo($rule_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getNotificationRulesIDWithHttpInfo
     *
     * Retrieve a notification rule
     *
     * @param  string $rule_id The notification rule ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\NotificationRule|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getNotificationRulesIDWithHttpInfo($rule_id, $zap_trace_span = null)
    {
        $request = $this->getNotificationRulesIDRequest($rule_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\NotificationRule';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getNotificationRulesID'
     *
     * @param  string $rule_id The notification rule ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getNotificationRulesIDRequest($rule_id, $zap_trace_span = null)
    {
        // verify the required parameter 'rule_id' is set
        if ($rule_id === null || (is_array($rule_id) && count($rule_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $rule_id when calling getNotificationRulesID'
            );
        }

        $resourcePath = '/api/v2/notificationRules/{ruleID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($rule_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ruleID' . '}',
                ObjectSerializer::toPathValue($rule_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getNotificationRulesIDLabels
     *
     * List all labels for a notification rule
     *
     * @param  string $rule_id The notification rule ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\LabelsResponse|\InfluxDB2\Model\Error
     */
    public function getNotificationRulesIDLabels($rule_id, $zap_trace_span = null)
    {
        list($response) = $this->getNotificationRulesIDLabelsWithHttpInfo($rule_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getNotificationRulesIDLabelsWithHttpInfo
     *
     * List all labels for a notification rule
     *
     * @param  string $rule_id The notification rule ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\LabelsResponse|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getNotificationRulesIDLabelsWithHttpInfo($rule_id, $zap_trace_span = null)
    {
        $request = $this->getNotificationRulesIDLabelsRequest($rule_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\LabelsResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getNotificationRulesIDLabels'
     *
     * @param  string $rule_id The notification rule ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getNotificationRulesIDLabelsRequest($rule_id, $zap_trace_span = null)
    {
        // verify the required parameter 'rule_id' is set
        if ($rule_id === null || (is_array($rule_id) && count($rule_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $rule_id when calling getNotificationRulesIDLabels'
            );
        }

        $resourcePath = '/api/v2/notificationRules/{ruleID}/labels';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($rule_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ruleID' . '}',
                ObjectSerializer::toPathValue($rule_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation patchNotificationRulesID
     *
     * Update a notification rule
     *
     * @param  string $rule_id The notification rule ID. (required)
     * @param  \InfluxDB2\Model\NotificationRuleUpdate $notification_rule_update Notification rule update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\NotificationRule|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function patchNotificationRulesID($rule_id, $notification_rule_update, $zap_trace_span = null)
    {
        list($response) = $this->patchNotificationRulesIDWithHttpInfo($rule_id, $notification_rule_update, $zap_trace_span);
        return $response;
    }

    /**
     * Operation patchNotificationRulesIDWithHttpInfo
     *
     * Update a notification rule
     *
     * @param  string $rule_id The notification rule ID. (required)
     * @param  \InfluxDB2\Model\NotificationRuleUpdate $notification_rule_update Notification rule update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\NotificationRule|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchNotificationRulesIDWithHttpInfo($rule_id, $notification_rule_update, $zap_trace_span = null)
    {
        $request = $this->patchNotificationRulesIDRequest($rule_id, $notification_rule_update, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\NotificationRule';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'patchNotificationRulesID'
     *
     * @param  string $rule_id The notification rule ID. (required)
     * @param  \InfluxDB2\Model\NotificationRuleUpdate $notification_rule_update Notification rule update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function patchNotificationRulesIDRequest($rule_id, $notification_rule_update, $zap_trace_span = null)
    {
        // verify the required parameter 'rule_id' is set
        if ($rule_id === null || (is_array($rule_id) && count($rule_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $rule_id when calling patchNotificationRulesID'
            );
        }
        // verify the required parameter 'notification_rule_update' is set
        if ($notification_rule_update === null || (is_array($notification_rule_update) && count($notification_rule_update) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $notification_rule_update when calling patchNotificationRulesID'
            );
        }

        $resourcePath = '/api/v2/notificationRules/{ruleID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($rule_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ruleID' . '}',
                ObjectSerializer::toPathValue($rule_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($notification_rule_update)) {
            $_tempBody = $notification_rule_update;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PATCH', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postNotificationRuleIDLabels
     *
     * Add a label to a notification rule
     *
     * @param  string $rule_id The notification rule ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping Label to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\LabelResponse|\InfluxDB2\Model\Error
     */
    public function postNotificationRuleIDLabels($rule_id, $label_mapping, $zap_trace_span = null)
    {
        list($response) = $this->postNotificationRuleIDLabelsWithHttpInfo($rule_id, $label_mapping, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postNotificationRuleIDLabelsWithHttpInfo
     *
     * Add a label to a notification rule
     *
     * @param  string $rule_id The notification rule ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping Label to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\LabelResponse|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postNotificationRuleIDLabelsWithHttpInfo($rule_id, $label_mapping, $zap_trace_span = null)
    {
        $request = $this->postNotificationRuleIDLabelsRequest($rule_id, $label_mapping, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\LabelResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postNotificationRuleIDLabels'
     *
     * @param  string $rule_id The notification rule ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping Label to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postNotificationRuleIDLabelsRequest($rule_id, $label_mapping, $zap_trace_span = null)
    {
        // verify the required parameter 'rule_id' is set
        if ($rule_id === null || (is_array($rule_id) && count($rule_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $rule_id when calling postNotificationRuleIDLabels'
            );
        }
        // verify the required parameter 'label_mapping' is set
        if ($label_mapping === null || (is_array($label_mapping) && count($label_mapping) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $label_mapping when calling postNotificationRuleIDLabels'
            );
        }

        $resourcePath = '/api/v2/notificationRules/{ruleID}/labels';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($rule_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ruleID' . '}',
                ObjectSerializer::toPathValue($rule_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($label_mapping)) {
            $_tempBody = $label_mapping;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation putNotificationRulesID
     *
     * Update a notification rule
     *
     * @param  string $rule_id The notification rule ID. (required)
     * @param  \InfluxDB2\Model\NotificationRule $notification_rule Notification rule update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\NotificationRule|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function putNotificationRulesID($rule_id, $notification_rule, $zap_trace_span = null)
    {
        list($response) = $this->putNotificationRulesIDWithHttpInfo($rule_id, $notification_rule, $zap_trace_span);
        return $response;
    }

    /**
     * Operation putNotificationRulesIDWithHttpInfo
     *
     * Update a notification rule
     *
     * @param  string $rule_id The notification rule ID. (required)
     * @param  \InfluxDB2\Model\NotificationRule $notification_rule Notification rule update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\NotificationRule|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function putNotificationRulesIDWithHttpInfo($rule_id, $notification_rule, $zap_trace_span = null)
    {
        $request = $this->putNotificationRulesIDRequest($rule_id, $notification_rule, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\NotificationRule';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'putNotificationRulesID'
     *
     * @param  string $rule_id The notification rule ID. (required)
     * @param  \InfluxDB2\Model\NotificationRule $notification_rule Notification rule update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function putNotificationRulesIDRequest($rule_id, $notification_rule, $zap_trace_span = null)
    {
        // verify the required parameter 'rule_id' is set
        if ($rule_id === null || (is_array($rule_id) && count($rule_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $rule_id when calling putNotificationRulesID'
            );
        }
        // verify the required parameter 'notification_rule' is set
        if ($notification_rule === null || (is_array($notification_rule) && count($notification_rule) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $notification_rule when calling putNotificationRulesID'
            );
        }

        $resourcePath = '/api/v2/notificationRules/{ruleID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($rule_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ruleID' . '}',
                ObjectSerializer::toPathValue($rule_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($notification_rule)) {
            $_tempBody = $notification_rule;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PUT', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
