/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractConstrainer;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.RotationDirection;
import org.jhotdraw.draw.TranslationDirection;

public class GridConstrainer
extends AbstractConstrainer {
    private double width;
    private double height;
    private double theta;
    private boolean isVisible;
    private static Color minorColor = new Color(0xEBEBEB);
    private static Color majorColor = new Color(0xCACACA);
    private int majorGridSpacing = 5;

    public GridConstrainer() {
        this(1.0, 1.0, 0.0, false);
    }

    public GridConstrainer(double d, double d2) {
        this(d, d2, 0.39269908169872414, true);
    }

    public GridConstrainer(double d, double d2, boolean bl) {
        this(d, d2, 0.39269908169872414, bl);
    }

    public GridConstrainer(double d, double d2, double d3, boolean bl) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("Width or height is <= 0");
        }
        this.width = d;
        this.height = d2;
        this.theta = d3;
        this.isVisible = bl;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getTheta() {
        return this.theta;
    }

    public void setWidth(double d) {
        double d2 = this.width;
        this.width = d;
        this.firePropertyChange("width", d2, d);
        this.fireStateChanged();
    }

    public void setHeight(double d) {
        double d2 = this.height;
        this.height = d;
        this.firePropertyChange("height", d2, d);
        this.fireStateChanged();
    }

    public void setTheta(double d) {
        double d2 = this.theta;
        this.theta = d;
        this.firePropertyChange("theta", d2, d);
        this.fireStateChanged();
    }

    @Override
    public Point2D.Double constrainPoint(Point2D.Double double_) {
        double_.x = (double)Math.round(double_.x / this.width) * this.width;
        double_.y = (double)Math.round(double_.y / this.height) * this.height;
        return double_;
    }

    protected Point2D.Double constrainPoint(Point2D.Double double_, TranslationDirection translationDirection) {
        Point2D.Double double_2 = this.constrainPoint((Point2D.Double)double_.clone());
        switch (translationDirection) {
            case NORTH: 
            case NORTH_WEST: 
            case NORTH_EAST: {
                if (double_2.y < double_.y) {
                    double_.y = double_2.y;
                    break;
                }
                if (!(double_2.y > double_.y)) break;
                double_.y = double_2.y - this.height;
                break;
            }
            case SOUTH: 
            case SOUTH_WEST: 
            case SOUTH_EAST: {
                if (double_2.y < double_.y) {
                    double_.y = double_2.y + this.height;
                    break;
                }
                if (!(double_2.y > double_.y)) break;
                double_.y = double_2.y;
            }
        }
        switch (translationDirection) {
            case NORTH_WEST: 
            case SOUTH_WEST: 
            case WEST: {
                if (double_2.x < double_.x) {
                    double_.x = double_2.x;
                    break;
                }
                if (!(double_2.x > double_.x)) break;
                double_.x = double_2.x - this.width;
                break;
            }
            case NORTH_EAST: 
            case SOUTH_EAST: 
            case EAST: {
                if (double_2.x < double_.x) {
                    double_.x = double_2.x + this.width;
                    break;
                }
                if (!(double_2.x > double_.x)) break;
                double_.x = double_2.x;
            }
        }
        return double_;
    }

    @Override
    public Point2D.Double translatePoint(Point2D.Double double_, TranslationDirection translationDirection) {
        Point2D.Double double_2 = this.constrainPoint((Point2D.Double)double_.clone());
        switch (translationDirection) {
            case NORTH: 
            case NORTH_WEST: 
            case NORTH_EAST: {
                double_.y = double_2.y - this.height;
                break;
            }
            case SOUTH: 
            case SOUTH_WEST: 
            case SOUTH_EAST: {
                double_.y = double_2.y + this.height;
            }
        }
        switch (translationDirection) {
            case NORTH_WEST: 
            case SOUTH_WEST: 
            case WEST: {
                double_.x = double_2.x - this.width;
                break;
            }
            case NORTH_EAST: 
            case SOUTH_EAST: 
            case EAST: {
                double_.x = double_2.x + this.width;
            }
        }
        return double_;
    }

    @Override
    public Rectangle2D.Double constrainRectangle(Rectangle2D.Double double_) {
        Point2D.Double double_2 = this.constrainPoint(new Point2D.Double(double_.x, double_.y));
        Point2D.Double double_3 = this.constrainPoint(new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
        double_.x = Math.abs(double_2.x - double_.x) < Math.abs(double_3.x - double_.x - double_.width) ? double_2.x : double_3.x - double_.width;
        double_.y = Math.abs(double_2.y - double_.y) < Math.abs(double_3.y - double_.y - double_.height) ? double_2.y : double_3.y - double_.height;
        return double_;
    }

    protected Rectangle2D.Double constrainRectangle(Rectangle2D.Double double_, TranslationDirection translationDirection) {
        Point2D.Double double_2 = new Point2D.Double(double_.x, double_.y);
        switch (translationDirection) {
            case NORTH: 
            case NORTH_WEST: 
            case WEST: {
                this.constrainPoint(double_2, translationDirection);
                break;
            }
            case NORTH_EAST: 
            case EAST: {
                double_2.x += double_.width;
                this.constrainPoint(double_2, translationDirection);
                double_2.x -= double_.width;
                break;
            }
            case SOUTH: 
            case SOUTH_WEST: {
                double_2.y += double_.height;
                this.constrainPoint(double_2, translationDirection);
                double_2.y -= double_.height;
                break;
            }
            case SOUTH_EAST: {
                double_2.y += double_.height;
                double_2.x += double_.width;
                this.constrainPoint(double_2, translationDirection);
                double_2.y -= double_.height;
                double_2.x -= double_.width;
            }
        }
        double_.x = double_2.x;
        double_.y = double_2.y;
        return double_;
    }

    @Override
    public Rectangle2D.Double translateRectangle(Rectangle2D.Double double_, TranslationDirection translationDirection) {
        double d = double_.x;
        double d2 = double_.y;
        this.constrainRectangle(double_, translationDirection);
        switch (translationDirection) {
            case NORTH: 
            case NORTH_WEST: 
            case NORTH_EAST: {
                if (d2 != double_.y) break;
                double_.y -= this.height;
                break;
            }
            case SOUTH: 
            case SOUTH_WEST: 
            case SOUTH_EAST: {
                if (d2 != double_.y) break;
                double_.y += this.height;
            }
        }
        switch (translationDirection) {
            case NORTH_WEST: 
            case SOUTH_WEST: 
            case WEST: {
                if (d != double_.x) break;
                double_.x -= this.width;
                break;
            }
            case NORTH_EAST: 
            case SOUTH_EAST: 
            case EAST: {
                if (d != double_.x) break;
                double_.x += this.width;
            }
        }
        return double_;
    }

    public String toString() {
        return super.toString() + "[" + this.width + "," + this.height + "]";
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible;
        this.isVisible = bl;
        this.firePropertyChange("visible", bl2, bl);
        this.fireStateChanged();
    }

    public int getMajorGridSpacing() {
        return this.majorGridSpacing;
    }

    public void setMajorGridSpacing(int n) {
        int n2 = this.majorGridSpacing;
        this.majorGridSpacing = n;
        this.firePropertyChange("majorGridSpacing", n2, n);
        this.fireStateChanged();
    }

    @Override
    public void draw(Graphics2D graphics2D, DrawingView drawingView) {
        block7: {
            int n;
            int n2;
            Point2D.Double double_;
            Point2D.Double double_2;
            Point2D.Double double_3;
            Rectangle2D.Double double_4;
            Rectangle rectangle;
            AffineTransform affineTransform;
            block8: {
                if (!this.isVisible) break block7;
                affineTransform = drawingView.getDrawingToViewTransform();
                rectangle = graphics2D.getClipBounds();
                double_4 = drawingView.viewToDrawing(rectangle);
                double_3 = this.constrainPoint(new Point2D.Double(double_4.x, double_4.y));
                double_2 = new Point2D.Double();
                double_ = new Point2D.Double();
                if (this.width * drawingView.getScaleFactor() > 2.0) {
                    graphics2D.setColor(minorColor);
                    n2 = (int)((double_3.x + double_4.width) / this.width) + 1;
                    for (n = (int)(double_3.x / this.width); n <= n2; ++n) {
                        graphics2D.setColor(n % this.majorGridSpacing == 0 ? majorColor : minorColor);
                        double_2.x = this.width * (double)n;
                        affineTransform.transform(double_2, double_);
                        graphics2D.drawLine((int)double_.x, rectangle.y, (int)double_.x, rectangle.y + rectangle.height);
                    }
                } else if (this.width * (double)this.majorGridSpacing * drawingView.getScaleFactor() > 2.0) {
                    graphics2D.setColor(majorColor);
                    n2 = (int)((double_3.x + double_4.width) / this.width) + 1;
                    for (n = (int)(double_3.x / this.width); n <= n2; ++n) {
                        if (n % this.majorGridSpacing != 0) continue;
                        double_2.x = this.width * (double)n;
                        affineTransform.transform(double_2, double_);
                        graphics2D.drawLine((int)double_.x, rectangle.y, (int)double_.x, rectangle.y + rectangle.height);
                    }
                }
                if (!(this.height * drawingView.getScaleFactor() > 2.0)) break block8;
                graphics2D.setColor(minorColor);
                n2 = (int)((double_3.y + double_4.height) / this.height) + 1;
                for (n = (int)(double_3.y / this.height); n <= n2; ++n) {
                    graphics2D.setColor(n % this.majorGridSpacing == 0 ? majorColor : minorColor);
                    double_2.y = this.height * (double)n;
                    affineTransform.transform(double_2, double_);
                    graphics2D.drawLine(rectangle.x, (int)double_.y, rectangle.x + rectangle.width, (int)double_.y);
                }
                break block7;
            }
            if (!(this.height * (double)this.majorGridSpacing * drawingView.getScaleFactor() > 2.0)) break block7;
            graphics2D.setColor(majorColor);
            n2 = (int)((double_3.y + double_4.height) / this.height) + 1;
            for (n = (int)(double_3.y / this.height); n <= n2; ++n) {
                if (n % this.majorGridSpacing != 0) continue;
                double_2.y = this.height * (double)n;
                affineTransform.transform(double_2, double_);
                graphics2D.drawLine(rectangle.x, (int)double_.y, rectangle.x + rectangle.width, (int)double_.y);
            }
        }
    }

    @Override
    public double constrainAngle(double d) {
        if (this.theta == 0.0) {
            return d;
        }
        double d2 = Math.round(d / this.theta);
        return this.theta * d2;
    }

    @Override
    public double rotateAngle(double d, RotationDirection rotationDirection) {
        if (rotationDirection == null) {
            throw new IllegalArgumentException("dir must not be null");
        }
        d = this.constrainAngle(d);
        switch (rotationDirection) {
            case CLOCKWISE: {
                d += this.theta;
                break;
            }
            default: {
                d -= this.theta;
            }
        }
        return d;
    }
}

