/*
 * Decompiled with CFR 0.152.
 */
package dafny;

import dafny.DafnySet;
import dafny.Helpers;
import dafny.Tuple2;
import dafny.TypeDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class DafnyMap<K, V> {
    private Map<K, V> innerMap;

    public DafnyMap() {
        this.innerMap = new HashMap();
    }

    private DafnyMap(HashMap<K, V> innerMap) {
        this.innerMap = innerMap;
    }

    public DafnyMap(Map<K, V> m) {
        assert (m != null) : "Precondition Violation";
        this.innerMap = new HashMap();
        m.forEach((k, v) -> this.innerMap.put(k, v));
    }

    public static <K, V> DafnyMap<K, V> empty() {
        return new DafnyMap<K, V>();
    }

    public static <K, V> DafnyMap<K, V> fromElements(Tuple2<K, V> ... pairs) {
        DafnyMap<K, V> result = new DafnyMap<K, V>();
        for (Tuple2<K, V> pair : pairs) {
            result.innerMap.put(pair.dtor__0(), pair.dtor__1());
        }
        return result;
    }

    public static <K, V> TypeDescriptor<DafnyMap<? extends K, ? extends V>> _typeDescriptor(TypeDescriptor<K> keyType, TypeDescriptor<V> valueType) {
        return TypeDescriptor.referenceWithDefault(DafnyMap.class, DafnyMap.empty());
    }

    public boolean contains(Object t) {
        return this.innerMap.containsKey(t);
    }

    public static <K, V> DafnyMap<K, V> update(DafnyMap<? extends K, ? extends V> th, K k, V v) {
        HashMap<K, V> copy = new HashMap<K, V>(th.innerMap);
        copy.put(k, v);
        DafnyMap<K, V> r = new DafnyMap<K, V>();
        r.innerMap = copy;
        return r;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DafnyMap o = (DafnyMap)obj;
        return this.innerMap.equals(o.innerMap);
    }

    public int hashCode() {
        return this.innerMap.hashCode();
    }

    public String toString() {
        String s = "map[";
        String sep = "";
        for (Map.Entry<K, V> entry : this.innerMap.entrySet()) {
            s = s + sep + Helpers.toString(entry.getKey()) + " := " + Helpers.toString(entry.getValue());
            sep = ", ";
        }
        return s + "]";
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.innerMap.forEach(action);
    }

    public static <K, V> DafnyMap<? extends K, ? extends V> merge(DafnyMap<? extends K, ? extends V> th, DafnyMap<? extends K, ? extends V> other) {
        assert (th != null) : "Precondition Violation";
        assert (other != null) : "Precondition Violation";
        if (th.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return th;
        }
        HashMap m = new HashMap(other.innerMap);
        th.forEach((k, v) -> {
            if (!m.containsKey(k)) {
                m.put(k, v);
            }
        });
        return new DafnyMap<K, V>(m);
    }

    public static <K, V> DafnyMap<? extends K, ? extends V> subtract(DafnyMap<? extends K, ? extends V> th, DafnySet<? extends K> keys) {
        assert (th != null) : "Precondition Violation";
        assert (keys != null) : "Precondition Violation";
        if (th.isEmpty() || keys.isEmpty()) {
            return th;
        }
        HashMap<K, V> m = new HashMap<K, V>(th.innerMap);
        for (K k : keys.Elements()) {
            m.remove(k);
        }
        return new DafnyMap<K, V>(m);
    }

    public int size() {
        return this.innerMap.size();
    }

    public int cardinalityInt() {
        return this.size();
    }

    public boolean isEmpty() {
        return this.innerMap.isEmpty();
    }

    public V get(Object key) {
        return this.innerMap.get(key);
    }

    public DafnySet<K> keySet() {
        return new DafnySet<K>(this.innerMap.keySet());
    }

    public DafnySet<V> valueSet() {
        return new DafnySet<V>(this.innerMap.values());
    }

    public <KK, VV> DafnySet<? extends Tuple2<KK, VV>> entrySet() {
        ArrayList<Tuple2<K, V>> list = new ArrayList<Tuple2<K, V>>();
        for (Map.Entry<K, V> entry : this.innerMap.entrySet()) {
            list.add(new Tuple2<K, V>(entry.getKey(), entry.getValue()));
        }
        return new DafnySet(list);
    }
}

