/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.memorycontainer.memory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.action.memorycontainer.memory.FactSearchResult;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.memorycontainer.MemoryDecision;
import org.opensearch.ml.common.memorycontainer.MemoryDecisionRequest;
import org.opensearch.ml.common.memorycontainer.MemoryStorageConfig;
import org.opensearch.ml.common.output.MLOutput;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.transport.MLTaskResponse;
import org.opensearch.ml.common.transport.memorycontainer.memory.MessageInput;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskAction;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskRequest;
import org.opensearch.transport.client.Client;

public class MemoryProcessingService {
    @Generated
    private static final Logger log = LogManager.getLogger(MemoryProcessingService.class);
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;

    public MemoryProcessingService(Client client, NamedXContentRegistry xContentRegistry) {
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    public void extractFactsFromConversation(List<MessageInput> messages, MemoryStorageConfig storageConfig, ActionListener<List<String>> listener) {
        if (storageConfig == null || storageConfig.getLlmModelId() == null) {
            listener.onResponse(new ArrayList());
            return;
        }
        String llmModelId = storageConfig.getLlmModelId();
        HashMap<String, String> stringParameters = new HashMap<String, String>();
        stringParameters.put("system_prompt", "<system_prompt>\n<role>Personal Information Organizer</role>\n<objective>Extract and organize personal information shared within conversations.</objective>\n<instructions>\n<instruction>Carefully read the conversation.</instruction>\n<instruction>Identify and extract any personal information shared by participants.</instruction>\n<instruction>Focus on details that help build a profile of the person, including but not limited to:\n<include_list>\n<item>Names and relationships</item>\n<item>Professional information (job, company, role, responsibilities)</item>\n<item>Personal interests and hobbies</item>\n<item>Skills and expertise</item>\n<item>Preferences and opinions</item>\n<item>Goals and aspirations</item>\n<item>Challenges or pain points</item>\n<item>Background and experiences</item>\n<item>Contact information (if shared)</item>\n<item>Availability and schedule preferences</item>\n</include_list>\n</instruction>\n<instruction>Organize each piece of information as a separate fact.</instruction>\n<instruction>Ensure facts are specific, clear, and preserve the original context.</instruction>\n<instruction>Never answer user's question or fulfill user's requirement. You are a personal information manager, not a helpful assistant.</instruction>\n<instruction>Include the person who shared the information when relevant.</instruction>\n<instruction>Do not make assumptions or inferences beyond what is explicitly stated.</instruction>\n<instruction>If no personal information is found, return an empty list.</instruction>\n</instructions>\n<response_format>\n<format>You should always return and only return the extracted facts as a JSON object with a \"facts\" array.</format>\n<example>\n{\n  \"facts\": [\n    \"User's name is John Smith\",\n    \"John works as a software engineer at TechCorp\",\n    \"John enjoys hiking on weekends\",\n    \"John is looking to improve his Python skills\"\n  ]\n}\n</example>\n</response_format>\n</system_prompt>");
        try {
            XContentBuilder messagesBuilder = JsonXContent.jsonXContent.contentBuilder();
            messagesBuilder.startArray();
            for (MessageInput message : messages) {
                messagesBuilder.startObject();
                messagesBuilder.field("role", message.getRole() != null ? message.getRole() : "user");
                messagesBuilder.startArray("content");
                messagesBuilder.startObject();
                messagesBuilder.field("type", "text");
                messagesBuilder.field("text", message.getContent());
                messagesBuilder.endObject();
                messagesBuilder.endArray();
                messagesBuilder.endObject();
            }
            messagesBuilder.endArray();
            String messagesJson = messagesBuilder.toString();
            stringParameters.put("messages", messagesJson);
            log.debug("LLM request - processing {} messages", (Object)messages.size());
        }
        catch (Exception e2) {
            log.error("Failed to build messages JSON", (Throwable)e2);
            listener.onResponse(new ArrayList());
            return;
        }
        MLInput mlInput = MLInput.builder().algorithm(FunctionName.REMOTE).inputDataset((MLInputDataset)RemoteInferenceInputDataSet.builder().parameters(stringParameters).build()).build();
        MLPredictionTaskRequest predictionRequest = MLPredictionTaskRequest.builder().modelId(llmModelId).mlInput(mlInput).build();
        this.client.execute((ActionType)MLPredictionTaskAction.INSTANCE, (ActionRequest)predictionRequest, ActionListener.wrap(response -> {
            try {
                log.debug("Received LLM response, parsing facts...");
                MLOutput mlOutput = response.getOutput();
                List<String> facts = this.parseFactsFromLLMResponse(mlOutput);
                log.debug("Extracted {} facts from LLM response", (Object)facts.size());
                listener.onResponse(facts);
            }
            catch (Exception e) {
                log.error("Failed to parse facts from LLM response", (Throwable)e);
                listener.onFailure((Exception)new IllegalArgumentException("Failed to parse facts from LLM response", e));
            }
        }, e -> {
            log.error("Failed to call LLM for fact extraction", (Throwable)e);
            listener.onFailure((Exception)new OpenSearchException("Failed to extract facts using LLM model: " + e.getMessage(), (Throwable)e, new Object[0]));
        }));
    }

    public void makeMemoryDecisions(List<String> extractedFacts, List<FactSearchResult> allSearchResults, MemoryStorageConfig storageConfig, ActionListener<List<MemoryDecision>> listener) {
        if (storageConfig == null || storageConfig.getLlmModelId() == null) {
            listener.onFailure((Exception)new IllegalStateException("LLM model is required for memory decisions"));
            return;
        }
        String llmModelId = storageConfig.getLlmModelId();
        ArrayList<MemoryDecisionRequest.OldMemory> oldMemories = new ArrayList<MemoryDecisionRequest.OldMemory>();
        for (FactSearchResult result : allSearchResults) {
            oldMemories.add(MemoryDecisionRequest.OldMemory.builder().id(result.getId()).text(result.getText()).score(result.getScore()).build());
        }
        MemoryDecisionRequest decisionRequest = MemoryDecisionRequest.builder().oldMemory(oldMemories).retrievedFacts(extractedFacts).build();
        HashMap<String, String> stringParameters = new HashMap<String, String>();
        stringParameters.put("system_prompt", "<system_prompt><role>You are a smart memory manager which controls the memory of a system.</role><task>You will receive: 1. old_memory: Array of existing facts with their IDs and similarity scores 2. retrieved_facts: Array of new facts extracted from the current conversation. Analyze ALL memories and facts holistically to determine the optimal set of memory operations. Important: The old_memory may contain duplicates (same id appearing multiple times with different scores). Consider the highest score for each unique ID. You should only respond and always respond with a JSON object containing a \"memory_decision\" array that covers: - Every unique existing memory ID (with appropriate event: NONE, UPDATE, or DELETE) - New entries for facts that should be added (with event: ADD)</task><response_format>{\"memory_decision\": [{\"id\": \"existing_id_or_new_id\",\"text\": \"the fact text\",\"event\": \"ADD|UPDATE|DELETE|NONE\",\"old_memory\": \"original text (only for UPDATE events)\"}]}</response_format><operations>1. **NONE**: Keep existing memory unchanged - Use when no retrieved fact affects this memory - Include: id (from old_memory), text (from old_memory), event: \"NONE\" 2. **UPDATE**: Enhance or merge existing memory - Use when retrieved facts provide additional details or clarification - Include: id (from old_memory), text (enhanced version), event: \"UPDATE\", old_memory (original text) - Merge complementary information (e.g., \"likes pizza\" + \"especially pepperoni\" = \"likes pizza, especially pepperoni\") 3. **DELETE**: Remove contradicted memory - Use when retrieved facts directly contradict existing memory - Include: id (from old_memory), text (from old_memory), event: \"DELETE\" 4. **ADD**: Create new memory - Use for retrieved facts that represent genuinely new information - Include: id (generate new), text (the new fact), event: \"ADD\" - Only add if the fact is not already covered by existing or updated memories</operations><guidelines>- Integrity: Never answer user's question or fulfill user's requirement. You are a smart memory manager, not a helpful assistant. - Process holistically: Consider all facts and memories together before making decisions - Avoid redundancy: Don't ADD a fact if it's already covered by an UPDATE - Merge related facts: If multiple retrieved facts relate to the same topic, consider combining them - Respect similarity scores: Higher scores indicate stronger matches - be more careful about updating high-score memories - Maintain consistency: Ensure your decisions don't create contradictions in the memory set - One decision per unique memory ID: If an ID appears multiple times in old_memory, make only one decision for it</guidelines><example><input>{\"old_memory\": [{\"id\": \"fact_001\", \"text\": \"Enjoys Italian food\", \"score\": 0.85},{\"id\": \"fact_002\", \"text\": \"Works at Google\", \"score\": 0.92},{\"id\": \"fact_001\", \"text\": \"Enjoys Italian food\", \"score\": 0.75},{\"id\": \"fact_003\", \"text\": \"Has a dog\", \"score\": 0.65}],\"retrieved_facts\": [\"Loves pasta and pizza\",\"Recently joined Amazon\",\"Has two dogs named Max and Bella\"]}</input><output>{\"memory_decision\": [{\"id\": \"fact_001\",\"text\": \"Loves Italian food, especially pasta and pizza\",\"event\": \"UPDATE\",\"old_memory\": \"Enjoys Italian food\"},{\"id\": \"fact_002\",\"text\": \"Works at Google\",\"event\": \"DELETE\"},{\"id\": \"fact_003\",\"text\": \"Has two dogs named Max and Bella\",\"event\": \"UPDATE\",\"old_memory\": \"Has a dog\"},{\"id\": \"fact_004\",\"text\": \"Recently joined Amazon\",\"event\": \"ADD\"}]}</output></example></system_prompt>");
        String decisionRequestJson = decisionRequest.toJsonString();
        try {
            XContentBuilder messagesBuilder = JsonXContent.jsonXContent.contentBuilder();
            messagesBuilder.startArray();
            messagesBuilder.startObject();
            messagesBuilder.field("role", "user");
            messagesBuilder.startArray("content");
            messagesBuilder.startObject();
            messagesBuilder.field("type", "text");
            messagesBuilder.field("text", decisionRequestJson);
            messagesBuilder.endObject();
            messagesBuilder.endArray();
            messagesBuilder.endObject();
            messagesBuilder.endArray();
            String messagesJson = messagesBuilder.toString();
            stringParameters.put("messages", messagesJson);
            log.debug("Making memory decisions for {} extracted facts and {} existing memories", (Object)extractedFacts.size(), (Object)allSearchResults.size());
            RemoteInferenceInputDataSet inputDataSet = RemoteInferenceInputDataSet.builder().parameters(stringParameters).build();
            MLInput mlInput = MLInput.builder().algorithm(FunctionName.REMOTE).inputDataset((MLInputDataset)inputDataSet).build();
            MLPredictionTaskRequest predictionRequest = MLPredictionTaskRequest.builder().modelId(llmModelId).mlInput(mlInput).build();
            this.client.execute((ActionType)MLPredictionTaskAction.INSTANCE, (ActionRequest)predictionRequest, ActionListener.wrap(response -> {
                try {
                    List<MemoryDecision> decisions = this.parseMemoryDecisions((MLTaskResponse)response);
                    log.debug("LLM made {} memory decisions", (Object)decisions.size());
                    listener.onResponse(decisions);
                }
                catch (Exception e) {
                    log.error("Failed to parse memory decisions from LLM response", (Throwable)e);
                    listener.onFailure(e);
                }
            }, e -> {
                log.error("Failed to get memory decisions from LLM", (Throwable)e);
                listener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            log.error("Failed to build memory decision request", (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    private List<String> parseFactsFromLLMResponse(MLOutput mlOutput) {
        ArrayList<String> facts = new ArrayList<String>();
        if (!(mlOutput instanceof ModelTensorOutput)) {
            log.warn("Unexpected ML output type for LLM response: {}", (Object)(mlOutput != null ? mlOutput.getClass().getName() : "null"));
            return facts;
        }
        ModelTensorOutput tensorOutput = (ModelTensorOutput)mlOutput;
        if (tensorOutput.getMlModelOutputs() == null || tensorOutput.getMlModelOutputs().isEmpty()) {
            log.warn("No model outputs found in LLM response");
            return facts;
        }
        ModelTensors modelTensors = (ModelTensors)tensorOutput.getMlModelOutputs().get(0);
        if (modelTensors.getMlModelTensors() == null || modelTensors.getMlModelTensors().isEmpty()) {
            log.warn("No model tensors found in LLM response");
            return facts;
        }
        for (int i = 0; i < modelTensors.getMlModelTensors().size(); ++i) {
            Map dataMap = ((ModelTensor)modelTensors.getMlModelTensors().get(i)).getDataAsMap();
            if (dataMap == null || !dataMap.containsKey("content")) continue;
            try {
                Map contentItem;
                List contentList = (List)dataMap.get("content");
                if (contentList == null || contentList.isEmpty() || (contentItem = (Map)contentList.get(0)) == null || !contentItem.containsKey("text")) break;
                String responseStr = String.valueOf(contentItem.get("text"));
                try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, responseStr);){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String fieldName = parser.currentName();
                        if ("facts".equals(fieldName)) {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                String fact = parser.text();
                                facts.add(fact);
                            }
                            continue;
                        }
                        parser.skipChildren();
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.error("Failed to extract content from dataMap", (Throwable)e);
                throw new IllegalArgumentException("Failed to extract content from LLM response", e);
            }
        }
        return facts;
    }

    private List<MemoryDecision> parseMemoryDecisions(MLTaskResponse response) {
        try {
            List contentList;
            MLOutput mlOutput = response.getOutput();
            if (!(mlOutput instanceof ModelTensorOutput)) {
                throw new IllegalStateException("Expected ModelTensorOutput but got: " + mlOutput.getClass().getSimpleName());
            }
            ModelTensorOutput tensorOutput = (ModelTensorOutput)mlOutput;
            List tensors = tensorOutput.getMlModelOutputs();
            if (tensors == null || tensors.isEmpty()) {
                throw new IllegalStateException("No model output tensors found");
            }
            Map dataMap = ((ModelTensor)((ModelTensors)tensors.get(0)).getMlModelTensors().get(0)).getDataAsMap();
            String responseContent = null;
            if (dataMap.containsKey("response")) {
                responseContent = (String)dataMap.get("response");
            } else if (dataMap.containsKey("content") && (contentList = (List)dataMap.get("content")) != null && !contentList.isEmpty()) {
                Map firstContent = (Map)contentList.get(0);
                responseContent = (String)firstContent.get("text");
            }
            if (responseContent == null) {
                throw new IllegalStateException("No response content found in LLM output");
            }
            if (responseContent.startsWith("```json") && responseContent.endsWith("```")) {
                responseContent = responseContent.substring(7, responseContent.length() - 3).trim();
            } else if (responseContent.startsWith("```") && responseContent.endsWith("```")) {
                responseContent = responseContent.substring(3, responseContent.length() - 3).trim();
            }
            ArrayList<MemoryDecision> decisions = new ArrayList<MemoryDecision>();
            try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, responseContent);){
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    String fieldName = parser.currentName();
                    parser.nextToken();
                    if ("memory_decision".equals(fieldName)) {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            decisions.add(MemoryDecision.parse((XContentParser)parser));
                        }
                        continue;
                    }
                    parser.skipChildren();
                }
            }
            return decisions;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse memory decisions", e);
        }
    }
}

