/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import software.amazon.cryptography.primitives.model.DigestAlgorithm;

public class KdfCtrInput {
    private final DigestAlgorithm digestAlgorithm;
    private final ByteBuffer ikm;
    private final int expectedLength;
    private final ByteBuffer purpose;
    private final ByteBuffer nonce;

    protected KdfCtrInput(BuilderImpl builder) {
        this.digestAlgorithm = builder.digestAlgorithm();
        this.ikm = builder.ikm();
        this.expectedLength = builder.expectedLength();
        this.purpose = builder.purpose();
        this.nonce = builder.nonce();
    }

    public DigestAlgorithm digestAlgorithm() {
        return this.digestAlgorithm;
    }

    public ByteBuffer ikm() {
        return this.ikm;
    }

    public int expectedLength() {
        return this.expectedLength;
    }

    public ByteBuffer purpose() {
        return this.purpose;
    }

    public ByteBuffer nonce() {
        return this.nonce;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected DigestAlgorithm digestAlgorithm;
        protected ByteBuffer ikm;
        protected int expectedLength;
        private boolean _expectedLengthSet = false;
        protected ByteBuffer purpose;
        protected ByteBuffer nonce;

        protected BuilderImpl() {
        }

        protected BuilderImpl(KdfCtrInput model) {
            this.digestAlgorithm = model.digestAlgorithm();
            this.ikm = model.ikm();
            this.expectedLength = model.expectedLength();
            this._expectedLengthSet = true;
            this.purpose = model.purpose();
            this.nonce = model.nonce();
        }

        @Override
        public Builder digestAlgorithm(DigestAlgorithm digestAlgorithm) {
            this.digestAlgorithm = digestAlgorithm;
            return this;
        }

        @Override
        public DigestAlgorithm digestAlgorithm() {
            return this.digestAlgorithm;
        }

        @Override
        public Builder ikm(ByteBuffer ikm) {
            this.ikm = ikm;
            return this;
        }

        @Override
        public ByteBuffer ikm() {
            return this.ikm;
        }

        @Override
        public Builder expectedLength(int expectedLength) {
            this.expectedLength = expectedLength;
            this._expectedLengthSet = true;
            return this;
        }

        @Override
        public int expectedLength() {
            return this.expectedLength;
        }

        @Override
        public Builder purpose(ByteBuffer purpose) {
            this.purpose = purpose;
            return this;
        }

        @Override
        public ByteBuffer purpose() {
            return this.purpose;
        }

        @Override
        public Builder nonce(ByteBuffer nonce) {
            this.nonce = nonce;
            return this;
        }

        @Override
        public ByteBuffer nonce() {
            return this.nonce;
        }

        @Override
        public KdfCtrInput build() {
            if (Objects.isNull((Object)this.digestAlgorithm())) {
                throw new IllegalArgumentException("Missing value for required field `digestAlgorithm`");
            }
            if (Objects.isNull(this.ikm())) {
                throw new IllegalArgumentException("Missing value for required field `ikm`");
            }
            if (!this._expectedLengthSet) {
                throw new IllegalArgumentException("Missing value for required field `expectedLength`");
            }
            if (this._expectedLengthSet && this.expectedLength() < 0) {
                throw new IllegalArgumentException("`expectedLength` must be greater than or equal to 0");
            }
            return new KdfCtrInput(this);
        }
    }

    public static interface Builder {
        public Builder digestAlgorithm(DigestAlgorithm var1);

        public DigestAlgorithm digestAlgorithm();

        public Builder ikm(ByteBuffer var1);

        public ByteBuffer ikm();

        public Builder expectedLength(int var1);

        public int expectedLength();

        public Builder purpose(ByteBuffer var1);

        public ByteBuffer purpose();

        public Builder nonce(ByteBuffer var1);

        public ByteBuffer nonce();

        public KdfCtrInput build();
    }
}

