/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class DeriveSharedSecretOutput {
    private final ByteBuffer sharedSecret;

    protected DeriveSharedSecretOutput(BuilderImpl builder) {
        this.sharedSecret = builder.sharedSecret();
    }

    public ByteBuffer sharedSecret() {
        return this.sharedSecret;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ByteBuffer sharedSecret;

        protected BuilderImpl() {
        }

        protected BuilderImpl(DeriveSharedSecretOutput model) {
            this.sharedSecret = model.sharedSecret();
        }

        @Override
        public Builder sharedSecret(ByteBuffer sharedSecret) {
            this.sharedSecret = sharedSecret;
            return this;
        }

        @Override
        public ByteBuffer sharedSecret() {
            return this.sharedSecret;
        }

        @Override
        public DeriveSharedSecretOutput build() {
            if (Objects.isNull(this.sharedSecret())) {
                throw new IllegalArgumentException("Missing value for required field `sharedSecret`");
            }
            return new DeriveSharedSecretOutput(this);
        }
    }

    public static interface Builder {
        public Builder sharedSecret(ByteBuffer var1);

        public ByteBuffer sharedSecret();

        public DeriveSharedSecretOutput build();
    }
}

