/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.util.Objects;
import software.amazon.cryptography.primitives.model.ECCPrivateKey;
import software.amazon.cryptography.primitives.model.ECCPublicKey;
import software.amazon.cryptography.primitives.model.ECDHCurveSpec;

public class DeriveSharedSecretInput {
    private final ECDHCurveSpec eccCurve;
    private final ECCPrivateKey privateKey;
    private final ECCPublicKey publicKey;

    protected DeriveSharedSecretInput(BuilderImpl builder) {
        this.eccCurve = builder.eccCurve();
        this.privateKey = builder.privateKey();
        this.publicKey = builder.publicKey();
    }

    public ECDHCurveSpec eccCurve() {
        return this.eccCurve;
    }

    public ECCPrivateKey privateKey() {
        return this.privateKey;
    }

    public ECCPublicKey publicKey() {
        return this.publicKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ECDHCurveSpec eccCurve;
        protected ECCPrivateKey privateKey;
        protected ECCPublicKey publicKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(DeriveSharedSecretInput model) {
            this.eccCurve = model.eccCurve();
            this.privateKey = model.privateKey();
            this.publicKey = model.publicKey();
        }

        @Override
        public Builder eccCurve(ECDHCurveSpec eccCurve) {
            this.eccCurve = eccCurve;
            return this;
        }

        @Override
        public ECDHCurveSpec eccCurve() {
            return this.eccCurve;
        }

        @Override
        public Builder privateKey(ECCPrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @Override
        public ECCPrivateKey privateKey() {
            return this.privateKey;
        }

        @Override
        public Builder publicKey(ECCPublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Override
        public ECCPublicKey publicKey() {
            return this.publicKey;
        }

        @Override
        public DeriveSharedSecretInput build() {
            if (Objects.isNull((Object)this.eccCurve())) {
                throw new IllegalArgumentException("Missing value for required field `eccCurve`");
            }
            if (Objects.isNull(this.privateKey())) {
                throw new IllegalArgumentException("Missing value for required field `privateKey`");
            }
            if (Objects.isNull(this.publicKey())) {
                throw new IllegalArgumentException("Missing value for required field `publicKey`");
            }
            return new DeriveSharedSecretInput(this);
        }
    }

    public static interface Builder {
        public Builder eccCurve(ECDHCurveSpec var1);

        public ECDHCurveSpec eccCurve();

        public Builder privateKey(ECCPrivateKey var1);

        public ECCPrivateKey privateKey();

        public Builder publicKey(ECCPublicKey var1);

        public ECCPublicKey publicKey();

        public DeriveSharedSecretInput build();
    }
}

