/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import software.amazon.cryptography.materialproviders.model.TimeUnits;

public class StormTrackingCache {
    private final int entryCapacity;
    private final int entryPruningTailSize;
    private final int gracePeriod;
    private final int graceInterval;
    private final int fanOut;
    private final int inFlightTTL;
    private final int sleepMilli;
    private final TimeUnits timeUnits;

    protected StormTrackingCache(BuilderImpl builder) {
        this.entryCapacity = builder.entryCapacity();
        this.entryPruningTailSize = builder.entryPruningTailSize();
        this.gracePeriod = builder.gracePeriod();
        this.graceInterval = builder.graceInterval();
        this.fanOut = builder.fanOut();
        this.inFlightTTL = builder.inFlightTTL();
        this.sleepMilli = builder.sleepMilli();
        this.timeUnits = builder.timeUnits();
    }

    public int entryCapacity() {
        return this.entryCapacity;
    }

    public int entryPruningTailSize() {
        return this.entryPruningTailSize;
    }

    public int gracePeriod() {
        return this.gracePeriod;
    }

    public int graceInterval() {
        return this.graceInterval;
    }

    public int fanOut() {
        return this.fanOut;
    }

    public int inFlightTTL() {
        return this.inFlightTTL;
    }

    public int sleepMilli() {
        return this.sleepMilli;
    }

    public TimeUnits timeUnits() {
        return this.timeUnits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected int entryCapacity;
        private boolean _entryCapacitySet = false;
        protected int entryPruningTailSize;
        private boolean _entryPruningTailSizeSet = false;
        protected int gracePeriod;
        private boolean _gracePeriodSet = false;
        protected int graceInterval;
        private boolean _graceIntervalSet = false;
        protected int fanOut;
        private boolean _fanOutSet = false;
        protected int inFlightTTL;
        private boolean _inFlightTTLSet = false;
        protected int sleepMilli;
        private boolean _sleepMilliSet = false;
        protected TimeUnits timeUnits;

        protected BuilderImpl() {
        }

        protected BuilderImpl(StormTrackingCache model) {
            this.entryCapacity = model.entryCapacity();
            this._entryCapacitySet = true;
            this.entryPruningTailSize = model.entryPruningTailSize();
            this._entryPruningTailSizeSet = true;
            this.gracePeriod = model.gracePeriod();
            this._gracePeriodSet = true;
            this.graceInterval = model.graceInterval();
            this._graceIntervalSet = true;
            this.fanOut = model.fanOut();
            this._fanOutSet = true;
            this.inFlightTTL = model.inFlightTTL();
            this._inFlightTTLSet = true;
            this.sleepMilli = model.sleepMilli();
            this._sleepMilliSet = true;
            this.timeUnits = model.timeUnits();
        }

        @Override
        public Builder entryCapacity(int entryCapacity) {
            this.entryCapacity = entryCapacity;
            this._entryCapacitySet = true;
            return this;
        }

        @Override
        public int entryCapacity() {
            return this.entryCapacity;
        }

        @Override
        public Builder entryPruningTailSize(int entryPruningTailSize) {
            this.entryPruningTailSize = entryPruningTailSize;
            this._entryPruningTailSizeSet = true;
            return this;
        }

        @Override
        public int entryPruningTailSize() {
            return this.entryPruningTailSize;
        }

        @Override
        public Builder gracePeriod(int gracePeriod) {
            this.gracePeriod = gracePeriod;
            this._gracePeriodSet = true;
            return this;
        }

        @Override
        public int gracePeriod() {
            return this.gracePeriod;
        }

        @Override
        public Builder graceInterval(int graceInterval) {
            this.graceInterval = graceInterval;
            this._graceIntervalSet = true;
            return this;
        }

        @Override
        public int graceInterval() {
            return this.graceInterval;
        }

        @Override
        public Builder fanOut(int fanOut) {
            this.fanOut = fanOut;
            this._fanOutSet = true;
            return this;
        }

        @Override
        public int fanOut() {
            return this.fanOut;
        }

        @Override
        public Builder inFlightTTL(int inFlightTTL) {
            this.inFlightTTL = inFlightTTL;
            this._inFlightTTLSet = true;
            return this;
        }

        @Override
        public int inFlightTTL() {
            return this.inFlightTTL;
        }

        @Override
        public Builder sleepMilli(int sleepMilli) {
            this.sleepMilli = sleepMilli;
            this._sleepMilliSet = true;
            return this;
        }

        @Override
        public int sleepMilli() {
            return this.sleepMilli;
        }

        @Override
        public Builder timeUnits(TimeUnits timeUnits) {
            this.timeUnits = timeUnits;
            return this;
        }

        @Override
        public TimeUnits timeUnits() {
            return this.timeUnits;
        }

        @Override
        public StormTrackingCache build() {
            if (!this._entryCapacitySet) {
                throw new IllegalArgumentException("Missing value for required field `entryCapacity`");
            }
            if (this._entryCapacitySet && this.entryCapacity() < 1) {
                throw new IllegalArgumentException("`entryCapacity` must be greater than or equal to 1");
            }
            if (this._entryPruningTailSizeSet && this.entryPruningTailSize() < 1) {
                throw new IllegalArgumentException("`entryPruningTailSize` must be greater than or equal to 1");
            }
            if (!this._gracePeriodSet) {
                throw new IllegalArgumentException("Missing value for required field `gracePeriod`");
            }
            if (this._gracePeriodSet && this.gracePeriod() < 1) {
                throw new IllegalArgumentException("`gracePeriod` must be greater than or equal to 1");
            }
            if (!this._graceIntervalSet) {
                throw new IllegalArgumentException("Missing value for required field `graceInterval`");
            }
            if (this._graceIntervalSet && this.graceInterval() < 1) {
                throw new IllegalArgumentException("`graceInterval` must be greater than or equal to 1");
            }
            if (!this._fanOutSet) {
                throw new IllegalArgumentException("Missing value for required field `fanOut`");
            }
            if (this._fanOutSet && this.fanOut() < 1) {
                throw new IllegalArgumentException("`fanOut` must be greater than or equal to 1");
            }
            if (!this._inFlightTTLSet) {
                throw new IllegalArgumentException("Missing value for required field `inFlightTTL`");
            }
            if (this._inFlightTTLSet && this.inFlightTTL() < 1) {
                throw new IllegalArgumentException("`inFlightTTL` must be greater than or equal to 1");
            }
            if (!this._sleepMilliSet) {
                throw new IllegalArgumentException("Missing value for required field `sleepMilli`");
            }
            if (this._sleepMilliSet && this.sleepMilli() < 1) {
                throw new IllegalArgumentException("`sleepMilli` must be greater than or equal to 1");
            }
            return new StormTrackingCache(this);
        }
    }

    public static interface Builder {
        public Builder entryCapacity(int var1);

        public int entryCapacity();

        public Builder entryPruningTailSize(int var1);

        public int entryPruningTailSize();

        public Builder gracePeriod(int var1);

        public int gracePeriod();

        public Builder graceInterval(int var1);

        public int graceInterval();

        public Builder fanOut(int var1);

        public int fanOut();

        public Builder inFlightTTL(int var1);

        public int inFlightTTL();

        public Builder sleepMilli(int var1);

        public int sleepMilli();

        public Builder timeUnits(TimeUnits var1);

        public TimeUnits timeUnits();

        public StormTrackingCache build();
    }
}

